//============================================================================================
/**
 * @file		bag_touchbar.cpp
 * @brief		obO ^b`o[
 * @author	Hiroyuki Nakamura
 * @date		12.10.10
 *
 * namespace	app::bag::
 */
//============================================================================================
#include "bag_res_pane.h"
#include "bag_touchbar.h"
#include "bag_snd_def.h"

namespace app {
namespace bag {

static const app::ui::UITouchBarView::SETUP BagTouchBarSetup[] =
{
	{ app::ui::UITouchBarView::BUTTON_ID_HISTORY,		PANENAME_BAG_LOWER_PANE_RIREKI_POS },				// 
	{ app::ui::UITouchBarView::BUTTON_ID_SORT,			PANENAME_BAG_LOWER_PANE_SORT_POS },					// \[g
	{ app::ui::UITouchBarView::BUTTON_ID_EXIT,			PANENAME_BAG_LOWER_PANE_EXIT_ICON_POS },		// ~{^
	{ app::ui::UITouchBarView::BUTTON_ID_RETURN,		PANENAME_BAG_LOWER_PANE_RETURN_ICON_POS },	// ߂{^
};


TouchBar::TouchBar(
		app::util::Heap * heap,
		gfl::grp::GraphicsSystem * grasys,
		gfl::grp::g2d::LytSys * lytsys,
		gfl::grp::g2d::LytWk * lytwk ) :
	app::ui::UITouchBarView( heap, grasys, lytsys, lytwk, BagTouchBarSetup, GFL_NELEMS(BagTouchBarSetup) ),
	retParam( PRM_NONE )
{
	app::ui::UITouchBarView::SetListener( this );
	app::ui::UITouchBarView::SetVisibleBar( false );
  app::ui::UITouchBarView::SetBindKey( app::ui::UITouchBarView::BUTTON_ID_SORT, gfl::ui::BUTTON_START );
  app::ui::UITouchBarView::SetSelectSE( app::ui::UITouchBarView::BUTTON_ID_SORT, BAG_SE_DECIDE );
  app::ui::UITouchBarView::SetSelectSE( app::ui::UITouchBarView::BUTTON_ID_HISTORY, BAG_SE_DECIDE );
}

TouchBar::~TouchBar()
{
}

u32 TouchBar::GetParam(void)
{
	return retParam;
}

void TouchBar::Update(void)
{
	retParam = PRM_NONE;

	app::ui::UITouchBarView::Update();

	if( app::ui::UITouchBarView::IsButtonAnimation() == true ){
		if( retParam == PRM_NONE ){
			retParam = PRM_HOLD;
		}
	}
}

void TouchBar::SetVisible( u32 buttonID, bool flg )
{
	app::ui::UITouchBarView::SetVisible( buttonID, flg );
}

void TouchBar::SetActive( u32 buttonID, bool flg )
{
	app::ui::UITouchBarView::SetActive( buttonID, flg );
}

void TouchBar::SelectKeyButton( u32 prm )
{
	u32	buttonID;

	switch( prm ){
	case PRM_SELECT_EXIT:		// ~{^
		buttonID = app::ui::UITouchBarView::BUTTON_ID_EXIT;
		break;
	case PRM_SELECT_RETURN:	// ߂{^
		buttonID = app::ui::UITouchBarView::BUTTON_ID_RETURN;
		break;
	case PRM_SELECT_HISTORY:	// 
		buttonID = app::ui::UITouchBarView::BUTTON_ID_HISTORY;
		break;
	case PRM_SELECT_SORT:			// \[g
		buttonID = app::ui::UITouchBarView::BUTTON_ID_SORT;
		break;
	default:
		GFL_ASSERT( 0 );
		return;
	}

	app::ui::UITouchBarView::StartSelectedAct( buttonID );
}



bool TouchBar::OnSelectedButton( u32 buttonID )
{
	switch( buttonID ){
	case app::ui::UITouchBarView::BUTTON_ID_EXIT:			// ~{^
		retParam = PRM_SELECT_EXIT;
		break;
	case app::ui::UITouchBarView::BUTTON_ID_RETURN:		// ߂{^
		retParam = PRM_SELECT_RETURN;
		break;
	case app::ui::UITouchBarView::BUTTON_ID_HISTORY:	// T[`
		retParam = PRM_SELECT_HISTORY;
		break;
	case app::ui::UITouchBarView::BUTTON_ID_SORT:			// [hؑփ{^
		retParam = PRM_SELECT_SORT;
		break;
	}
	return false;
}


}	// bag
}	// app
