//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_zukan_IIProcManager.cpp
 *	@brief
 *	@author	Toru=Nagihashi
 *	@date		2012.05.18
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "app_zukan_IProcManager.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(zukan)

//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 * @brief RXgN^
 * @param heap q[v
 * @param data_manager  f[^}l[W[
 * @param graphics  OtBbN}l[W[
 * @param start_proc_id JnPROC_ID
 */
IProcManager::IProcManager( app::util::Heap* heap, DataManager* data_manager, Graphics * graphics, ProcID start_proc_id ) :
  gfl::proc::Manager( heap->GetSystemHeap() ),
  m_heap( heap ),
  m_data_manager( data_manager ),
  m_graphics( graphics ),
  m_next_proc_id( start_proc_id ),
  m_is_end( false ),
  m_is_start( true )
{
}
/**
 *  @brief  fXgN^
 */
IProcManager::~IProcManager()
{
}


//-----------------------------------------------------------------------
// VXe
//-----------------------------------------------------------------------
/**
 * @brief XV
 */
void IProcManager::Update(void)
{
  m_status = this->gfl::proc::Manager::Main();

  //PProcIāA\񂪂Ύڂɂ
  if( m_status == gfl::proc::MAINSTATUS_NULL && m_is_end == false )
  {
    if( m_next_proc_id != PROC_ID_NULL )
    {
      IProc *proc = this->CreateCallProc();
      if( m_is_start )
      {
        proc->SetFadeInMode( IProc::FADE_SYSTEM );  //ŏ̓VXetF[h
        m_is_start  = false;
      }
      proc->SetGameProcManager( m_data_manager->GetGameProcManager() );
      this->CallProc( proc );
      m_next_proc_id = PROC_ID_NULL;
    }
  }
}


/**
 * @brief `
 */
void IProcManager::Draw(void)
{
  this->gfl::proc::Manager::Draw();
}

/**
 * @brief ProcNĂ邩`FbN
 * @retval  true  NĂȂ
 * @retval  false PłN
 */
bool IProcManager::IsEnd(void) const
{
  return m_is_end && m_status == gfl::proc::MAINSTATUS_NULL;
}

/**
 * @brief sProcݒ
 * @note  ݒ肹ProcIƃAT[gɂȂ܂
 */
void IProcManager::SetNextProc( ProcID proc_id )
{
  m_next_proc_id = proc_id;
}
/**
 * @brief I(SetNextProcĂĂI܂)
 */
void IProcManager::End( void )
{
  m_is_end = true;
}

//-----------------------------------------------------------------------
// Getter
//-----------------------------------------------------------------------
/**
 * @brief f[^}l[W[擾
 * @retval  f[^}l[W[
 */
DataManager * IProcManager::GetDataManager(void) const
{
  return m_data_manager;
}

/**
 * @brief OtBbN}l[W[擾
 * @retval  OtBbN}l[W[
 */
Graphics * IProcManager::GetGraphics(void) const
{
  return m_graphics;
}

/**
 * @brief ̃vZXID擾
 *
 * @return  ̃vZXID
 */
IProcManager::ProcID IProcManager::GetNextProcID( void ) const
{
  return m_next_proc_id;
}

/**
 * @brief q[v擾
 *
 * @return q[v
 */
app::util::Heap* IProcManager::GetHeap( void ) const
{
  return m_heap;
}

//-----------------------------------------------------------------------
// private
//-----------------------------------------------------------------------
/**
 * @brief vZX̏
 *
 * @return 
 */
bool IProcManager::procMain(void)
{	
  gfl::proc::Result result;
  IProc *proc = static_cast<IProc*>(this->GetMainHandleBaseProcess());

	switch ( this->GetMainHandleProcSeq() ) {
	case gfl::proc::SEQ_LOAD:
    this->SetMainHandleProcSeq( gfl::proc::SEQ_INIT );
		/* fall through */
  case gfl::proc::SEQ_INIT:
		result = proc->InitFunc(this);
		if (result == gfl::proc::RES_FINISH) {
      this->SetMainHandleProcSeq( static_cast<gfl::proc::ProcSeq>(SEQ_FADEIN) );
			proc->ResetSubSeq();
		}
		break;
      
  case SEQ_FADEIN:
    this->SetDrawFlag( true );
		result = proc->FadeInFunc(this);
		if (result == gfl::proc::RES_FINISH) {
      this->SetMainHandleProcSeq( gfl::proc::SEQ_MAIN );
			proc->ResetSubSeq();
		}
    break;

	case gfl::proc::SEQ_MAIN:
		result = proc->UpdateFunc(this);

		if (result == gfl::proc::RES_FINISH) {
      this->SetMainHandleProcSeq( static_cast<gfl::proc::ProcSeq>( SEQ_FADEOUT ) );
			proc->ResetSubSeq();
		}
		break;
    
  case SEQ_FADEOUT:
		result = proc->FadeOutFunc(this);
		if (result == gfl::proc::RES_FINISH) {
      this->SetMainHandleProcSeq( gfl::proc::SEQ_END );
      proc->ResetSubSeq();
		}
    break;

	case gfl::proc::SEQ_END:
    this->SetDrawFlag( false );
		result = proc->EndFunc(this);
		if (result == gfl::proc::RES_FINISH) {
      this->SetMainHandleProcSeq( gfl::proc::SEQ_UNLOAD );
      return true;
		}
		break;
	}
	return false;
}

GFL_NAMESPACE_END(zukan)
GFL_NAMESPACE_END(app)
