﻿/*---------------------------------------------------------------------------*
  Project:  Horizon
  File:     wave.h

  Copyright (C)2009 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  $Rev: 23146 $
 *---------------------------------------------------------------------------*/

#ifndef __WAVE_HEADER__
#define __WAVE_HEADER__

/* constants */


/*---------------------------------------------------------------------------*/
/* typedef */
typedef struct _riff
{
    u32 tag;
    u32 size;
    u32 type;
}
WaveRiff;

typedef struct _chunk
{
    u32 tag;
    u32 size;
}
WaveChunk;

typedef struct _fmt
{
    u16 fmt_id;
    u16 channel;
    u32 sample_rate;
    u32 trans_rate;
    u16 block_size;
    u16 quantum_bits;
}
WaveFmt;

typedef struct _data
{
    u32 size;
    u8* buf;
}
WaveData;

#if 0  //0
/*---------------------------------------------------------------------------*/
/* prototype */

void LoadWaveCore(nn::fs::FileReader&, WaveFmt*, WaveData*, bool);
static inline void LoadWave(nn::fs::FileReader& reader, WaveFmt* fmt, WaveData* data)
{
    LoadWaveCore(reader, fmt, data, false);
}
static inline int GetWaveLength(nn::fs::FileReader& reader)
{
    WaveFmt fmt;
    WaveData data;
    LoadWaveCore(reader, &fmt, &data, true);
    return data.size;
}
#ifndef NN_BUILD_RELEASE  // Release ビルドでは HostIO は使えません。
void WriteWaveHeader(nn::hio::CTR::HostFile& hostFile, WaveFmt* fmt, s32 size);
#endif // NN_BUILD_RELEASE
#endif  //0

#endif // __WAVE_HEADER__

/*---------------------------------------------------------------------------*/
/* end of file */
/*---------------------------------------------------------------------------*/
