#ifndef __XYNETVCT_H__
#define __XYNETVCT_H__
//================================================================================
/**
 * @file   XyNetVct.h
 * @brief  {CX`bgCu
 * @author k.ohno
 * @date   2012.10.07
 */
//================================================================================
#include <gflib.h>
#include <gflnet.h>
#include <mw/vct/vct.h>
#include "net/net_define.h"



GFL_NAMESPACE_BEGIN(xynet)
GFL_NAMESPACE_BEGIN(vct)


class SndMicDevice;

class XyNetVct  {
  GFL_FORBID_COPY_AND_ASSIGN( XyNetVct );



  class VCTRecvDataListener : public gflnet::p2p::RecvDataListener
    {
    public:
      VCTRecvDataListener(void){};
      
      virtual void ReceiveCallback( nn::nex::ConnectionID srcCID, qByte* buffer, qUnsignedInt32 size ){
        VCT_HandleData( srcCID,  buffer, size );
      }
    };



  
public:
  XyNetVct(void);
  virtual ~XyNetVct();

  void Initialize(gfl::heap::HeapBase* pBase);
  void Finalize(void);


  bool Start(void);
  bool StartConference(void);
  void Pause(void);
  bool StopConference(void);
  bool End(void);
  void Main(void);

  void SignalNoiseSkip(void);  //pbhAL[̉EȂ悤Ƀv`~֐

  
  void SetCID(int index,u32 cid);
  gflnet::p2p::RecvDataListener* GetVCTRecvDataListener(void){return mpVCTRecvDataListener;};
  
private:

  static const int VCT_MAX_CONNECT = 4;
  static const int LIMITSEND_BUFFER  = 4096;
  static const int SENDHEAD_SIZE  = sizeof(gflnet::p2p::SendHead);
  
  static const int MAXSEND_BUFFER  = LIMITSEND_BUFFER + SENDHEAD_SIZE;

  
  VCTSession s_session[VCT_MAX_CONNECT];

  /* net inforomation. */
  struct _net_info{
    u32 CIDList[VCT_MAX_CONNECT];  /* connect aid bitmap.       */
    u32 connectionNum;             /* connect num.              */
    u32 owner_pid;                 /* owner PID info.           */
    u32 my_pid;                    /* my PID info.              */
    u32 my_cid;                    /* my ConnectionID info.     */
  };

  _net_info mNetInfo;
  
  bool mbStart;

  SndMicDevice* p_SndMicDevice;
  u32 s_MyCID;
  u8 s_VADValue;
  VCTConfig s_vctConfig;
  u8* mpAudioBuffer;

  VCTRecvDataListener* mpVCTRecvDataListener;
  
  static u8* mpSendTempBuffer;


  static void EventCallback( u16 cid, VCTEvent result, VCTSession *session, void *param );
  static bool SendDataCallBack( u16 cid, const void *buff, u32 size, bool isReliable );

  
};


GFL_NAMESPACE_END(vct)
GFL_NAMESPACE_END(xynet)

#endif// __XYNETVCT_H__




