//==============================================================================
/**
 * @file	friend_entry_dialog_view.cpp
 * @brief	tho^	OtBbN
 * @author	ichiraku_katsuhiko(x[X̂)
 * @data	2012/09/03, 14:56
 */
// =============================================================================

#include "friend_entry_dialog_view.h"
#include "friend_entry_res.h"
#include "friend_entry_res_pane.h"

#include <app/dialog_common/dialog_common_res.h>
#include <app/dialog_common/dialog_common_res_pane.h>
#include "common_res/msg_window_res.h"
#include <arc/arc_def.h>
#include <message/message.gaix>
#include <message/msg_friend_entry.h>

GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(friend_entry)


// A[JCuIDe[u
static const u32 DIALOG_COMMON_RES_ADD_MAX = LYTRES_MSG_WINDOW_RES_END;
static const app::util::G2DUtil::LYT_RES_DATA DIALOG_RES_TABLE[]={
	{ ARCID_DIALOG_COMMON,		0, DIALOG_COMMON_RES_ADD_MAX, app::util::G2DUtil::ATTACH_ROOT     },
	{ ARCID_COMMON_MSGWINDOW, 0,												 0, app::util::G2DUtil::ATTACH_RESOURCE }, // 01: ʃ\[X: bZ[WEBhE
};

//CAEgp[^
static const app::util::G2DUtil::LYTWK_DATA DIALOG_LAYOUT_DATA[] =
{
	
	{	// 
		DialogViewWork::LAYOUT_ID_UPPER,
		LYTRES_DIALOG_COMMON_RES_DAILOG_UPPER_BCLYT,			// resID̃CAEgf[^ID
		NULL,																				// Aj[Vf[^IDe[u	AĵȂꍇNULL
		0,																					// Aj[Vf[^IDe[u AĵȂꍇ0
		0,																					// o^Aj[Vő吔
		false,																			// \yCɍsvZs
		app::util::G2DUtil::SETUP_UPPER,						// fBXvC
		true,																				// \ݒ
	},
};

// bZ[WEChEpyC
static const gfl::grp::g2d::LytPaneIndex MESSAGE_WINDOW_UPPER[] =
{
	PANENAME_DAILOG_UPPER_PANE_TEXTBOX_01,
	PANENAME_DAILOG_UPPER_PANE_TEXTBOX_02,
};
//bZ[WJ[\pyC
static const gfl::grp::g2d::LytPaneIndex MESSAGE_CURSOR_UPPER[] = 
{
	PANENAME_DAILOG_UPPER_PANE_WINDOW_00,
	PANENAME_DAILOG_UPPER_PANE_TEXTBOX_02,
};

//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
/*
msg_friend_entry_01_01	Large	ʏeLXg	"thXgɁ@Ƃ낭
Ă@^b`ā@"		"thXgɁ@o^
@^b`ā@"	
msg_friend_entry_01_02	Large	ʏeLXg	"[Name:TrainerName ]
ƂR[h@Ƃ낭@܂I"	"0FvC[
"	"[Name:TrainerName ]
ƂR[h@o^܂I"	
msg_friend_entry_01_03	Large	ʏeLXg	"Ắ@ւ񂶂@܂Ă܂
΂炭@܂@"		"́@Ԏ@҂Ă܂
΂炭@҂"	
msg_friend_entry_01_04	Large	ʏeLXg	"[Name:TrainerName ]
Ƃ낭@ł܂ł"	"0FvC[
"	"[Name:TrainerName ]
o^ł܂ł"	
msg_friend_entry_01_05	Large	ʏeLXg	΂炭@܂@		΂炭@҂	
msg_friend_entry_01_06	Large	ʏeLXg	"thXg@ςł
Ƃ@Ƃ낭@ł܂"		"thXg@ςł
FB@o^ł܂"	
msg_friend_entry_02_01	Large	ʏeLXg	[Name:TrainerName ]	"0Fo[̃vC[
jFF
FԐF"	[Name:TrainerName ]	
msg_friend_entry_02_02	Large	ʏeLXg	ց@		ց@	
msg_friend_entry_02_03	Large	ʏeLXg	Ƃ낭@		Ƃ낭@	

*/

//--------------------------------------------------------------------------
/**
 * @brief		// RXgN^
 */
//--------------------------------------------------------------------------
DialogViewWork::DialogViewWork( app::util::Heap * heap )
: app::ui::UIView( heap, heap->pDevHeapAllocator, heap->pDevHeapAllocator )
, m_pHeap( heap )
, m_isMessageWait( false )
, m_pTimeIcon(NULL)
{
	CreateGraphicsSystem( NULL , false );
	Initialize2D( heap );
	
	//bZ[WEBhE쐬
	m_g2dUtil->CreateMessageWindow( GFL_SINGLETON_INSTANCE(gamesystem::GameManager)->GetUiDeviceManager() , LAYOUT_ID_UPPER, MESSAGE_WINDOW_UPPER, m_pHeap );
	m_g2dUtil->CreateMsgCursor( GetGraphicSystem() , gfl::grp::DISPLAY_UPPER, LAYOUT_ID_UPPER, MESSAGE_CURSOR_UPPER, m_pHeap );
	
	//^C}[ACR
	app::tool::TimeIcon::CREATE_DATA initData;
	initData.heap           = m_pHeap->pHeap;
	initData.devHeap        = m_pHeap->pDevHeap;
	initData.devAllocator   = m_pHeap->pDevHeapAllocator;
	initData.graSys         = GetGraphicSystem();
	initData.lytSys         = GetLayoutSystem();
	initData.setup          = *(m_g2dUtil->GetLayoutWorkSetup( gfl::grp::DISPLAY_UPPER ));//ςƉʂɂȂ
	initData.threadPriority = gfl::base::Thread::DefaultPriority;
	initData.pos            = GetPanePos( LAYOUT_ID_UPPER , PANENAME_DAILOG_UPPER_PANE_TIMER_POS_00 );//vACȐꏊ
	initData.isAutoDraw     = false;
	
	m_pTimeIcon = GFL_NEW( m_pHeap->pHeap ) app::tool::TimeIcon( &initData );
}

//--------------------------------------------------------------------------
/**
 * @brief		// fXgN^
 */
//--------------------------------------------------------------------------
DialogViewWork::~DialogViewWork( void )
{
	GFL_SAFE_DELETE( m_pTimeIcon );
	
	m_g2dUtil->DeleteMsgCursor();
	m_g2dUtil->DeleteMessageWindow();
	
	Delete2D();
	DeleteGraphicsSystem();
}

//--------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 */
//--------------------------------------------------------------------------
void DialogViewWork::Update(void)
{
	app::ui::UIView::Update();
	
	if( m_isMessageWait )
	{
		if( m_g2dUtil->PrintMessage() == gfl::str::StrWin::RES_DONE )
		{//bZ[WAbvf[g
			m_isMessageWait = false;
		}
	}
	
	m_g2dUtil->UpdateMsgCursor();
	
	if( m_pTimeIcon )
	{//vACR
		m_pTimeIcon->Update();
	}
}



//--------------------------------------------------------------------------
/**
 * @brief		`
 */
//--------------------------------------------------------------------------
void DialogViewWork::Draw(void)
{
	m_g2dUtil->Draw2D( m_graphicSystem, LAYOUT_ID_UPPER );
	//m_g2dUtil->Draw2D( m_graphicSystem, LAYOUT_ID_LOWER );

	m_g2dUtil->DrawMsgCursor( gfl::grp::DISPLAY_UPPER );
	
	if( m_pTimeIcon )
	{
		m_pTimeIcon->Draw( gfl::grp::DISPLAY_UPPER );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief    Abvf[g
 *
 * @param    none
 *
 * @return  true @A@false 
 */
//--------------------------------------------------------------------------------------------
bool DialogViewWork::UpdateInitialize(void)
{
	if( m_pTimeIcon )
	{		
		if( m_pTimeIcon->Start() == false )
		{
			m_pTimeIcon->SetVisible( false );
			return true;
		}
	}
	
	return false;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief    IAbvf[g
 *
 * @param    none
 *
 * @return  true I@A@false I
 */
//--------------------------------------------------------------------------------------------
bool DialogViewWork::UpdateFinalize(void)
{
	bool result = true;
	
	m_g2dUtil->UpdateMsgCursor();
	result &= m_g2dUtil->DeleteMsgCursor();
	if( m_pTimeIcon )
	{
		m_pTimeIcon->Update();
		result &= !m_pTimeIcon->End();
	}
	
	return result;
}

//--------------------------------------------------------------------------
/**
 * @brief		wiݒ
 */
//--------------------------------------------------------------------------
void DialogViewWork::SetupBackGroundColor( app::ui::UIView* pView )
{
	gfl::grp::g2d::LytPicture* pane = GetLayoutWork( LAYOUT_ID_UPPER )->GetPicturePane( PANENAME_DAILOG_UPPER_PANE_BASE_00 );
	if( pane )
	{
		pane->SetVtxColor( nw::lyt::VERTEXCOLOR_LT, pView->GetLayoutWork( 0 )->GetPicturePane( PANENAME_FRIEND_ENTRY_LOWER_PANE_PSS_BG )->GetVtxColor( nw::lyt::VERTEXCOLOR_LT ) );
        pane->SetVtxColor( nw::lyt::VERTEXCOLOR_RT, pView->GetLayoutWork( 0 )->GetPicturePane( PANENAME_FRIEND_ENTRY_LOWER_PANE_PSS_BG )->GetVtxColor( nw::lyt::VERTEXCOLOR_RT ) );
        pane->SetVtxColor( nw::lyt::VERTEXCOLOR_LB, pView->GetLayoutWork( 0 )->GetPicturePane( PANENAME_FRIEND_ENTRY_LOWER_PANE_PSS_BG )->GetVtxColor( nw::lyt::VERTEXCOLOR_LB ) );
        pane->SetVtxColor( nw::lyt::VERTEXCOLOR_RB, pView->GetLayoutWork( 0 )->GetPicturePane( PANENAME_FRIEND_ENTRY_LOWER_PANE_PSS_BG )->GetVtxColor( nw::lyt::VERTEXCOLOR_RB ) );
	}
}

//--------------------------------------------------------------------------
/**
 * @brief		//bZ[WJn
 */
//--------------------------------------------------------------------------
void DialogViewWork::StartMessage( s32 messageID , bool isScroll )
{
	m_g2dUtil->SetPaneVisible( LAYOUT_ID_UPPER , PANENAME_DAILOG_UPPER_PANE_WINDOW_00 , true );//EBhE\
	
	if( isScroll )
	{//XN[\
		m_g2dUtil->SetPaneVisible( LAYOUT_ID_UPPER , PANENAME_DAILOG_UPPER_PANE_TEXTBOX_01 , true );
		m_g2dUtil->SetPaneVisible( LAYOUT_ID_UPPER , PANENAME_DAILOG_UPPER_PANE_TEXTBOX_02 , true );
		m_g2dUtil->SetPaneVisible( LAYOUT_ID_UPPER , PANENAME_DAILOG_UPPER_PANE_TEXTBOX_00 , false );
		
		
		gfl::str::StrBuf strbuf( MAX_STR_BUFFER_SIZE , m_pHeap->pHeap );
		m_g2dUtil->GetString( &strbuf, messageID );
		//gfl::str::StrBuf* buf = GetMessageStrBuf( messageID );
		m_g2dUtil->SetMessage( &strbuf );
		m_isMessageWait = true;
		//VisiblePrintMessege( true );
	}
	else
	{//\
		SetTextboxPaneMessage( LAYOUT_ID_UPPER , PANENAME_DAILOG_UPPER_PANE_TEXTBOX_00 ,  messageID );//IDς
		
		m_g2dUtil->SetPaneVisible( LAYOUT_ID_UPPER , PANENAME_DAILOG_UPPER_PANE_TEXTBOX_01 , false );
		m_g2dUtil->SetPaneVisible( LAYOUT_ID_UPPER , PANENAME_DAILOG_UPPER_PANE_TEXTBOX_02 , false );
		m_g2dUtil->SetPaneVisible( LAYOUT_ID_UPPER , PANENAME_DAILOG_UPPER_PANE_TEXTBOX_00 , true );
	}
}

//--------------------------------------------------------------------------
/**
 * @brief		//bZ[W҂
 */
//--------------------------------------------------------------------------
bool DialogViewWork::IsMessageWait(void)
{
	return m_isMessageWait;
}

//=============================================================================================
/**
 * @brief	ԃACR\X^[g
 *
 * @param   heap		
 */
//=============================================================================================
void DialogViewWork::StartTimerIcon(void)
{
	if( m_pTimeIcon )
	{
		m_pTimeIcon->SetVisible( true );
	}
}

//=============================================================================================
/**
 * @brief	ԃACR\I
 *
 * @param   none		
 */
//=============================================================================================
void DialogViewWork::EndTimerIcon( void )
{
	if( m_pTimeIcon )
	{
		m_pTimeIcon->SetVisible( false );
	}
}

//==========================================================================
/**
 *				private֐					
 */
//==========================================================================
//--------------------------------------------------------------------------------------------
/**
 * @brief		2D֘A쐬
 *
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void DialogViewWork::Initialize2D( app::util::Heap * heap )
{
	Create2D( heap, NULL, LAYOUT_ID_MAX,
						DIALOG_RES_TABLE, GFL_NELEMS(DIALOG_RES_TABLE),
						DIALOG_LAYOUT_DATA, GFL_NELEMS(DIALOG_LAYOUT_DATA),
						GARC_message_friend_entry_DAT );
	
	StartMessage( msg_friend_entry_01_01 , false );
}


GFL_NAMESPACE_END(friend_entry)
GFL_NAMESPACE_END(netapp)
