/**
 *
 *	@file		app_zukan_voice_View.h
 *	@brief
 *	@author	Toru=Nagihashi
 *	@date		2012.08.08
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#pragma once
#if !defined( __APP_ZUKAN_VOICE_VIEW_H__)
#define __APP_ZUKAN_VOICE_VIEW_H__

#include "../app_zukan_IView.h"

#include "app/ui/UITouchBarListener.h"
#include "../app_zukan_DataManager.h"
#include "../app_zukan_TouchbarView.h"
#include "app_zukan_voice_ViewListener.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(zukan)
GFL_NAMESPACE_BEGIN(voice)

class View : public IView, public app::ui::UITouchBarListener
{
  GFL_FORBID_COPY_AND_ASSIGN(View);
public:
  //-----------------------------------------------------------------------
  // RXgN^EfXgN^
  //-----------------------------------------------------------------------
  /**
   *  @brief RXgN^
   *  @param heap q[v
   *  @param Graphics OtBbN}l[W[
   *  @param data_manager f[^}l[W[
   */
  View( app::util::Heap * heap, Graphics * graphics, DataManager * data_manager );
  /**
   *  @brief fXgN^
   */
  virtual ~View();
  //-----------------------------------------------------------------------
  // VXe
  //-----------------------------------------------------------------------
  /**
   *  @brief XV
   */
  virtual void Update(void);
  /**
   *  @brief `
   */
  virtual void Draw(void);
  //-----------------------------------------------------------------------
  // 
  //-----------------------------------------------------------------------
  /**
   * @brief Xio^
   *
   * @param listenerXi[
   */
  void SetListener( ViewListener *listener );
  
public:
  virtual bool OnSelectedButton( u32 buttonID );

private:
  //CAEg[N
  enum
  {
    LYTWK_ID_UPPER,
    LYTWK_ID_LOWER,
    LYTWK_ID_MAX
  };
  
  //{^
  enum
  {
    BUTTON_ID_,
    BUTTON_ID_MAX
  };
  
  //AjID
  enum
  {
    ANIME_ID_ARROW,
    ANIME_ID_TOUCH,
    ANIME_ID_RELEASE,
    ANIME_ID_CANCEL,
    ANIME_ID_TOUCH_RELEASE,
    ANIME_ID_ACTIVE,
    ANIME_ID_PASSIVE,
    ANIME_ID_REAL_MAX, //Aj
    
    ANIME_ID_SHARE_TOUCH    = ANIME_ID_REAL_MAX,
    ANIME_ID_SHARE_RELEASE  = ANIME_ID_SHARE_TOUCH + BUTTON_ID_MAX,
    ANIME_ID_SHARE_CANCEL   = ANIME_ID_SHARE_RELEASE + BUTTON_ID_MAX,
    ANIME_ID_SHARE_TOUCH_RELEASE  = ANIME_ID_SHARE_CANCEL + BUTTON_ID_MAX,
    ANIME_ID_SHARE_ACTIVE   = ANIME_ID_SHARE_TOUCH_RELEASE + BUTTON_ID_MAX,
    ANIME_ID_SHARE_PASSIVE  = ANIME_ID_SHARE_ACTIVE + BUTTON_ID_MAX,
    ANIME_ID_MAX            = ANIME_ID_SHARE_PASSIVE + BUTTON_ID_MAX,
  };
  
private:
  static const app::ui::ButtonInfo ButtonInfoData[ BUTTON_ID_MAX ];
  
private:
  //
  void CreateLayout( app::util::Heap * heap );
  void DeleteLayout( void );

  void CreateTouchbar( app::util::Heap * heap );
  void DeleteTouchbar( void );
  
  void CreateShareAnime( void );
  void CreateButton( app::util::Heap * heap );
  
  void WriteStaticsTextPane( app::util::Heap * heap );

private:
  DataManager   *m_data_manager;
  TouchbarView  *m_touchbar_view;  ///<^b`o[iQƁj
  ViewListener *m_listener; 
};

GFL_NAMESPACE_END(voice)
GFL_NAMESPACE_END(zukan)
GFL_NAMESPACE_END(app)
#endif		// __APP_ZUKAN_VOICE_VIEW_H__
