//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		MModelEffectResource.cpp
 *	@brief  샂fGtFNg\[X
 *	@author	tomoya takahashi
 *	@date		2012.10.06
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "MModelEffectResource.h"
#include "field/FieldResident.h"

namespace field{

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
  const u32 MModelEffectResource::m_PTL_Index[ PACK_PTL_MAX ] = {
    BL_IDX_FIELD_GRAPHICS_DEFAULT_RESOURCE_PACK_EFL_BREATH01_SNOWRUN_MOUTH_BCPTL,
    BL_IDX_FIELD_GRAPHICS_DEFAULT_RESOURCE_PACK_RAINREF_BCPTL,
    BL_IDX_FIELD_GRAPHICS_DEFAULT_RESOURCE_PACK_EFL_BREATH01_RUN_MOUTH_BCPTL,
    BL_IDX_FIELD_GRAPHICS_DEFAULT_RESOURCE_PACK_EFL_BREATH01_SNOWNOM_MOUTH_BCPTL,
    BL_IDX_FIELD_GRAPHICS_DEFAULT_RESOURCE_PACK_EFL_FOOTSMOKE01_WARK_TOE_BCPTL,      
  };

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------

  //----------------------------------------------------------------------------
  /**
   *	@brief  RXgN^
   */
  //-----------------------------------------------------------------------------
  MModelEffectResource::MModelEffectResource( void ) : 
    m_pPtlResourceArray(NULL),
    m_pResourceArray(NULL),
    m_AllResourceNum(0)
  {
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  fXgN^
   */
  //-----------------------------------------------------------------------------
  MModelEffectResource::~MModelEffectResource()
  {
    this->Finalize();
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  \[X̏
   */
  //-----------------------------------------------------------------------------
  void MModelEffectResource::Initialize( gfl::heap::HeapBase* p_heap, gfl::heap::NwAllocator* p_heapAllocator, gfl::heap::NwAllocator* p_deviceAllocator, gfl::base::BinLinkerAccessor* p_resident )
  {
    if( !m_pPtlResourceArray ){


      m_pPtlResourceArray = GFL_NEW_ARRAY( p_heap ) gfl::grp::g3d::Resource[PACK_PTL_MAX];

      m_AllResourceNum = (END_RESOURCE_IDX+1) - START_RESOURCE_IDX;
      m_pResourceArray = GFL_NEW_ARRAY( p_heap ) gfl::grp::g3d::H3dResource[m_AllResourceNum];


      for( u32 i=0; i<m_AllResourceNum; ++i ){

        s32 ptl_resource_idx = GetPtlResourceIndex( i + START_RESOURCE_IDX );
        if( ptl_resource_idx != -1 ){
          m_pPtlResourceArray[ptl_resource_idx].AttachBufferAndSetup( p_deviceAllocator,
              p_resident->GetData( i + START_RESOURCE_IDX ), NULL, false, gfl::grp::g3d::Resource::COMMON_RESOURCE_PARTICLE_DEFAULT_SHADER_BIT );
        }
        else{
          m_pResourceArray[i].AttachBufferAndSetup( p_heapAllocator, p_deviceAllocator, p_resident->GetData( i + START_RESOURCE_IDX ), NULL, gfl::grp::g3d::H3dResource::COMMON_RESOURCE_H3D_DEFAULT_SHADER_BIT );
          
        }

        
      }
      
    }
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  \[X̔j
   */
  //-----------------------------------------------------------------------------
  void MModelEffectResource::Finalize( void )
  {
    if( m_pPtlResourceArray ){

      GFL_DELETE_ARRAY m_pResourceArray;
      m_pResourceArray = NULL;

      GFL_DELETE_ARRAY m_pPtlResourceArray;
      m_pPtlResourceArray = NULL;
      
    }
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  p[eBN\[X擾
   *
   *	@param	idx   CfbNX
   *
   *	@return p[eBN\[X
   */
  //-----------------------------------------------------------------------------
  gfl::grp::g3d::Resource* MModelEffectResource::GetPtlResource( u32 idx )
  {
    for( u32 i=0; i<PACK_PTL_MAX; ++i ){
      if( m_PTL_Index[i] == idx ){
        // ̃\[XԂB
        return &m_pPtlResourceArray[i];
      }
    }
    return NULL;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  p[eBNȊÕ\[X擾
   */
  //-----------------------------------------------------------------------------
  gfl::grp::g3d::H3dResource* MModelEffectResource::GetH3dResource( u32 idx )
  {
    if( (idx <= END_RESOURCE_IDX) && (idx >= START_RESOURCE_IDX) ){
      idx -= START_RESOURCE_IDX;
      
      if( m_pResourceArray[idx].GetBuffer() != NULL ){
        return &m_pResourceArray[idx];
      }
    }

    return NULL;
  }

  // p[eBN\[X`FbN
  s32 MModelEffectResource::GetPtlResourceIndex( u32 idx )
  {
    for( u32 i=0; i<PACK_PTL_MAX; ++i ){
      if( m_PTL_Index[i] == idx ){
        return i;
      }
    }

    return -1;
  }



} // namespace field

