//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		SubWindowFriendSafariSelectProc.cpp
 *	@brief  thTt@I
 *	@author	Masayuki Onoue
 *	@date		2012.10.01
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include <gflib.h>
#include "sound/sound.h"
#include "SubWindowFriendSafariSelectProc.h"
#include "AppFriendSafariMain.h"
#include "gamesystem/GameManager.h"
#include "field/Fieldmap.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(friendsafari )

/* -------------------------------------------------------------------------*/
/**
 * @brief ݒ𔽉f
 *
 * @param settings
 */
/* -------------------------------------------------------------------------*/
void SubWindowFriendSafariSelectProc::SetSetting( const Setting& settings )
{
  mGameManager = settings.gameManager;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief RXgN^
 *
 * @param p_fieldmap  tB[h}bv
 */
/* -------------------------------------------------------------------------*/
SubWindowFriendSafariSelectProc::SubWindowFriendSafariSelectProc( field::Fieldmap* p_fieldmap ) :
  field::SubWindowProc( p_fieldmap )
{
}

/* -------------------------------------------------------------------------*/
/**
 * @brief fXgN^
 */
/* -------------------------------------------------------------------------*/
SubWindowFriendSafariSelectProc::~SubWindowFriendSafariSelectProc( )
{
}

/* -------------------------------------------------------------------------*/
/**
 * @brief PROC̏s֐
 *
 * @param pManager
 *
 * @return Result 삪I RES_FINISHԂĂ炤UpdateFuncɐi
 */
/* -------------------------------------------------------------------------*/
gfl::proc::Result SubWindowFriendSafariSelectProc::InitFunc( gfl::proc::Manager* pManager )
{
  // tB[h}bv
  field::Fieldmap* pFieldmap = mGameManager->GetFieldmap( );

  // ȃq[v̂ŏIB
  if ( !pFieldmap->IsExistHeapInsideEvent( ) )
  {
    GFL_ASSERT_MSG( 0, "SCENETYPEPEMݒ肳ĂȂ\n" );
    return gfl::proc::RES_FINISH;
  }

  gfl::heap::HeapBase* parentHeap = pFieldmap->GetHeapInsideEvent( );
  gfl::heap::HeapBase* parentDeviceHeap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_EVENT_DEVICE );

  mpSelectMain = GFL_NEW( parentHeap ) SelectMain( );
  SelectMain::Setting setting;
  setting.parentHeap        = parentHeap;
  setting.parentDeviceHeap  = parentDeviceHeap;
  setting.gameManager       = mGameManager;
  setting.layoutSystem      = pFieldmap->GetGraphics( )->GetLytSys( );
  mpSelectMain->SetSetting( setting );

  // 
  mpSelectMain->Initialize();

  this->StartSeq( &SubWindowFriendSafariSelectProc::Sequence_FadeIn );

  return gfl::proc::RES_FINISH;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief	  PROC̃CXVs֐
 *
 * @param pManager  PROC}l[W[
 *
 * @return	Result 삪I RES_FINISHԂĂ炤EndFuncɐi
 */
/* -------------------------------------------------------------------------*/
gfl::proc::Result SubWindowFriendSafariSelectProc::UpdateFunc( gfl::proc::Manager* pManager )
{
  this->UpdateSeq( pManager );
  if ( this->IsSeqFinished( ) )
  {
    return gfl::proc::RES_FINISH;
  }
  return gfl::proc::RES_CONTINUE;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief V[PX̍XV
 *
 * @param pManager  PROC}l[W[
 */
/* -------------------------------------------------------------------------*/
void SubWindowFriendSafariSelectProc::UpdateSeq( gfl::proc::Manager* pManager )
{
  if ( m_seqProcess )
  {
    bool finished = ( this->*m_seqProcess )( pManager );
    if ( finished )
    {
      m_seqProcess = NULL;
    }
  }
}

/* -------------------------------------------------------------------------*/
/**
 * @brief V[PX̏I`FbN
 *
 * @return  true̎I
 */
/* -------------------------------------------------------------------------*/
bool SubWindowFriendSafariSelectProc::IsSeqFinished( void ) const
{
  return ( m_seqProcess == NULL );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief V[PX̊Jn
 *
 * @param seq_proc@JnV[PX̃o֐|C^
 * @param seq_step  JnV[PX̃Xebvԍ
 */
/* -------------------------------------------------------------------------*/
void SubWindowFriendSafariSelectProc::StartSeq( SeqProcPointer seq_proc, u32 seq_step )
{
  m_seqProcess = seq_proc;
  mSeqStep = seq_step;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief V[PX: tF[hC
 *
 * @param PROC}l[W[
 *
 * @return true  V[PXI
 */
/* -------------------------------------------------------------------------*/
bool SubWindowFriendSafariSelectProc::Sequence_FadeIn( gfl::proc::Manager* )
{
  switch ( mSeqStep )
  {
  case 0:
    gfl::grp::Fade_RequestIn( gfl::grp::Fade::DISP_LOWER );
    mSeqStep++;
    return false;

  case 1:
    if ( gfl::grp::Fade_IsEnd( ) )
    {
      this->StartSeq( &SubWindowFriendSafariSelectProc::Sequence_Main );
    }
    return false;

  default:
    GFL_ASSERT( 0 );
    return true;
  }
}

/* -------------------------------------------------------------------------*/
/**
 * @brief V[PX: C
 *
 * @param PROC}l[W[
 *
 * @return  true  V[PXI 
 */
/* -------------------------------------------------------------------------*/
bool SubWindowFriendSafariSelectProc::Sequence_Main( gfl::proc::Manager* )
{
  switch ( mSeqStep )
  {
  case 0:
    {
      // XN[~
      mGameManager->GetFieldmap( )->GetGraphics( )->SetStop( true );
      mSeqStep++;
    }
    // fall through

  case 1:
    {
      SelectMain::Result result = mpSelectMain->Update( );
      if( result == SelectMain::RESULT_FINISH )
      {
        mSeqStep++;
      }
      return false;
    }
  case 2:
    {
      // XN[~
      mGameManager->GetFieldmap( )->GetGraphics( )->SetStop( false );
    }
    return true;
    

  default:
    GFL_ASSERT( 0 );
    return true;
  }
}

/* -------------------------------------------------------------------------*/
/**
 * @brief   V[PX: tF[hAEg
 *
 * @param   PROC}l[W[
 *
 * @return@true  V[PXI 
 */
/* -------------------------------------------------------------------------*/
bool SubWindowFriendSafariSelectProc::Sequence_FadeOut( gfl::proc::Manager* )
{
  return true;

#if 0
  switch ( mSeqStep )
  {
  case 0:
    gfl::grp::Fade_RequestOut( gfl::grp::Fade::DISP_LOWER, gfl::grp::Fade::OUTTYPE_BLACK );
    mSeqStep++;
    return false;

  case 1:
    if ( gfl::grp::Fade_IsEnd( ) )
    {
      //this->StoreResult( );
      return true;
    }
    return false;

  default:
    GFL_ASSERT( 0 );
    return true;
  }
#endif
}

/* -------------------------------------------------------------------------*/
/**
 * @brief PROC̃C`s֐
 *
 * @param pManager  PROC}l[W[
 *
 * @note  zł͂܂B
 */
/* -------------------------------------------------------------------------*/
void SubWindowFriendSafariSelectProc::DrawFunc( gfl::proc::Manager* /*pManager*/ )
{
  mpSelectMain->Draw();
}

/* -------------------------------------------------------------------------*/
/**
 * @brief	  PROC̃CXVs֐
 *
 * @param pManager  PROC}l[W[
 *
 * @return	Result 삪I RES_FINISHԂĂ炤EndFuncɐi
 */
/* -------------------------------------------------------------------------*/
gfl::proc::Result SubWindowFriendSafariSelectProc::EndFunc( gfl::proc::Manager* /*pManager*/ )
{
  mpSelectMain->Finalize( );
  GFL_SAFE_DELETE( mpSelectMain );

  return gfl::proc::RES_FINISH;
}

GFL_NAMESPACE_END(friendsafari)
GFL_NAMESPACE_END(app)

