//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *  @file    AppFriendSafariSelectView.cpp
 *  @brief  Tt@ITur[ I
 *  @author  Masayuki Onoue
 *  @date    2012.10.02
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "AppFriendSafariSelectView.h"

// resource
#include <arc/arc_def.h>
#include <message/message.gaix>
#include "layout_info/friend_safari_select_res.h"
#include "layout_info/friend_safari_select_res_pane.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(friendsafari )

//-----------------------------------------------------------------------------
/**
 *    ButtonManagerpBoundbox Xg`
 */
//-----------------------------------------------------------------------------
// 1
static const app::ui::ButtonInfo PlayerSelectButton[] ={
  ///< {^1
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_00,  // picture_pane
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_00,      // bound_pane
    ANMID_LOWER_HOLD    + 0,                // hold_anime_index
    ANMID_LOWER_RELEASE + 0,                // release_anime_index
    ANMID_LOWER_SELECT  + 0,                // select_anime_index
    ANMID_LOWER_ACTIVE  + 0,                // active_anime_index
    ANMID_LOWER_PASSIVE  + 0,                // passive_anime_index
  },
  ///< {^2
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_01,  // picture_pane
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_01,      // bound_pane
    ANMID_LOWER_HOLD    + 1,                // hold_anime_index
    ANMID_LOWER_RELEASE + 1,                // release_anime_index
    ANMID_LOWER_SELECT  + 1,                // select_anime_index
    ANMID_LOWER_ACTIVE  + 1,                // active_anime_index
    ANMID_LOWER_PASSIVE  + 1,                // passive_anime_index
  },
  ///< {^3
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_02,  // picture_pane
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_02,      // bound_pane
    ANMID_LOWER_HOLD    + 2,                // hold_anime_index
    ANMID_LOWER_RELEASE + 2,                // release_anime_index
    ANMID_LOWER_SELECT  + 2,                // select_anime_index
    ANMID_LOWER_ACTIVE  + 2,                // active_anime_index
    ANMID_LOWER_PASSIVE  + 2,                // passive_anime_index
  },
  ///< {^4
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_03,  // picture_pane
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_03,      // bound_pane
    ANMID_LOWER_HOLD    + 3,                // hold_anime_index
    ANMID_LOWER_RELEASE + 3,                // release_anime_index
    ANMID_LOWER_SELECT  + 3,                // select_anime_index
    ANMID_LOWER_ACTIVE  + 3,                // active_anime_index
    ANMID_LOWER_PASSIVE  + 3,                // passive_anime_index
  },
  ///< {^5
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_04,  // picture_pane
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_04,      // bound_pane
    ANMID_LOWER_HOLD    + 4,                // hold_anime_index
    ANMID_LOWER_RELEASE + 4,                // release_anime_index
    ANMID_LOWER_SELECT  + 4,                // select_anime_index
    ANMID_LOWER_ACTIVE  + 4,                // active_anime_index
    ANMID_LOWER_PASSIVE  + 4,                // passive_anime_index
  },
  ///< {^6
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_05,  // picture_pane
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_05,      // bound_pane
    ANMID_LOWER_HOLD    + 5,                // hold_anime_index
    ANMID_LOWER_RELEASE + 5,                // release_anime_index
    ANMID_LOWER_SELECT  + 5,                // select_anime_index
    ANMID_LOWER_ACTIVE  + 5,                // active_anime_index
    ANMID_LOWER_PASSIVE  + 5,                // passive_anime_index
  },
  ///< {^7
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_06,  // picture_pane
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_06,      // bound_pane
    ANMID_LOWER_HOLD    + 6,                // hold_anime_index
    ANMID_LOWER_RELEASE + 6,                // release_anime_index
    ANMID_LOWER_SELECT  + 6,                // select_anime_index
    ANMID_LOWER_ACTIVE  + 6,                // active_anime_index
    ANMID_LOWER_PASSIVE  + 6,                // passive_anime_index
  },
  ///< {^8
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_07,  // picture_pane
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_07,      // bound_pane
    ANMID_LOWER_HOLD    + 7,                // hold_anime_index
    ANMID_LOWER_RELEASE + 7,                // release_anime_index
    ANMID_LOWER_SELECT  + 7,                // select_anime_index
    ANMID_LOWER_ACTIVE  + 7,                // active_anime_index
    ANMID_LOWER_PASSIVE  + 7,                // passive_anime_index
  },
  ///< {^9
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_08,  // picture_pane
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_08,      // bound_pane
    ANMID_LOWER_HOLD    + 8,                // hold_anime_index
    ANMID_LOWER_RELEASE + 8,                // release_anime_index
    ANMID_LOWER_SELECT  + 8,                // select_anime_index
    ANMID_LOWER_ACTIVE  + 8,                // active_anime_index
    ANMID_LOWER_PASSIVE  + 8,                // passive_anime_index
  },
  ///< {^10
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_09,  // picture_pane
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_09,      // bound_pane
    ANMID_LOWER_HOLD    + 9,                // hold_anime_index
    ANMID_LOWER_RELEASE + 9,                // release_anime_index
    ANMID_LOWER_SELECT  + 9,                // select_anime_index
    ANMID_LOWER_ACTIVE  + 9,                // active_anime_index
    ANMID_LOWER_PASSIVE  + 9,                // passive_anime_index
  },
  ///< {^11
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_10,  // picture_pane
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_10,      // bound_pane
    ANMID_LOWER_HOLD    + 10,                // hold_anime_index
    ANMID_LOWER_RELEASE + 10,                // release_anime_index
    ANMID_LOWER_SELECT  + 10,                // select_anime_index
    ANMID_LOWER_ACTIVE  + 10,                // active_anime_index
    ANMID_LOWER_PASSIVE  + 10,                // passive_anime_index
  },
  ///< {^12
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_11,  // picture_pane
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_11,      // bound_pane
    ANMID_LOWER_HOLD    + 11,                // hold_anime_index
    ANMID_LOWER_RELEASE + 11,                // release_anime_index
    ANMID_LOWER_SELECT  + 11,                // select_anime_index
    ANMID_LOWER_ACTIVE  + 11,                // active_anime_index
    ANMID_LOWER_PASSIVE  + 11,                // passive_anime_index
  },
};

// Ajf[^iʁj
const gfl::grp::g2d::LytArcIndex Select1View::LowerAnmIndex[ ANMID_LOWER_MAX ] = {
  // wb_[̏ԂƓɂ
  LYTRES_FRIEND_SAFARI_SELECT_RES_FRIEND_SAFARI_LOWER_ACTIVE_BCLAN,
  LYTRES_FRIEND_SAFARI_SELECT_RES_FRIEND_SAFARI_LOWER_CANSEL_BCLAN,
  LYTRES_FRIEND_SAFARI_SELECT_RES_FRIEND_SAFARI_LOWER_PASSIVE_BCLAN,
  LYTRES_FRIEND_SAFARI_SELECT_RES_FRIEND_SAFARI_LOWER_RELEASE_BCLAN,
  LYTRES_FRIEND_SAFARI_SELECT_RES_FRIEND_SAFARI_LOWER_TOUCH_BCLAN,
  LYTRES_FRIEND_SAFARI_SELECT_RES_FRIEND_SAFARI_LOWER_TOUCH_RELEASE_BCLAN,

};
  
const app::tool::CellList::PANE_DATA ListPaneData[] =
{
  // {^01
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_00,
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_00,
  },
  // {^02
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_01,
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_01,
  },
  // {^03
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_02,
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_02,
  },
  // {^04
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_03,
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_03,
  },
  // {^05
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_04,
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_04,
  },
  // {^06
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_05,
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_05,
  },
  // {^07
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_06,
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_06,
  },
  // {^08
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_07,
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_07,
  },
  // {^09
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_08,
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_08,
  },
  // {^10
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_09,
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_09,
  },
  // {^11
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_10,
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_10,
  },
  // {^12
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_11,
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_11,
  }, 
  // {^13
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_12,
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_12,
  },
  // {^14
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_13,
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_13,
  },
  // {^15
  {
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_14,
    PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_BOUND_14,
  },

};

// RXgN^
Select1View::Select1View(  app::util::Heap * heap ,gamesystem::GameManager*  game_manager) :
  app::ui::UIView( heap, heap->pDevHeapAllocator, heap->pDevHeapAllocator ),
  m_uiListener( NULL )
{
  // q[vۑ
  m_heap = heap;
  mGameManager = game_manager;

  static const app::util::G2DUtil::LYTWK_DATA layoutData[] =
  {
    {  // 
      0,
      LYTRES_FRIEND_SAFARI_SELECT_RES_FRIEND_SAFARI_LOWER_BCLYT,
      LowerAnmIndex,
      GFL_NELEMS(LowerAnmIndex),
      ANMID_LOWER_ANM_NUM,
      false,
      app::util::G2DUtil::SETUP_LOWER,
      true,
    },
  };

  // A[JCuIDe[u
  static const app::util::G2DUtil::LYT_RES_DATA resTbl[]={
    { ARCID_FRIEND_SAFARI_SELECT_GRA,  0, 0, app::util::G2DUtil::ATTACH_ROOT     },
  };

  // UIfoCX}l[W
  m_uiDeviceManager = mGameManager->GetUiDeviceManager();

  // p[\if[^}l[W
  mPssPersonalMgr = mGameManager->GetPssPersonalDataManager();

  // thTt@Z[uf[^
  gamesystem::GameData* gdata = mGameManager->GetGameData();
  mSafariSave = gdata->GetFriendSafariSaveData();

  Create2D( heap, NULL, LAYOUT_ID_MAX,
            resTbl, GFL_NELEMS(resTbl),
            layoutData, GFL_NELEMS(layoutData), 0 );
  
  // j[ʂ͔\ɂ
  this->SetVisibleYesNoMenu( false );

  // {^}l[Wo^
  this->SetButtonManager();

  // ^b`o[쐬
  this->CreateTouchbar();

  // ZXg쐬
  this->CreateCellList( 20 );

  // vC[ACR}l[W
  m_pPlayerIconTexManager = 
    GFL_NEW( m_heap->GetSystemHeap() ) common::resource::PlayerIconTexManager( 
        mGameManager->GetFileReadManager(), m_heap->GetSystemHeap(), 2, 0 );

  CreatePlayerIcon(0,PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_ICON_00);

  // |PACR
  m_pPokeIcon = GFL_NEW( m_heap->GetSystemHeap() ) common::resource::PokeIcon( 
      m_heap->GetSystemHeap(), m_heap->GetDeviceHeap(), 3 );
  m_pPokeIcon->OpenArcFile( m_heap->GetSystemHeap(), gfl::fs::ArcFile::OPEN );
  CreatePokemonIcon( 0 );
}

// fXgN^
Select1View::~Select1View( void )
{
  GFL_SAFE_DELETE(m_pPokeIcon);
  GFL_SAFE_DELETE(m_touchbar);
  GFL_SAFE_DELETE(m_cell_list);
  GFL_SAFE_DELETE(m_scroll_bar);
  GFL_SAFE_DELETE(m_pPlayerIconTexManager);
  Delete2D();
}

//--------------------------------------------------------------------------
/**
 *  @brief `
 */
//--------------------------------------------------------------------------
void Select1View::Update( void )
{
  // vC[ACRXV
  if( m_pPlayerIconTexManager != NULL )
  {
    m_pPlayerIconTexManager->Update();
  }
  // ZXg̍XV
  if( m_cell_list )
  {
    u32 res =  m_cell_list->Update();
    if( res == app::tool::CellList::RET_LIST_SELECT )
    {
      ONOUE_PRINT("I\n");
    }
  }

  this->app::ui::UIView::Update();
}

//--------------------------------------------------------------------------
/**
 *  @brief `
 */
//--------------------------------------------------------------------------
void Select1View::Draw( void )
{
  m_g2dUtil->Draw2D( GetGraphicSystem(), LAYOUT_ID_LOWER );
}

//--------------------------------------------------------------------------
/**
 * @brief    UICxgpXi̓o^
 */
//--------------------------------------------------------------------------
void Select1View::SetInputListener( AppFriendSafariViewUIListener *listener )
{
  m_uiListener = listener;
}

//------------------------------------------------------------------
/**
* @brief   yCCxǧm
*
* @param  layoutId ʒm󂯂郌CAEghc
* @param  painId   ʒm󂯂yChc
*
* @return t[ł̑̓CxgȂtrueA
*         ̃CxgrȂfalseԋp邱ƁB
*/
//------------------------------------------------------------------
// overwride
bool Select1View::OnLayoutPaneEvent( const u32 painId )
{
  if( m_uiListener == NULL ){
    GFL_PRINT("UIXi[o^ĂȂ\n");
    return true;
  }
  // Aj͑얳
  if( IsAnimeEnd() == false )
  {
    GFL_PRINT("AjEEE\n");
    return true;
  }

  switch( painId ){
    // SCENE_1_SELECT̂
    case PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_00:
    case PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_01:
    case PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_02:
    case PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_03:
    case PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_04:
    case PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_05:
    case PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_06:
    case PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_07:
    case PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_08:
    case PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_09:
    case PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_10:
    case PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_11:
      m_uiListener->OnButtonAction( painId - PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_SET_00 );
      return false;
  }

  return true;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief ߂{^ꂽƂʒm
 *
 * @param buttonID  {^ID
 *
 * @retval t[ő̓CxgȂtrue
 * @retval ̃CxgrȂfalse
 *
 * @note app::ui::UITouchBarListener̎
 */
/* -------------------------------------------------------------------------*/
bool Select1View::OnSelectedButton( u32 buttonID )
{
  if( buttonID == app::ui::UITouchBarView::BUTTON_ID_RETURN )
  {
    m_uiListener->OnReturnAction();    // ߂
    return false;
  }
  return true;
}

//------------------------------------------------------------------
/**
* @brief   L[͂̌m
*
* @param  pKey    \L[
* @param  pStick  AiOXeBbN
*
* @return t[ł̑̓CxgȂtrueA
*         ̃CxgrȂfalseԋp邱ƁB
*/
//------------------------------------------------------------------
// overwride
bool Select1View::OnKeyAction( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick)
{
  if( m_uiListener == NULL ){
    GFL_PRINT("UIXi[o^ĂȂ\n");
    return true;
  }
  // Aj͑얳
  if( IsAnimeEnd() == false )
  {
    GFL_PRINT("AjEEE\n");
    return true;
  }

  if( pKey->IsTrigger( gfl::ui::BUTTON_B ) ){
    ICHI_PRINT("B{^\n");
    m_uiListener->OnReturnAction();
    return false;
  }

  return true;
}


//-----------------------------------------------------------------------------
/**
 *  Xg
 */ 
//-----------------------------------------------------------------------------
// J[\ړ̃R[obN֐
void Select1View::CallBack_CursorMove( const app::tool::CellList::PANE_DATA * cur_pane, u32 pane_index, u32 pos )
{
}
// J[\\ɂR[obN֐
void Select1View::CallBack_CursorOff( const app::tool::CellList::PANE_DATA * pane, u32 pane_index, u32 pos )
{
}
// Xg̍ڂ`悷R[obN֐
void Select1View::CallBack_ListWrite( const app::tool::CellList::PANE_DATA * pane, u32 pane_index, u32 pos )
{
}
// ւpR[obN֐
void Select1View::CallBack_ItemChange( u32 pos1, u32 pos2 )
{
}


//--------------------------------------------------------------------------
/**
 * @breif   {^}l[WɃ{^ݒ肷
 */
//--------------------------------------------------------------------------
void Select1View::SetButtonManager( void )
{
  // {^}l[Wݒ肷
  ReloadButtonManager( 
      m_heap, 
      GetLayoutWork( LAYOUT_ID_LOWER ), 
      PlayerSelectButton, 
      GFL_NELEMS(PlayerSelectButton) );

  // ̓Xi[ݒ肷
  this->app::ui::UIResponder::SetInputListener( this );

  // ͂𖳌ɂ
  GetButtonManager()->SetInputEnable( false );
}
 
/* -------------------------------------------------------------------------*/
/**
 * @brief ^b`o[쐬
 */
/* -------------------------------------------------------------------------*/
void Select1View::CreateTouchbar( void )
{
  static const app::ui::UITouchBarView::SETUP setup[] =
  {
    {
      app::ui::UITouchBarView::BUTTON_ID_RETURN,
      PANENAME_FRIEND_SAFARI_LOWER_PANE_RETURN_ICON_POS
    }
  };
  m_touchbar  = GFL_NEW( m_heap->GetSystemHeap() ) app::ui::UITouchBarView(
      m_heap, 
      GetGraphicSystem(), 
      GetLayoutSystem(), 
      GetLayoutWork(0), 
      setup, GFL_NELEMS(setup) );
  m_touchbar->SetListener( this );
  this->AddSubView( m_touchbar );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief ZXg̍쐬
 *
 * @param val_max Xgɕ\鍀ڐ
 */
/* -------------------------------------------------------------------------*/
void Select1View::CreateCellList( u32 val_max )
{
  app::tool::CellList::SETUP_PARAM param;
  param.heap    = m_heap->GetSystemHeap();
  param.pLytWk  = this->GetLayoutWork(0);
  param.paneList= ListPaneData;
  param.paneListMax = RES_ROW*COLMN;
  param.paneRow = RES_ROW;
  param.paneCol = COLMN;
  param.valMax  = val_max;
  param.listRow = ROW;
  param.listCol = COLMN;
  param.listPosMax  = (ROW-1)*COLMN;
  param.listPos     = 0;
  param.listScroll  = 0;
  
  param.defPX       = -160.0f+103.0f/2.0f+4;
  param.defPY       = 120.0f-69.0f/2.0f-1;

  param.defSX       = 103.0f;
  param.defSY       = 69.0f;
  param.writeOffsetY= -1;
  param.skipMode    = app::tool::CellList::PAGE_SKIP_NONE;
  param.loopFlag    = false;
  param.catchFlag   = false;
  param.moveSE      = SEQ_SE_SELECT1;
  param.cbFunc      = this;

  m_cell_list = GFL_NEW( m_heap->GetSystemHeap() ) app::tool::CellList( &param );
  
  app::util::ScrollBar::SETUP_PARAM bar_setup = {
    gfl::grp::DISPLAY_LOWER,
    app::tool::ScrollBar::SCROLL_DIRECTION_VERTICAL,
    100,
    150,
    -30,
    0
  };
  
  // XN[o[
  m_scroll_bar  = GFL_NEW( m_heap->GetSystemHeap() ) app::util::ScrollBar( 
      m_heap->GetSystemHeap(), GetGraphicSystem(), &bar_setup ); 

}

//----------------------------------------------------------------------------
/**
 *  @brief  ʃAj[V̊Jn
 *
 *  @param  anime   Aj[VID
 */
//-----------------------------------------------------------------------------
void Select1View::StartAnime( E_ANMID_LOWER anime )
{
  m_nowAnimeLower = anime;
  m_g2dUtil->StopAnime( LAYOUT_ID_LOWER, anime, false );
  m_g2dUtil->StartAnime( LAYOUT_ID_LOWER, anime );
  ONOUE_PRINT("ʃAj %dĐ\n", m_nowAnimeLower );
}

//----------------------------------------------------------------------------
/**
 *  @brief  Aj[V̏I
 *
 *  @retval TRUE:AjI
 *  @retval FALSE:Aj
 */
//-----------------------------------------------------------------------------
bool Select1View::IsAnimeEnd( void ) const
{
  // SCAEg`FbNĂ
  if( m_g2dUtil->IsAnimeEnd( LAYOUT_ID_LOWER, m_nowAnimeLower ) == true )
  {
    return true;
  }

  return false;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief OtBbNVXe擾
 *
 * @return OtBbNVXe
 */
/* -------------------------------------------------------------------------*/
gfl::grp::GraphicsSystem* Select1View::GetGraphicSystem(void)
{
  return mGameManager->GetGraphicsSystem();
}

/* -------------------------------------------------------------------------*/
/**
 * @brief YesNoj[̕\Ԃؑւ
 *
 * @param is_visible  true̎\
 */
/* -------------------------------------------------------------------------*/
void Select1View::SetVisibleYesNoMenu( bool is_visible )
{
  m_g2dUtil->SetPaneVisible( LAYOUT_ID_LOWER, PANENAME_FRIEND_SAFARI_LOWER_PANE_PLAYER_MORE, is_visible );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief vC[ACR쐬
 *
 * @param data_index  QƂf[^̃CfbNX
 * @param pane_idx    yCID
 */
/* -------------------------------------------------------------------------*/
void Select1View::CreatePlayerIcon( u8 data_index, u32 pane_idx )
{
  // f[^擾
  savedata::FriendSafariSaveData::FriendData friend_data;
  mSafariSave->GetFriendData( data_index , &friend_data );

  // p[\if[^擾
  netapp::pss::PssPersonalData* personal = 
    GetPersonalDataByPrincipalID( friend_data.principal_id );
  if( personal == NULL ){ return; }
  ONOUE_PRINT("p[\if[^\n");

  // vC[ACR쐬
  common::resource::PlayerIconTexManager::IconDesc desc;
  common::resource::PlayerIconTexManager::IconParam param;

  // ACRID擾
  u32 fix_id = personal->GetIconID();
  param.fix_id = static_cast<xy_system::player_icon::PlayerFixIconID>(fix_id);
  // t@bVf[^擾
  param.fashion_buffer = personal->GetFasshionInfo();
  // ACRݒ肷yCّŐ
  desc.replace_info_num_max = 1;

  m_pPlayerIconTex = m_pPlayerIconTexManager->RequestCreatePlayerIconTex(
                    m_heap->pHeap,
                    m_heap->pDevHeap,
                    m_heap->pHeap,
                    m_heap->pDevHeap,
                    param,
                    desc );
  GFL_ASSERT(m_pPlayerIconTex);

  common::resource::PlayerIconTex::ReplaceInfo info;
  info.replace_mode = common::resource::PlayerIconTex::REPLACE_MODE_WAIT;
  info.pane = GetG2DUtil()->GetLayoutWork(LAYOUT_ID_LOWER)->GetPicturePane(pane_idx);
  m_pPlayerIconTex->AddReplaceInfo( info );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief |PACR쐬
 *
 * @param data_index  QƂf[^̃CfbNX
 */
/* -------------------------------------------------------------------------*/
void Select1View::CreatePokemonIcon( u8 data_index )
{
  // f[^擾
  savedata::FriendSafariSaveData::FriendData friend_data;
  mSafariSave->GetFriendData( data_index , &friend_data );

  // |PACR
  m_pPokeIcon->ReplacePaneTexture( 
      0,
      MONSNO_HUSIGIDANE,
      static_cast<pml::FormNo>(0),
      static_cast<pml::Sex>(0),
      false,
      0,
      GetG2DUtil()->GetLayoutWork(LAYOUT_ID_LOWER)->GetPicturePane(PANENAME_FRIEND_SAFARI_LOWER_MATERIAL_POKE_ICON_00));

}

/* -------------------------------------------------------------------------*/
/**
 * @brief vVpIDPSSp[\if[^擾
 *
 * @param principal_id vVpID
 *
 * @return 擾p[\if[^̃|C^
 *
 * @note f[^݂Ȃꍇ́ANULLԂ
 */
/* -------------------------------------------------------------------------*/
netapp::pss::PssPersonalData* Select1View::GetPersonalDataByPrincipalID( u32 principal_id )
{
  netapp::pss::PssDefine::E_PSS_RELATION relation =
        netapp::pss::PssDefine::E_PSS_RELATION_STRANGER;
  if( !mPssPersonalMgr->IsEmpty( relation ) )
  {
    netapp::pss::PssPersonalDataManager::PssPersonalDataList *list = 
      mPssPersonalMgr->GetPersonalDataList( relation );
    GFL_ASSERT( list );

    int i = 0;
    for( netapp::pss::PssPersonalDataManager::PssPersonalDataList::iterator it = list->begin(); it != list->end(); ++it )
    {
      // vVpID擾
      u32 id = static_cast<u32>(it->GetFriendKey().principalId);
      if( principal_id == id )
      {
        ONOUE_PRINT("f[^\n");
        return mPssPersonalMgr->GetPersonalData(it->GetFriendKey());
      }
      i++;
    }
  }
  return NULL;
}

GFL_NAMESPACE_END(friendsafari)
GFL_NAMESPACE_END(app)

