/*---------------------------------------------------------------------------*
Project: Voice Chat Sample.
File   : sndmic.h

Copyright (C)2011 Nintendo. All rights reserved.

These coded instructions, statements, and computer programs contain proprietary
information of Nintendo and/or its licensed developers and are protected by
national and international copyright laws. They may not be disclosed to third
parties or copied or duplicated in any form, in whole or in part, without the
prior written consent of Nintendo.

The content herein is highly confidential and should be handled accordingly.
*----------------------------------------------------------------------------*/

#ifndef SNDMIC_H_
#define SNDMIC_H_

/*---------------------------------------------------------------------------*
    Include
 *---------------------------------------------------------------------------*/
#include <nn.h>
#include <nn/os.h>
#include <nn/mic.h>
#include <nn/snd.h>

#include "vct.h"
#include "wave.h"


/*---------------------------------------------------------------------------*
    Define
 *---------------------------------------------------------------------------*/
//#define ROMFILE_WAVE_0 (L"rom:/noise.wav")
//#define ROMFILE_WAVE_1 (L"rom:/busy.wav")
//#define ROMFILE_WAVE_2 (L"rom:/kart_title.wav")


/*---------------------------------------------------------------------------*
    Extern "C"
 *---------------------------------------------------------------------------*/
#ifdef __cplusplus
extern "C" {
#endif


/*---------------------------------------------------------------------------*
    Enum
 *---------------------------------------------------------------------------*/
/* sndmic error status. */
enum SNDMIC_ERROR_STATUS
{
    SNDMIC_ERROR_NONE = 0,   /* None error         */
    SNDMIC_ERROR_PARAM,      /* Parameter error    */
    SND_ERROR_DSP,           /* DSP error          */
    SND_ERROR_SEQ,           /* Sequence error     */
    SND_ERROR_LIB,           /* SND library error  */
    MIC_ERROR_SEQ,           /* Sequence error     */
    MIC_ERROR_LIB            /* MIC library error  */
};

/* snd process status. */
enum SND_PROCESS_STATUS
{
    SND_PROCESS_NONE = 0, /* None process       */
    SND_PROCESS_INIT,     /* Initialize process */
    SND_PROCESS_PLAY,     /* Play process       */
    SND_PROCESS_STOP      /* Stop process       */
};

/* mic process status. */
enum MIC_PROCESS_STATUS
{
    MIC_PROCESS_NONE = 0, /* None process       */
    MIC_PROCESS_INIT,     /* Initialize process */
    MIC_PROCESS_START,    /* Start process      */
    MIC_PROCESS_STOP      /* Stop process       */
};


/*---------------------------------------------------------------------------*
    Const
 *---------------------------------------------------------------------------*/
#define SOUND_BUFFER_NUM   (3)                           /* Num of sound buffer */
#define ADD_BUFFER_NUM     (2)                           /* Num of add  buffer  */
#define SOUND_FREQ_8KHZ    (NN_SND_HW_I2S_CLOCK_32KHZ/4) /*  8kHz sampling(8182) */
//#define FREQ8KHZ_TIME_NS   (1000000000/SOUND_FREQ_8KHZ) /* 122217.646354288786 nsec */
#define FREQ8KHZ_TIME_NS   (1000000000/SOUND_FREQ_8KHZ - 0.89) /* B}CNTvOƓ͂ĂȂ  */

/*---------------------------------------------------------------------------*
    Typedef
 *---------------------------------------------------------------------------*/

/* sndmic config parameter. */
typedef struct __sndmic_config
{
    u32             frame_msec;    /* Audio frame Length(mSec).           */
    u8              mic_gain;      /* mic initialize gain.        */
                                   /*
                                         -> 31 : MIC Gain(26.0dB, ~20)
                                            43 : MIC Gain(32.0dB, ~40)
                                            55 : MIC Gain(38.0dB, ~80)
                                            67 : MIC Gain(44.0dB, ~160)
                                   */
} _sndmic_config;


/*---------------------------------------------------------------------------*
    Class
 *---------------------------------------------------------------------------*/
class SndMicDevice
{
public:
    /* function */
    SNDMIC_ERROR_STATUS     Initialize( nn::fnd::ExpHeap* pAppHeap, _sndmic_config *config );
    SNDMIC_ERROR_STATUS     Finalize( void );
    SNDMIC_ERROR_STATUS     Start( void );
    SNDMIC_ERROR_STATUS     Stop( void );
    SNDMIC_ERROR_STATUS     MicGainSet( u8 gain );
    SNDMIC_ERROR_STATUS     MicGainGet( u8 *gain );
    SNDMIC_ERROR_STATUS     StartBGM(void);
    SNDMIC_ERROR_STATUS     StopBGM(void);
    SNDMIC_ERROR_STATUS     SetVolume( f32 volume );
    SNDMIC_ERROR_STATUS     SetBGMVolume( f32 volume );
    void                    GetMicData( void );
    void                    MicDataThreadImpl( void );
    void                    SoundThreadFuncImpl( void );
    void                    FrameProcessThreadImpl( void );
    bool                    GetSndMicErrorFlag( void);
    void                    RomfileWavePlay( u32 number );
    bool                    GetReceiveAudioData( u8 *audioBuf, u16 length );

private:
    /* variable */
    nn::os::Thread          m_SoundThread;
    nn::os::Thread          m_FrameProcessThread;
    nn::os::Event           m_MicEvent;


  gfl::heap::HeapBase*  mpBaseHeap;
  gfl::heap::HeapBase*  mpDevHeap;
  
    nn::snd::WaveBuffer     m_WaveBuffer[SOUND_BUFFER_NUM];
    nn::snd::WaveBuffer     m_MusicWaveBuffer;
    nn::snd::Voice*         m_pVoice;
    nn::snd::Voice*         m_pMusic;
    u8*                     m_SoundBuffer[SOUND_BUFFER_NUM];
    s16                     m_MixedData[NN_SND_SAMPLES_PER_FRAME * 2];
    s8                      m_SndBuf[4][VCT_AUDIO_DATA_SIZE_MAX];
    u16                     m_SndBufWriteIdx;
    u16                     m_SndBufReadIdx;
    _sndmic_config          m_Config;
    u32                     m_SoundBufferSize;
    u32                     m_AudioFrameSize;
    u16                     m_CurrBufferIdx;
    u16                     m_SoundBufferReqIdx;
    SND_PROCESS_STATUS      m_SoundStatus;

    char                    m_MicBuffer[8192] NN_ATTRIBUTE_ALIGN(nn::mic::BUFFER_ALIGNMENT_ADDRESS);
    uptr                    m_MicBuffHalfPosition;
    u16                     m_MicBufferSize;
    u16                     m_MicPrevPosition;
    MIC_PROCESS_STATUS      m_MicStatus;
    u8                      m_MicGain;
    u8                      *m_pWaveMemory[3];
    u8                      *m_pPlayWave;
    u32                     m_FrameCount[3];
    u32                     m_FramePlayNum;
    u32                     m_WaveNumbber;
    WaveData                m_WaveData[3];
    bool                    m_FramePlayReq;
    bool                    m_MicTimingError;
    char                    m_zero_buf[192*8*2];
};


#ifdef __cplusplus
}
#endif

#endif  /* _SNDMIC_H_ */
/* <<<< EOF >>>> */
