#if PM_DEBUG

#ifndef __TEST_OHNO_IRA_H__
#define __TEST_OHNO_IRA_H__
#pragma once
//================================================================================
/**
 * @file   test_ohno_ira.h
 * @brief  IRfobOp
 * @author k.ohno
 * @date   2012.4.12
 */
//================================================================================
#include <gfl_Heap.h>
#include <gflnet.h>
#include "test_ohno_Base.h"
#include "netapp/automatch/AutoIrConnect.h"

GFL_NAMESPACE_BEGIN(test)
GFL_NAMESPACE_BEGIN(ohno)


//class P2pManager;  //wb_[̏ԂővȂ


class TestOhnoIra : public Base {
  GFL_FORBID_COPY_AND_ASSIGN( TestOhnoIra );



public:
  TestOhnoIra(
    gfl::heap::HeapBase* heap, gfl::heap::HeapBase* device_heap,
    gfl::heap::NwAllocator* heap_allocator, gfl::heap::NwAllocator* device_allcator,
    gfl::grp::GraphicsSystem* graphics_system, gfl::ui::DeviceManager* ui_device_manager );
  virtual ~TestOhnoIra();
  virtual void UpdateTest( void );
  virtual void DrawTest( void );
private:

  nn::Result  ConfirmID(void);
  void Communicate(gfl::heap::HeapBase* appHeap);
  void iraInit(gfl::heap::HeapBase* appHeap);
  void iraMain(gfl::heap::HeapBase* appHeap);

  u8 *IrBuff;
  gfl::heap::HeapBase* mSysMem;
  gfl::heap::HeapBase* mDevMem;
  u8 mStep;
  u8 mStepBK;
//  netapp::ir::AutoIrConnect* mpAutoConnect;
  gflnet::p2p::NetGame* mNetGame;
  gflnet::p2p::NetGame* mNetGame2;
  gflnet::p2p::NetGame* mNetGame3;

};



GFL_NAMESPACE_END(ohno)
GFL_NAMESPACE_END(test)
#endif //__TEST_OHNO_IRA_H__

#endif // PM_DEBUG


