//=============================================================================
/**
 * @file	 test_ir_thread.cpp
 * @brief	 ԊOʐM XbhŒP̑ݒʐM
 * @author k.ohno
 * @date	 2012.9.14
 */
//=============================================================================


#include <nn.h>
#include <nn/Result.h>
#include <nn/ir.h>
#include <gflnet.h>
#include "test/ohno/test_ir_thread.h"

GFL_NAMESPACE_BEGIN(test)
GFL_NAMESPACE_BEGIN(ohno)


//------------------------------------------------------------------------------------
/**
 * @brief RXgN^
 */
//------------------------------------------------------------------------------------

TestIrThread::TestIrThread( gfl::heap::HeapBase* heap )
     : gflnet::base::NetThread( heap )
{
  gflnet::dev::IrAdapter::GetInstance()->Initialize(heap);

  mMemoryTop = GflHeapAllocMemoryAlign( heap, 1024, 16 );   //Mobt@

  {
    gflnet::dev::IrAdapter* pIrAdapter = gflnet::dev::IrAdapter::GetInstance();
    while(Yield()){
      int ret = pIrAdapter->ConnectNonBlock();
      if(ret==1){
        break;
      }
      else if(ret == -1){
        OHNO_PRINT("s\n");
        return;
      }
    }
  }

  //  obt@obt@P
  //  MP
  //  MP
  

  
  
}



void TestIrThread::GetData(void* memory,int size)
{
  while(Yield()){
    void* pRecv = pIrAdapter->GetBeacon(0, size);
    if(pRecv){
      memcpy(memory, pRecv, size);
      break;
    }
  }
}


void TestIrThread::SetData(void* memory,int size)
{
  while(Yield()){
    if(pIrAdapter->SetBeacon(memory, size)){
      break;
    }
  }
}


  
//------------------------------------------------------------------
/**
 * @brief	  ʐM
 */
//------------------------------------------------------------------

void TestIrThread::Main( void )
{
  gflnet::dev::IrAdapter* pIrAdapter = gflnet::dev::IrAdapter::GetInstance();

  if(!pIrAdapter->IsMaster()){  //q@
    GetData(mpCommand1Recv, sizeof(Command1));
    SetData(mpCommand1Send, sizeof(Command1));
    GetData(mpCommand2Recv, sizeof(Command2));
    SetData(mpCommand2Send, sizeof(Command2));
    GetData(mpCommand3Recv, sizeof(Command3));
    SetData(mpCommand3Send, sizeof(Command3));
  }
  else{  //e@
    SetData(mpCommand1Send, sizeof(Command1));
    GetData(mpCommand1Recv, sizeof(Command1));
    SetData(mpCommand2Send, sizeof(Command2));
    GetData(mpCommand2Recv, sizeof(Command2));
    SetData(mpCommand3Send, sizeof(Command3));
    GetData(mpCommand3Recv, sizeof(Command3));
  }
}

//------------------------------------------------------------------
/**
 * @brief	  
 */
//------------------------------------------------------------------

bool TestIrThread::Yield( void )
{
  gfl::base::Thread::Yield();
  return !GetKillNetThread();
}




GFL_NAMESPACE_END(gflnet)
