//============================================================================================
/**
 * @file		app_tool_CellList.cpp
 * @brief		ZXg
 * @author	Toru=Nagihashi
 * @date		12.05.25
 */
//============================================================================================
#include "app/tool/app_tool_CellList.h"

#include "field/subscreen/pss/fieldmenu_pss_types.h"

GFL_NAMESPACE_BEGIN( app )
GFL_NAMESPACE_BEGIN( tool )

const u32 CellList::ScrollFrame[4] = { 8, 6, 3, 1 };		// L[XN[t[e[u
  
//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		setup		ZbgAbvf[^
 */
//--------------------------------------------------------------------------------------------
CellList::CellList( const SETUP_PARAM * setup ) :
	trgCount( 0 ),
	trgSpeed( 0 ),
	updateSeq( PANELIST_SEQ_INPUT ),
	pScrollValue( NULL ),
  key_col_arround( false )
{
  GFL_ASSERT( param.paneCol == param.listCol );
  GFL_ASSERT( static_cast<u32>(param.listScroll) % param.paneCol == 0 );

	param = *setup;

	if( param.valMax / param.listCol <= param.listRow ){
		listScrollMax = 0.0f;
		param.listPosMax = (param.valMax / param.listCol) * param.listCol;
	}else{
		listScrollMax = static_cast<f32>( param.valMax / param.paneCol + ((param.valMax%param.paneCol)!=0) - param.listRow ) * param.paneCol;
	}

	tmpScroll = param.listScroll;

	InitListPut();
	MakeTouchArea();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
CellList::~CellList(void)
{
	CB_CursorOff( param.listPos );
	DeleteScrollValue();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		J[\f[^擾
 *
 * @param		pos			J[\ʒui[ꏊ
 * @param		scroll	XN[li[ꏊ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void CellList::GetCursorData( u32 * pos, f32 * scroll ) const
{
	if( pos != NULL ){
		*pos = param.listPos;
	}
	if( scroll != NULL ){
		*scroll = tmpScroll;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ڈʒu擾 ( J[\ʒu{XN[l )
 *
 * @param		none
 *
 * @return	ڈʒu
 */
//--------------------------------------------------------------------------------------------
u32 CellList::GetItemPos(void) const
{
	u32	pos;
	f32	scroll;
	GetCursorData( &pos, &scroll );
	return ( pos + static_cast<u32>(scroll) );
}
s32 CellList::GetItemPosNow(void) const
{
	return ( param.listPos + static_cast<u32>(param.listScroll) );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 *
 * @param		none
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
u32 CellList::Update(void)
{
	u32	ret;
  
#if PM_DEBUG
  static u32 preUpdateSeq = 0;
  
  if( preUpdateSeq   != updateSeq )
  {
    // GFL_PRINT( "SEQ CHANGE now%d pre%d\n", preUpdateSeq, updateSeq );
    preUpdateSeq  = updateSeq;
  }
#endif //PM_DEBUG

	switch( updateSeq ){
	case PANELIST_SEQ_INPUT:
		ret = UpdateInput();
		tmpScroll = param.listScroll;
		break;

	case PANELIST_SEQ_KEY_SCROLL:
		ret = UpdateKeyScroll();
		tmpScroll = param.listScroll;
		break;

	case PANELIST_SEQ_DRAG:
		ret = UpdateDrag();
		tmpScroll = GetUpdateDragScroll();
		break;

	case PANELIST_SEQ_AUTO_SCROLL:
		ret = UpdateAutoScroll();
		if( pScrollValue != NULL ){
			tmpScroll = pScrollValue->GetCurrentValue();
		}else{
			tmpScroll = param.listScroll;
		}
		break;
	}

	return ret;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[gF͑҂
 *
 * @param		none
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
u32 CellList::UpdateInput(void)
{
	gfl::ui::VectorDevice * key = GetKey();

	// L[ł̏㉺
  if( key->IsRepeat( gfl::ui::DIR_UP ) ){
    if( param.listScroll != 0.0f 
          && (param.listPos) / param.paneCol <= 0 ){
      InitKeyScroll( -1 );
      updateSeq = PANELIST_SEQ_KEY_SCROLL;
      return RET_LIST_UP;
    }
    if( GetItemPosNow() - param.paneCol >= 0 ){
      CursorMove( -param.paneCol );
      return RET_LIST_UP;
    }
    return RET_NONE;
  }
  if( key->IsRepeat( gfl::ui::DIR_DOWN ) ){
    if( param.listScroll < listScrollMax 
          && (param.listPos + param.paneCol) / param.paneCol >= param.listRow )
    {
      if( (param.listPos + param.listScroll+param.paneCol) >=  param.valMax ){ //8ROMɂƂɍs͂邪A񂪂ȂƂɂĂ܂̂
        return RET_NONE;
      }
      //GFL_PRINT( "listpos%d listscr%f col%d valmax%d\n", param.listPos, param.listScroll, param.paneCol, param.valMax );
      InitKeyScroll( 1 );
      updateSeq = PANELIST_SEQ_KEY_SCROLL;
      return RET_LIST_DOWN;
    }
    if( GetItemPosNow() + param.paneCol < param.valMax ){
      CursorMove( param.paneCol );
      return RET_LIST_DOWN;
    }
    return RET_NONE;
  }

  if( param.paneCol > 1 )
  {
    //EL[͍sȂƂȂ
    if( key->IsRepeat( gfl::ui::DIR_LEFT ) ){
      if( param.listScroll != 0.0f 
          && param.listPos <= 0 ){
        InitKeyScroll( -1 );
        key_col_arround = true;
        
        updateSeq = PANELIST_SEQ_KEY_SCROLL;
        return RET_LIST_UP;
      }
      if( GetItemPosNow() > 0 ){
        CursorMove( -1 );
        return RET_LIST_UP;
      }
      return RET_NONE;
    }
    if( key->IsRepeat( gfl::ui::DIR_RIGHT ) ){
      if( param.listScroll < listScrollMax 
          && param.listPos + 1 >= param.listPosMax ){
        InitKeyScroll( 1 );
        key_col_arround = true;

        updateSeq = PANELIST_SEQ_KEY_SCROLL;
        return RET_LIST_DOWN;
      }
      if( GetItemPosNow() < param.valMax-1 ){
        CursorMove( 1 );
        return RET_LIST_DOWN;
      }
      return RET_NONE;
    }
  }
  else
  {
    // y[WFLRL[
    if( param.skipMode == PAGE_SKIP_LR_KEY ){
      if( key->IsRepeat( gfl::ui::DIR_LEFT ) ){
        return PageUp();
      }
      if( key->IsRepeat( gfl::ui::DIR_RIGHT ) ){
        return PageDown();
      }
    }
  }
	// y[WFLR{^
	if( param.skipMode == PAGE_SKIP_LR_BUTTON ){
		gfl::ui::Button * button = GetButton();
		if( button->IsRepeat( gfl::ui::BUTTON_L ) ){
			return PageUp();
		}
		if( button->IsRepeat( gfl::ui::BUTTON_R ) ){
			return PageDown();
		}
	}

	// ^b`
	gfl::ui::TouchPanel * tp = GetTouchPanel();

	if( tp->IsTouchTrigger() == true ){
		u32 touchPane = GetTouchPane();
		if( touchPane != TOUCH_PANE_NONE ){
      basePane = touchPane;
			CB_CursorOff( param.listPos );
			param.listPos = GetCellListPos( touchPane );
      // GFL_PRINT( "touch pos %d\n", param.listPos );
			baseListPosRow = GetBaseListPosRow();
      // GFL_PRINT( "baseListpos %d\n", baseListPosRow );
			curPane = basePane;
			SetTouchPos( true );
			reviseFlag = false;
			dragScrollFlag = false;
			startTPX = nowTPX;
			startTPY = nowTPY;
			catchCount = 0;
			updateSeq = PANELIST_SEQ_DRAG;
			return RET_LIST_TOUCH;
		}
	}

	return RET_NONE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[gFL[XN[
 *
 * @param		none
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
u32 CellList::UpdateKeyScroll(void)
{

	u32	ret;
	if( scrollVec < 0 ){
		ret = RET_LIST_UP;
	}else{
		ret = RET_LIST_DOWN;
	}

	if( scrollCount == ScrollFrame[trgSpeed] ){
		ReviseInitScrollList();
		param.listScroll += ( static_cast<f32>(param.paneCol) * scrollVec );
    
    if( key_col_arround )
    {
      param.listPos -= ( static_cast<f32>(param.paneCol-1) * scrollVec );
      key_col_arround = false;
    }

		CB_CursorMove( param.listPos );

		gfl::ui::VectorDevice * key = GetKey();

		if( scrollVec == -1 ){
			if( !key->IsHold(gfl::ui::DIR_UP) || param.listScroll == 0.0f ){
				updateSeq = PANELIST_SEQ_INPUT;
				return RET_NONE;
			}
		}else if( scrollVec == 1 ){
      //GFL_PRINT( "listpos%d listScr%f panecol%d valmax%d listRow%d\n", param.listPos, param.listScroll, param.paneCol, param.valMax, param.listRow );
			if( !key->IsHold(gfl::ui::DIR_DOWN) 
          || param.listScroll >= listScrollMax
          || (param.listPos + static_cast<u32>(param.listScroll)+param.paneCol) >=  param.valMax //8ROMɂƂɍs͂邪A񂪂ȂƂɂĂ܂̂
          ){
        //GFL_PRINT( "߂I\n");
				updateSeq = PANELIST_SEQ_INPUT;
				return RET_NONE;
			}
		}

		if( trgCount == SCROLL_FRAME_CHG_COUNT ){
			trgCount = 0;
			if( trgSpeed < (GFL_NELEMS(ScrollFrame)-1) ){
				trgSpeed++;
			}
		}else{
			trgCount++;
		}
    basePane = GetDefaultPositionPane();
		baseListPosRow = param.listScroll/param.paneCol;
		scrollCount = 0;
		return ret;
	}

	if( scrollCount == 0 ){
		CB_CursorOff( param.listPos );
	}
	ScrollListPutKey( scrollVec );
	scrollCount++;

	return ret;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[gFhbO
 *
 * @param		none
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
u32 CellList::UpdateDrag(void)
{
	gfl::ui::TouchPanel * tp = GetTouchPanel();

	if( reviseFlag == false ){
		if( CheckDragContinue() == true ){
			SetTouchPos( false );
			f32	mv = static_cast<f32>( oldTPY - nowTPY );

			if( gfl::math::FAbs(startTPY-nowTPY) >= 3.0f ){
				dragScrollFlag = true;
			}

			// +
			if( mv > 0.0f ){
				gfl::math::VEC3 pos = GetPanePos( param.paneList[basePane].pict );
				// WEl␳
				if( ( pos.y + mv ) > param.defPY ){
          GFL_PRINT( "[+]WE\n" );
					mv = param.defPY - pos.y;
				}
				// XN[lE␳
				f32	ds = baseListPosRow - static_cast<f32>(param.listPos/param.paneCol);
				f32	lp = static_cast<f32>(param.listPos/param.paneCol)*param.defSY - ( param.defPY - ( pos.y + mv ) );
				if( ( ds*param.defSY+lp) > (listScrollMax*param.defSY) ){
          GFL_PRINT( "[+]XN[E\n" );
					mv = listScrollMax*param.defSY - ds*param.defSY - static_cast<f32>(param.listPos/param.paneCol)*param.defSY + param.defPY - pos.y;
				}
				if( mv != 0.0f ){
					ScrollListPut( mv, 1 );
				}
				catchCount = 0;
			// -
			}else if( mv < 0.0f ){
				gfl::math::VEC3 pos = GetPanePos( param.paneList[basePane].pict );
				// WEl␳
				f32	dpy = param.defPY - param.defSY * static_cast<f32>( param.listRow );
				if( ( pos.y + mv ) < dpy ){
          GFL_PRINT( "[-]WE\n" );
					mv = dpy - pos.y;
				}
				// XN[lE␳
				if( ( baseListPosRow*param.defSY-(param.defPY-(pos.y+mv)) ) < 0.0f ){
          GFL_PRINT( "[-]XN[E\n" );
					mv = -baseListPosRow*param.defSY + param.defPY - pos.y;
				}
				if( mv != 0.0f ){
					ScrollListPut( mv, -1 );
				}
				catchCount = 0;
			}else{
				if( param.catchFlag == true ){
					if( catchCount != 40 ){
						catchCount++;
					}
				}
			}

#if 1
			u32 tmp = GetDragPane();
			if( tmp != TOUCH_PANE_NONE ){
				curPane = tmp;
			}
#else
		/*	ؗpɎc܂B
				^b`͈͓ɃyC͂Ȃ̂ɁAȂȂB
				GetHitPane肢ƓĂȂH	*/
//			u32	tmp = GetTouchPane();
			u32 tmp = GetDragPane();
			if( tmp != TOUCH_PANE_NONE ){
			  curPane = tmp / param.paneCol;
			}else{
				u16	x, y;
				tp->GetXY( &x, &y );
				GFL_PRINT( "none: %d, %d ( %d, %d )\n", x, y, (s16)x-160, 120-(s16)y );
				for( u32 i=0; i<param.paneListMax; i++ ){
					gfl::math::VEC3	pos = GetPanePos( param.paneList[i].bound );
					GFL_PRINT( " [%d] (%f, %f), u[%f] d[%f] l[%f] r[%f]\n", i, pos.x, pos.y, pos.y+14.0f, pos.y-15.0f, pos.x-75.0f, pos.x+74.0f );
				}
				GFL_ASSERT( tmp != TOUCH_PANE_NONE );
			}
#endif

		}else{
			// I[gXN[`FbN
			u32	as_dot = gfl::math::Abs( nowTPY - oldTPY );
			if( as_dot >= 3 && as_dot < 33 && tp->IsTouch() == false ){
				s32	mv;
				// -
				if( nowTPY > oldTPY ){
					mv = -1;
				// +
				}else if( nowTPY < oldTPY ){
					mv = 1;
				}
				gfl::math::VEC3 pos = GetPanePos( param.paneList[basePane].pict );
				f32	ry = param.defPY - static_cast<f32>(static_cast<s32>((param.defPY-pos.y)/param.defSY)) * param.defSY;
				if( pos.y != ry ){
					if( mv > 0 ){
						ScrollListPut( gfl::math::FAbs(ry-pos.y), 1 );
					}else{
						ScrollListPut( -gfl::math::FAbs(ry-pos.y), -1 );
					}
					ReviseInitScrollList();
					pos = GetPanePos( param.paneList[basePane].pict );
				}
				param.listScroll += ( static_cast<f32>(param.listPos/param.paneCol) - (param.defPY-pos.y) / param.defSY ) * param.paneCol;
				s32	lp = GetCellListPos( curPane );
				if( lp < 0 ){
					param.listPos = 0;
				}else if( lp >= param.listPosMax ){
					param.listPos = param.listPosMax - 1;
				}else{
					param.listPos = lp;
				}
				basePane = curPane;
				baseListPosRow = param.listScroll/param.paneCol + param.listPos/param.paneCol;
				CreateScrollValue( (as_dot-3)/5, mv );
				autoScrollValue = 0;
				autoScrollStopPos = AUTO_SCROLL_END;
				updateSeq = PANELIST_SEQ_AUTO_SCROLL;
				return RET_LIST_TOUCH;
			}

			// I
			gfl::math::VEC3 pos = GetPanePos( param.paneList[basePane].pict );
			revisePane = basePane;
			revisePY = param.defPY - static_cast<f32>(static_cast<s32>((param.defPY-pos.y)/param.defSY)) * param.defSY;
			f32	abs = gfl::math::FAbs( revisePY - pos.y );

			if( abs == 0.0f ){
				param.listScroll += ( static_cast<f32>(param.listPos/param.paneCol) - (param.defPY-pos.y) / param.defSY ) * param.paneCol;
				param.listPos = GetCellListPos( curPane );
				ReviseInitScrollList();
				CB_CursorMove( param.listPos );
				updateSeq = PANELIST_SEQ_INPUT;
				if( dragScrollFlag == false && tp->IsTouch() == false ){
					return RET_LIST_SELECT;
				}else{
					if( CheckCatchItem() == true && tp->IsTouch() == true ){
						return RET_LIST_CATCH;
					}
					return RET_NONE;
				}
			}else if( abs < (param.defSY/2.0f) ){
				reviseParam = param.defSY / 8;
			}else{
				reviseParam = -param.defSY / 8;
				revisePY -= param.defSY;
			}
			reviseFlag  = true;
		}
	}else{
		gfl::math::VEC3 pos = GetPanePos( param.paneList[revisePane].pict );
		bool	end = false;
		if( ( reviseParam < 0.0f && (pos.y+reviseParam) <= revisePY ) ||
				( reviseParam > 0.0f && (pos.y+reviseParam) >= revisePY ) ){
			reviseParam = revisePY - pos.y;
			end = true;
		}
		if( reviseParam > 0.0f ){
			ScrollListPut( reviseParam, 1 );
		}else if( reviseParam < 0.0f ){
			ScrollListPut( reviseParam, -1 );
		}

		if( end == true ){
			pos = GetPanePos( param.paneList[revisePane].pict );
			param.listScroll += ( static_cast<f32>(param.listPos/param.paneCol) - (param.defPY-pos.y) / param.defSY ) * param.paneCol;
			param.listPos = GetCellListPos( curPane );
			ReviseInitScrollList();
			CB_CursorMove( param.listPos );
			updateSeq = PANELIST_SEQ_INPUT;
			if( dragScrollFlag == false && tp->IsTouch() == false ){
				return RET_LIST_SELECT;
			}else{
				if( CheckCatchItem() == true && tp->IsTouch() == true ){
					return RET_LIST_CATCH;
				}
				return RET_NONE;
			}
		}
	}

	return RET_LIST_TOUCH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[gFI[gXN[
 *
 * @param		none
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
u32 CellList::UpdateAutoScroll(void)
{
	gfl::ui::TouchPanel * tp = GetTouchPanel();

	f32	val = pScrollValue->GetCurrentValue();

	pScrollValue->UpdateScroll();

	// ~`FbN
	if( tp->IsTouchTrigger() == true ){
		u16	x, y;
		tp->GetXY( &x, &y );

		f32	tpx = static_cast<f32>( x-160 );
		f32	tpy = static_cast<f32>( 120-y );

		if( CheckTouchArea( tpx, tpy ) == true ){
			pScrollValue->StopRequest( 1.0f );
			autoScrollStopPos = GetTouchListPos( tpx, tpy );
		}
	}

	f32	scroll = pScrollValue->GetCurrentValue();
	val = ( scroll - val ) * param.defSY;

	autoScrollValue += val;

	if( val > 0.0f ){
		if( autoScrollValue >= param.defSY ){
			autoScrollValue -= param.defSY;
			if( basePane/param.paneCol == param.paneRow-1 ){
				basePane = 0; //@todo + basePane%param.paneCol;
			}else{
				basePane+= param.paneCol;
			}
			baseListPosRow += 1.0f;
		}
		ScrollListPut( val, 1 );
		param.listScroll = scroll * param.paneCol;
    // GFL_PRINT( "scroll = %f, pos = %d val%d\n", param.listScroll, param.listPos, scroll );
		return RET_LIST_AUTO_SCRILL;
	}else if( val < 0.0f ){
		if( autoScrollValue <= param.defSY ){
			autoScrollValue += param.defSY;
			if( basePane / param.paneCol == 0 ){
				basePane = param.paneRow-1;//@todo
			}else{
				basePane -= param.paneCol;
			}
			baseListPosRow -= 1.0f;
		}
		ScrollListPut( val, -1 );
		param.listScroll = scroll * param.paneCol;
    // GFL_PRINT( "scroll = %f, pos = %d val%d\n", param.listScroll, param.listPos, scroll );
		return RET_LIST_AUTO_SCRILL;
	}

	if( pScrollValue->IsScroll() == false ){
		param.listScroll = pScrollValue->GetCurrentValue() * param.paneCol;
		DeleteScrollValue();
		ReviseInitScrollList();

		u32	tp_pane = GetTouchPane();
		// hbO
		if( tp_pane != TOUCH_PANE_NONE ){
			basePane = tp_pane;
			param.listPos = GetCellListPos( tp_pane );
			baseListPosRow = GetBaseListPosRow();
			curPane = basePane;
			SetTouchPos( true );
			reviseFlag = false;
      // GFL_PRINT( "scroll = %f, pos = %d\n", param.listScroll, param.listPos );
			dragScrollFlag = true;
			updateSeq = PANELIST_SEQ_DRAG;
			catchCount = 0;
			return RET_LIST_TOUCH;
		}else{
			if( autoScrollStopPos != AUTO_SCROLL_END ){
				param.listPos = autoScrollStopPos;
			}
			CB_CursorMove( param.listPos );
      // GFL_PRINT( "scroll = %f, pos = %d\n", param.listScroll, param.listPos );
			updateSeq = PANELIST_SEQ_INPUT;
			return RET_NONE;
		}
	}

	return RET_LIST_AUTO_SCRILL;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		R[obNFJ[\ړ
 *
 * @param		pos		J[\ʒu
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void CellList::CB_CursorMove( u32 pos )
{
	u32	pane;

	if( param.valMax == 0 ){
		pane = CALLBACK_PANE_NONE;
	}else{
		pane = GetPosPaneIndex( pos );
	}

	param.cbFunc->CallBack_CursorMove(
		param.paneList, pane, GetItemPosNow() );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		R[obNFJ[\\
 *
 * @param		pos		J[\ʒu
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void CellList::CB_CursorOff( u32 pos )
{
	u32	pane;

	if( param.valMax == 0 ){
		pane = CALLBACK_PANE_NONE;
	}else{
		pane = GetPosPaneIndex( pos );
	}

	param.cbFunc->CallBack_CursorOff(
		param.paneList, pane, GetItemPosNow() );
}

void CellList::CB_ItemChange( u32 pos1, u32 pos2 )
{
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		\L[擾
 *
 * @param		none
 *
 * @return	\L[
 */
//--------------------------------------------------------------------------------------------
gfl::ui::VectorDevice * CellList::GetKey(void)
{
	gamesystem::GameManager * pgm = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
	gfl::ui::DeviceManager * dvm = pgm->GetUiDeviceManager();
	return dvm->GetCrossKey( gfl::ui::CTR_DeviceManager::CROSSKEY_STANDARD );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		AiOpbh擾
 *
 * @param		none
 *
 * @return	AiOpbh
 */
//--------------------------------------------------------------------------------------------
gfl::ui::VectorDevice * CellList::GetStick(void)
{
	gamesystem::GameManager * pgm = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
	gfl::ui::DeviceManager * dvm = pgm->GetUiDeviceManager();
	return dvm->GetStick( gfl::ui::CTR_DeviceManager::STICK_STANDARD );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		{^擾
 *
 * @param		none
 *
 * @return	{^
 */
//--------------------------------------------------------------------------------------------
gfl::ui::Button * CellList::GetButton(void)
{
	gamesystem::GameManager * pgm = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
	gfl::ui::DeviceManager * dvm = pgm->GetUiDeviceManager();
	return dvm->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		^b`pl擾
 *
 * @param		none
 *
 * @return	^b`pl
 */
//--------------------------------------------------------------------------------------------
gfl::ui::TouchPanel * CellList::GetTouchPanel(void)
{
	gamesystem::GameManager * pgm = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
	gfl::ui::DeviceManager * dvm = pgm->GetUiDeviceManager();
	return dvm->GetTouchPanel( gfl::ui::CTR_DeviceManager::TOUCHPANEL_STANDARD );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		yCW擾
 *
 * @param		index		yC̃CfbNX
 *
 * @return	W
 */
//--------------------------------------------------------------------------------------------
gfl::math::VEC3 CellList::GetPanePos( gfl::grp::g2d::LytPaneIndex index ) const
{
  gfl::grp::g2d::LytPane * basePane = param.pLytWk->GetPane( index );
	gfl::grp::g2d::LytPane * rootPane = param.pLytWk->GetLayoutCore()->GetRootPane();
	gfl::math::VEC3	pos = basePane->GetTranslate();

	while( 1 ){
	  gfl::grp::g2d::LytPane * parentPane = basePane->GetParent();
		// eȂ or e[gyC
		if( parentPane == NULL || parentPane == rootPane ){
      
			break;
		}
		pos += parentPane->GetTranslate();
		basePane = parentPane;
	}

	return pos;
/*
  gfl::grp::g2d::LytPane * basePane;
  gfl::grp::g2d::LytPane * parentPane;

	basePane   = param.pLytWk->GetPane( index );
	parentPane = basePane->GetParent();
	// eꍇi[gyC͐eƂ݂ȂȂj
	if( !( parentPane == NULL || parentPane == param.pLytWk->GetLayoutCore()->GetRootPane() ) ){
		return ( basePane->GetTranslate() + parentPane->GetTranslate() );
	}
	return basePane->GetTranslate();
*/
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		yCWݒ
 *
 * @param		index		yC̃CfbNX
 * @param		pos			yC̍W
 *
 * @return	nonw
 */
//--------------------------------------------------------------------------------------------
void CellList::SetPanePos( gfl::grp::g2d::LytPaneIndex index, gfl::math::VEC3 & pos )
{
	gfl::grp::g2d::LytPane * pane = param.pLytWk->GetPane( index );
	if( pane ){
		pane->SetTranslate( pos );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		yC\؂ւ
 *
 * @param		index		yC̃CfbNX
 * @param		flg			true = \, false = \
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void CellList::SetPaneVisible( gfl::grp::g2d::LytPaneIndex index, bool flg )
{
	gfl::grp::g2d::LytPane * pane = param.pLytWk->GetPane( index );
	if( pane ){
		pane->SetVisible( flg );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		yC\Ԏ擾
 *
 * @param		index		yC̃CfbNX
 *
 * @retval	"true = \"
 * @retval	"false = ȊO"
 */
//--------------------------------------------------------------------------------------------
bool CellList::GetPaneVisible( gfl::grp::g2d::LytPaneIndex index )
{
	gfl::grp::g2d::LytPane * pane = param.pLytWk->GetPane( index );
	if( pane ){
		return pane->IsVisible();
	}
	return false;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		^b`͈̓GA쐬
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void CellList::MakeTouchArea(void)
{
	touchAreaLX = param.defPX - param.defSX/2.0f;
	touchAreaRX = param.defPX + static_cast<f32>(param.listCol-1) * param.defSX + param.defSX/2.0f;
	touchAreaUY = param.defPY + param.defSY/2.0f;
	touchAreaDY = param.defPY - param.defSY * static_cast<f32>(param.listRow-1) - param.defSY/2.0f;

  GFL_PRINT( "area: (u, d, l, r) = (%f, %f, %f, %f)\n", touchAreaUY, touchAreaDY, touchAreaLX, touchAreaRX );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		^b`͈̓GA`FbN
 *
 * @param		x		XW
 * @param		y		YW
 *
 * @retval	"true = ͈͓"
 * @retval	"false = ͈͊O"
 */
//--------------------------------------------------------------------------------------------
bool CellList::CheckTouchArea( f32 x, f32 y )
{
	if( x >= touchAreaLX && x < touchAreaRX &&
			y > touchAreaDY && y <= touchAreaUY ){
		return true;
	}
	return false;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		^b`WZbg
 *
 * @param		init	 = true
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void CellList::SetTouchPos( bool init )
{
	gfl::ui::TouchPanel * tp = GetTouchPanel();
	u16	x, y;

	tp->GetXY( &x, &y );

	if( init == true ){
		oldTPX = x;
		oldTPY = y;
		nowTPX = x;
		nowTPY = y;
	}else{
		oldTPX = nowTPX;
		oldTPY = nowTPY;
		nowTPX = x;
		nowTPY = y;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ScrollValue쐬
 *
 * @param		level		xx
 * @param		mv			ړ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void CellList::CreateScrollValue( u32 level, s32 mv )
{
	app::tool::ScrollValue::Settings	dat;

	dat.init_value = param.listScroll / param.paneCol;	// l[value]
	dat.min_value  = 0.0f;							// ŏl[value]
	dat.max_value  = listScrollMax / param.paneCol;			// ől[value]
  
  // GFL_PRINT( "scroll[%d] init = %f, max = %f\n", level, dat.init_value, dat.max_value );

	const f32 decel[PSS_AUTO_SCROLL_DECEL_MAX] = {
		// ő呬x	0.01 mv = 50
		//					0.02 mv = 25
		//					0.03 mv = 16
		//					0.04 mv = 12
		//					0.05 mv = 10
		//					0.06 mv = 8
		//					0.07 mv = 7
		//					0.08 mv = 6
//		0.01f, 0.02f, 0.03f, 0.04f, 0.06f, 0.08f,
//		0.12f, 0.12f, 0.12f, 0.12f, 0.12f, 0.12f,
      1.0f,1.0f,1.0f,1.0f,1.0f,1.0f,
	};
  if( level >= PSS_AUTO_SCROLL_DECEL_MAX )
  {
    level = PSS_AUTO_SCROLL_DECEL_MAX-1;
  }
	dat.default_decel = decel[level];				// x[value/frame*frame]
	dat.overrun_enable  = false;					  // El˔jǂ
	dat.overrun_frame = 0;							    // El˔j̋XN[̃t[

	pScrollValue = GFL_NEW( param.heap ) app::tool::ScrollValue( dat );

	if( mv < 0 ){
		pScrollValue->StartScroll( -0.8f, 1.0f );
	}else{
		pScrollValue->StartScroll( 0.8f, 1.0f );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ScrollValue폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void CellList::DeleteScrollValue(void)
{
	if( pScrollValue != NULL ){
		GFL_DELETE	pScrollValue;
		pScrollValue = NULL;
	}
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		ftHgʒu(J[\0̈ʒu)̃yC̃CfbNX擾
 *
 * @param		none
 *
 * @return	yC̃CfbNX
 */
//--------------------------------------------------------------------------------------------
u32 CellList::GetDefaultPositionPane(void)
{
	return GetPosPaneIndex( 0 );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		XgʒũyC擾
 *
 * @param		pos		Xgʒu
 *
 * @return	yC̃CfbNX
 */
//--------------------------------------------------------------------------------------------
u32 CellList::GetPosPaneIndex( u32 pos )
{
  u32 r = pos / param.listCol;
  u32 c = pos % param.listCol;

	f32	y = param.defPY - param.defSY * static_cast<f32>( r );
  f32 x = param.defPX + param.defSX * static_cast<f32>( c );

	for( u32 i=0; i<param.paneListMax; ++i ){
		gfl::math::VEC3	p1 = GetPanePos( param.paneList[i].pict );
		if( p1.y == y && p1.x == x ){
			return i;
		}
	}
	GFL_ASSERT_MSG( 0, "r%d c%d x%f y%f\n", r,c, x, y );
	return 0;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief ׂẴXgCallBack_RenewalĂ
 */
//--------------------------------------------------------------------------------------------
void CellList::Renewal(void)
{
  s32 lp = static_cast<u32>( param.listScroll ) + param.writeOffsetY * param.paneCol;
  for( u32 r=0; r<param.paneRow; ++r )
  {
    for( u32 c=0; c<param.paneCol; ++c )
    {
      u32 i = r*param.paneCol+c;
      if( lp >= 0 && lp < param.valMax ){
        param.cbFunc->CallBack_Renewal( param.paneList, i, lp );
      } 
      lp++;
    }
  }
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		yC烊Xgʒu擾
 *
 * @param		index		yC̃CfbNX
 *
 * @return	Xgʒu
 */
//--------------------------------------------------------------------------------------------
s32 CellList::GetCellListPos( u32 index )
{
	gfl::math::VEC3	pos = GetPanePos( param.paneList[index].pict );
  return static_cast<s32>( (param.defPY-pos.y)/param.defSY ) * param.paneCol 
    + static_cast<s32>( (pos.x-param.defPX)/param.defSX );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		^b`̃yC擾
 *
 * @param		none
 *
 * @return	yC̃CfbNX
 */
//--------------------------------------------------------------------------------------------
u32 CellList::GetTouchPane(void)
{
	gfl::ui::TouchPanel * tp = GetTouchPanel();

	if( tp->IsTouch() == true ){
		u16	x, y;
		tp->GetXY( &x, &y );

		for( u32 i=0; i<param.paneListMax; i++ ){
			if( GetPaneVisible( param.paneList[i].pict ) == false ){
				continue;
			}
			gfl::math::VEC3	pos = GetPanePos( param.paneList[i].pict );
      if( CheckTouchArea( pos.x, pos.y ) == false ){
        continue;
      }
			if( param.pLytWk->GetHitPane( x, y, param.paneList[i].bound ) == true ){
				return i;
			}
		}
	}
	return TOUCH_PANE_NONE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		hbÕyC擾
 *
 * @param		none
 *
 * @return	yC̃CfbNX
 *
 *	GetTouchPane()gAGetHitPane܂Ȃ̂ŁAƎ`FbN܂
 */
//--------------------------------------------------------------------------------------------
u32 CellList::GetDragPane(void)
{
	gfl::ui::TouchPanel * tp = GetTouchPanel();

	u16	tpx, tpy;
	tp->GetXY( &tpx, &tpy );

	f32	x = static_cast<f32>( tpx ) - 160.0f;
	f32	y = 120.0f - static_cast<f32>( tpy );

	f32	half_sx = param.defSX / 2;
	f32	half_sy = param.defSY / 2;

	for( u32 i=0; i<param.paneListMax; i++ ){
		if( GetPaneVisible( param.paneList[i].pict ) == false ){
			continue;
		}
		gfl::math::VEC3	pos = GetPanePos( param.paneList[i].bound );
		if( CheckTouchArea( pos.x, pos.y ) == false ){
			continue;
		}
		if( x >= (pos.x-half_sx) && x < (pos.x+half_sx) &&
				y >= (pos.y-half_sy) && y < (pos.y+half_sy) ){
			return i;
		}
	}
	return TOUCH_PANE_NONE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		^b`W̃J[\ʒu擾
 *
 * @param		y		YW
 *
 * @return	J[\ʒu
 */
//--------------------------------------------------------------------------------------------
u32 CellList::GetTouchListPos( f32 x, f32 y )
{
	f32	uy = param.defPY + param.defSY / 2.0f;
	f32	dy = param.defPY - param.defSY / 2.0f;
  f32 lx = param.defPX - param.defSX / 2.0f;
  f32 rx = param.defPX + param.defSX / 2.0f;
  
  for( u32 r=0; r<param.listRow; ++r){
    lx = param.defPX - param.defSX / 2.0f;
    rx = param.defPX + param.defSX / 2.0f;
    for( u32 c=0; c<param.listCol; ++c){
      if( y <= uy && y > dy && x <= rx && x > lx ){
        return r*param.listCol+c;
      }
      lx = rx;
      rx += param.defSX;
    }
    uy = dy;
		dy -= param.defSY;
  }
	GFL_ASSERT( 0 );
	return 0;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		Xgzu
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void CellList::InitListPut(void)
{
	gfl::math::VEC3	pos = GetPanePos( param.paneList[0].pict );
	s32	lp;

	lp = static_cast<u32>( param.listScroll ) + param.writeOffsetY * param.paneCol;
	pos.y = param.defPY - param.defSY * param.writeOffsetY;
  
  for( u32 r=0; r<param.paneRow; ++r )
  {
    pos.x = param.defPX;
    for( u32 c=0; c<param.paneCol; ++c )
    {
      u32 i = r*param.paneCol+c;
      SetPanePos( param.paneList[i].pict, pos );
      if( lp >= 0 && lp < param.valMax ){
        SetPaneVisible( param.paneList[i].pict, true );
        param.cbFunc->CallBack_ListWrite( param.paneList, i, lp );
      }else{
        SetPaneVisible( param.paneList[i].pict, false );
      }
      pos.x += param.defSX;
      lp++;
    }
    pos.y -= param.defSY;
  }
  
	CB_CursorMove( param.listPos );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		XgXN[
 *
 * @param		mv_y		ړl
 * @param		mv			ړ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void CellList::ScrollListPut( f32 mv_y, int mv )
{
	s32	tbl[param.paneListMax];
	f32	ry;
	bool	se = false;

	MakePabeListRowTable( tbl, basePane, &ry );

	f32	def_y   = param.defPY - param.defSY * param.writeOffsetY;
	f32	half_sy = param.defSY / 2.0f;
	f32	uy = def_y + half_sy;
	f32	dy = def_y - param.defSY * ( param.paneRow + param.writeOffsetY ) - half_sy;
  
  gfl::math::VEC3	drag_pos = GetPanePos( param.paneList[ basePane ].pict );
  drag_pos.y += mv_y;
  for( u32 c=0; c<param.paneCol; ++c)
  {
    u32 i = (basePane/param.paneCol)*param.paneCol+c;
    gfl::math::VEC3	p1 = GetPanePos( param.paneList[ i ].pict );
    p1.y  = drag_pos.y;
	  SetPanePos( param.paneList[i].pict, p1 );
  }

  for( u32 r=0; r<param.paneRow; ++r){
    for(u32 c=0; c<param.paneCol; ++c ) {
      u32 i = r*param.paneCol+c;
      if( tbl[i] /param.paneCol != basePane/param.paneCol ){
        gfl::math::VEC3	pos = GetPanePos( param.paneList[ tbl[i] ].pict );
        pos.y = drag_pos.y + ry;
        if( mv < 0 ){
          if( pos.y <= dy ){
            pos.y += ( param.defSY * static_cast<f32>(param.paneRow) );
            f32	sy = ReviseFloat( drag_pos.y - pos.y );
            s32	list_pos =  static_cast<s32>( baseListPosRow + sy / param.defSY ) * param.paneCol + c;
            if( list_pos < 0 ){
              SetPaneVisible( param.paneList[ tbl[i] ].pict, false );
            }else{
              SetPaneVisible( param.paneList[ tbl[i] ].pict, true );
              param.cbFunc->CallBack_ListWrite( param.paneList, tbl[i], list_pos );
              // GFL_PRINT( "ds = %f, dpy = %f, py = %f, list_pos = %d(%f), sy = %f\n", baseListPosRow, drag_pos.y, pos.y, list_pos, baseListPosRow * param.paneCol + sy / param.defSY, sy );
            }
					se = true;
          }
        }else{
          if( pos.y > uy ){
            pos.y -= ( param.defSY * static_cast<f32>(param.paneRow) );
            f32	sy = ReviseFloat( drag_pos.y - pos.y );
            s32	list_pos =  static_cast<s32>( baseListPosRow + sy / param.defSY ) *param.paneCol + c;
            if( list_pos >= param.valMax ){
              SetPaneVisible( param.paneList[ tbl[i] ].pict, false );
            }else{
              SetPaneVisible( param.paneList[ tbl[i] ].pict, true );
              param.cbFunc->CallBack_ListWrite( param.paneList, tbl[i], list_pos );
            }
            // GFL_PRINT( "ds = %f, dpy = %f, py = %f, list_pos = %d(%f), sy = %f\n", baseListPosRow, drag_pos.y, pos.y, list_pos, baseListPosRow * param.paneCol + sy / param.defSY, sy );
            se = true;
          }
        }
        SetPanePos( param.paneList[ tbl[i] ].pict, pos );
      }
    }
    ry -= param.defSY;
  }

	if( se == true ){
		PlayCursorMoveSE();
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		L[ł̃XgXN[
 *
 * @param		mv			ړ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void CellList::ScrollListPutKey( int mv )
{
	ScrollListPut( param.defSY / ScrollFrame[trgSpeed] * mv, mv );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		_␳
 *
 * @param		p		␳l
 *
 * @return	␳l
 *
 * @li	0.9999ȏJグA0.0001j
 */
//--------------------------------------------------------------------------------------------
f32 CellList::ReviseFloat( f32 p )
{
	f32	pa = static_cast<f32>( static_cast<s32>(p) );
	f32	pb = p - pa;
	if( pb >= 0.9999f ){
		if( pa > 0.0f ){
			return ( pa + 1.0f );
		}else{
			return ( pa - 1.0f );
		}
	}else if( pb < 0.0001f ){
		return pa;
	}
	return p;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		XN[̃Xgʒu␳
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void CellList::ReviseInitScrollList(void)
{
	s32	tbl[param.paneListMax];
	u32 def_row;
	f32	def_y;

	def_row = MakePabeListRowTable( tbl, DEFAULT_PANE_NONE, &def_y ) / param.paneCol;

  for( u32 r=0; r<param.paneRow;++r){
    for(u32 c=0; c<param.paneCol;++c){
      u32 i = r*param.paneCol+c;
      gfl::math::VEC3	pos = GetPanePos( param.paneList[ tbl[i] ].pict );
      if( tbl[i] / param.paneCol == def_row ){
        pos.y = param.defPY;
      }else{
        pos.y = param.defPY + def_y;
      }
      SetPanePos( param.paneList[ tbl[i] ].pict, pos );
      
      // GFL_PRINT( "[%d] %f %f def%f r%ddr%d\n", tbl[i], pos.x, pos.y, def_y, r, def_row );
    }
    def_y -= param.defSY;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		XgyCYW̃e[u쐬
 *
 * @param		tbl					̂݃e[u쐬ꏊ
 * @param		def_index		ƂȂyC̃CfbNX
 * @param		def_y				zuJnYW쐬ꏊ
 *
 * @return	ƂȂyC̃CfbNX
 *
 * @li	"def_index = DEFAULT_PANE_NONE"̏ꍇAJ[\0̈ʒuƂ
 */
//--------------------------------------------------------------------------------------------
u32 CellList::MakePabeListRowTable( s32 * tbl, u32 def_index, f32 * def_y )
{
	// e[u
  u32 cnt = 0;
	for( u32 i=0; i<param.paneListMax; i++ ){
		tbl[i] = i;
	}

	// YW̑傫ɕёւ
	for( u32 i=0; i<param.paneListMax-1; i+=param.paneCol ){
		gfl::math::VEC3	p1 = GetPanePos( param.paneList[ tbl[i] ].pict );
		for( u32 j=i+param.paneCol; j<param.paneListMax; j+=param.paneCol ){
			gfl::math::VEC3	p2 = GetPanePos( param.paneList[ tbl[j] ].pict );
			if( p1.y < p2.y ){
        s32 tmp[ param.paneCol ];
        for( u32 c = 0; c< param.paneCol; ++c) {
          tmp[c]    = tbl[i+c];
          tbl[i+c]  = tbl[j+c];
          tbl[j+c]  = tmp[c];
        }
				p1 = p2;
			}
		}
	}

	// ʒuݒ
	// yCȂ̏ꍇ́AJ[\ÖʒuƂ
	if( def_index == DEFAULT_PANE_NONE ){
		gfl::math::VEC3	p1 = GetPanePos( param.paneList[0].pict );
		def_index = 0;
		for( u32 i=1; i<param.paneListMax; i++ ){
			gfl::math::VEC3	p2 = GetPanePos( param.paneList[i].pict );
			if( gfl::math::FAbs(p1.y-param.defPY) > gfl::math::FAbs(p2.y-param.defPY) ){
				def_index = i;
				p1 = p2;
			}
		}
	}
	*def_y = 0.0f;
	for( u32 r=0; r<param.paneRow; ++r ){
    for( u32 c=0; c<param.paneCol; ++c ){
      u32 i = r*param.paneCol+c;
      if( tbl[i] == def_index ){
        goto LOOP_EXIT;
      }
    }
    *def_y += param.defSY;
	}
LOOP_EXIT:

	return def_index;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		L[XN[ݒ
 *
 * @param		mv		ړ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void CellList::InitKeyScroll( int mv )
{
  scrollVec = mv;
  scrollCount = 0;
  trgCount = 0;
  trgSpeed = 0;
  
  basePane = GetDefaultPositionPane();
  baseListPosRow = param.listScroll / param.paneCol;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		J[\ړ
 *
 * @param		val		ړl
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void CellList::CursorMove( int val, bool is_se )
{
	// ʏ
  CB_CursorOff( param.listPos );
  param.listPos += val;
  CB_CursorMove( param.listPos );
  
  if( val != 0 )
  {
	  PlayCursorMoveSE();
  }
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		y[WF
 *
 * @param		none
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
u32 CellList::PageUp(void)
{
	if( param.listScroll != 0 ){
		CB_CursorOff( param.listPos );
		f32	tmp = param.listScroll;
		if( param.listScroll < param.listPosMax ){
			param.listScroll = 0;
		}else{
			param.listScroll -= param.listPosMax;
		}
		CB_ItemChange(
			static_cast<u32>(tmp)+param.listPos,
			static_cast<u32>(param.listScroll)+param.listPos );
		InitListPut();
		PlayCursorMoveSE();
		return RET_LIST_PAGE_UP;
	}else if( param.listPos != 0 ){
		CB_CursorOff( param.listPos );
		CB_ItemChange(
			static_cast<u32>(param.listScroll)+param.listPos, static_cast<u32>(param.listScroll) );
		param.listPos = 0;
		InitListPut();
		PlayCursorMoveSE();
		return RET_LIST_PAGE_UP;
	}
	return RET_NONE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		y[WF
 *
 * @param		none
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
u32 CellList::PageDown(void)
{
	if( param.listScroll != listScrollMax ){
		CB_CursorOff( param.listPos );
		f32	tmp = param.listScroll;
		if( param.listScroll > (listScrollMax-(param.listPosMax-1)) ){
			param.listScroll = listScrollMax;
		}else{
			param.listScroll += param.listPosMax;
		}
		CB_ItemChange(
			static_cast<u32>(tmp)+param.listPos,
			static_cast<u32>(param.listScroll)+param.listPos );
		InitListPut();
		PlayCursorMoveSE();
		return RET_LIST_PAGE_DOWN;
	}else if( param.listPos != (param.listPosMax-1) ){
		CB_CursorOff( param.listPos );
		u32	tmp = param.listPos;
		param.listPos = param.listPosMax - 1;
		CB_ItemChange(
			static_cast<u32>(param.listScroll)+tmp, static_cast<u32>(param.listScroll)+param.listPos );
		InitListPut();
		PlayCursorMoveSE();
		return RET_LIST_PAGE_DOWN;
	}
	return RET_NONE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		hbOp`FbN
 *
 * @param		none
 *
 * @retval	"true = hbO"
 * @retval	"false = ȊO"
 */
//--------------------------------------------------------------------------------------------
bool CellList::CheckDragContinue(void)
{
	if( CheckCatchItem() == true ){
		return false;
	}

	gfl::ui::TouchPanel * tp = GetTouchPanel();

	if( tp->IsTouch() == true ){
		u16	x, y;
		tp->GetXY( &x, &y );

		f32	tpx = static_cast<f32>( x-160 );
		f32	tpy = static_cast<f32>( 120-y );

		return CheckTouchArea( tpx, tpy );
	}

	return false;
}

bool CellList::CheckCatchItem(void)
{
	if( param.catchFlag == true && catchCount == 40 ){
		return true;
	}
	return false;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		yC̃Xgʒu擾
 *
 * @param		none
 *
 * @return	Xgʒu
 */
//--------------------------------------------------------------------------------------------
f32 CellList::GetBaseListPosRow(void)
{
	gfl::math::VEC3	pos = GetPanePos( param.paneList[basePane].pict );
	return ( param.listScroll/param.paneCol-(pos.y-param.defPY)/param.defSY );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		hbÕXN[l
 *
 * @param		none
 *
 * @return	XN[l
 */
//--------------------------------------------------------------------------------------------
f32 CellList::GetUpdateDragScroll(void)
{
	// I[gXN[ɑJڂƂ
	if( updateSeq == PANELIST_SEQ_AUTO_SCROLL ){
		return pScrollValue->GetCurrentValue();
	// ͑҂ɑJڂƂ
	}else if( updateSeq == PANELIST_SEQ_INPUT ){
		return param.listScroll;
	}
	// LȊO
	gfl::math::VEC3 pos = GetPanePos( param.paneList[basePane].pict );
	return ( param.listScroll + ( static_cast<f32>(param.listPos) - (param.defPY-pos.y) / param.defSY ) );
}




void CellList::InitKeyScrollChange( int mv )
{
	scrollVec = mv;
	scrollCount = 0;
	trgCount = 0;
	trgSpeed = 0;

	baseListPosRow = param.listScroll / param.paneCol;

  basePane = GetPosPaneIndex( param.listPos );

  for( u32 c=0; c<param.paneCol; ++c )
  {
    u32 i = (basePane/param.paneCol)*param.paneCol + c;
	  SetItemChangePanePriority( i, true );
  }
}

void CellList::SetItemChangePanePriority( u32 index, bool flg )
{
	gfl::math::VEC3	pos = GetPanePos( param.paneList[index].pict );
	if( flg == true ){
		pos.z = 0.1f;
	}else{
		pos.z = 0.0f;
	}
	SetPanePos( param.paneList[index].pict, pos );
}


void CellList::PlayCursorMoveSE(void)
{
  if( param.moveSE != 0 )
  {
	  xy_snd::PlaySE( param.moveSE );
  }
}

void CellList::Debug_ListInfo(void)
{
#if PM_DEBUG
  for( u32 r=0; r<param.paneRow;++r){
    for(u32 c=0; c<param.paneCol;++c){
      u32 i = r*param.paneCol+c;
      gfl::math::VEC3	pos = GetPanePos( param.paneList[ i ].pict );
      GFL_PRINT( "[%d] %f %f def%f r%ddr%d\n", i, pos.x, pos.y );
    }
  }
#endif
}

GFL_NAMESPACE_END( tool )
GFL_NAMESPACE_END( app )
