//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		H3dObonShaderModel.cpp
 *	@brief  ~VF[_[f
 *	@author	Masateru Ishiguro
 *	@date		2011.12.15
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#define BUILD_XY

#if defined BUILD_XY
  #include <system/H3dObonShaderModel.h>
#else
  #include "H3dObonShaderModel.h"
#endif


namespace xy_system {
  
const char* H3dObonShaderModel::s_ParamNames[H3dObonShaderModel::CustomParam::ParamMax] = 
{
  "ShaderSymbol_1",
  "ShaderSymbol_2",
  "ShaderSymbol_3",
  "ShaderSymbol_4",
  "ShaderSymbol_5",
  "ShaderSymbol_6",
  "ShaderSymbol_7"
};

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
H3dObonShaderModel::CustomParam::CustomParam()
{
  for( s32 i = 0; i < CustomParam::ParamMax; ++i )
  {
    this->m_Handle[i] = -1;
  }
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------  
H3dObonShaderModel::H3dObonShaderModel(void) : H3dShaderModel()
{
  
}
  
//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
H3dObonShaderModel::~H3dObonShaderModel()
{
  H3dObonShaderModel::Destroy();
}


//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void H3dObonShaderModel::Create(
    gfl::heap::NwAllocator*           allocator,
    gfl::heap::NwAllocator*           device_allocator,
    gfl::grp::g3d::H3dResource*          resource,
    s32                               index_in_resource,
    Description*                      description
)
{
  gfl::heap::HeapBase* pHeap = allocator->GetHeapBase();

  H3dShaderModel::Create( allocator, device_allocator, resource, index_in_resource, description );
  readShaderParam(allocator);
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void H3dObonShaderModel::Destroy(void)
{
  GFL_SAFE_DELETE_ARRAY( m_pCustomParamArray );
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void H3dObonShaderModel::readShaderParam(gfl::heap::NwAllocator* allocator)
{
  m_MaterialCount = this->GetMaterialCount();
  
  {//ftHgp[^[ޔ  
    m_pCustomParamArray = GFL_NEW( allocator->GetHeapBase() ) CustomParam[ m_MaterialCount ];

    for( s32 i = 0; i < m_MaterialCount; ++i )
    {
      for( s32 i2 = 0; i2 < CustomParam::ParamMax; ++i2 )
      {
        s32     index = this->GetShaderSymbolIndex( i, s_ParamNames[i2] );
        if ( index >= 0 )
        {
          m_pCustomParamArray[i].m_Handle[i2] = index;
          this->GetShaderSymbolVSFloat( i, m_pCustomParamArray[i].m_Handle[i2], &m_pCustomParamArray[i].m_Value[i2] );
        }
      }
    }
  }
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void H3dObonShaderModel::setVertexShaderParam( int id, gfl::math::VEC4 param )
{
  for( int i = 0; i < m_MaterialCount; ++i )
  {
    s32     index = m_pCustomParamArray[i].m_Handle[id];
    if ( index >= 0 )
    {
      this->SetShaderSymbolVSFloat( i, index, param );
    }
  }
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void H3dObonShaderModel::SetMetaBallParam( const H3dObonShaderModel::MetaBallParam &param )
{
  gfl::math::VEC4     value;
  
  if( m_pCustomParamArray[0].m_Handle[0] == -1 )
    return;//ObonShaderMaterialłȂƂ݂ȂB
  
  value.Set( param.m_OwnPos.x, param.m_OwnPos.y, param.m_OwnPos.z, 0.0f );
  setVertexShaderParam( CustomParam::ShaderSymbol_1, value );
  
  value.Set( param.m_LeftPos.x, param.m_LeftPos.y, param.m_LeftPos.z, param.m_LeftKusaAlpha );
  setVertexShaderParam( CustomParam::ShaderSymbol_2, value );
  
  value.Set( param.m_LeftPipeCurve, 1.0f, param.m_LeftPipeWidth, param.m_LeftAnimTime );
  setVertexShaderParam( CustomParam::ShaderSymbol_3, value );
  
  value.Set( param.m_RightPos.x, param.m_RightPos.y, param.m_RightPos.z, param.m_RightKusaAlpha );
  setVertexShaderParam( CustomParam::ShaderSymbol_4, value );
  
  value.Set( param.m_RightPipeCurve, 1.0f, param.m_RightPipeWidth, param.m_RightAnimTime );
  setVertexShaderParam( CustomParam::ShaderSymbol_5, value );
  
  value.Set( param.m_RightCurveWaight.x, param.m_RightCurveWaight.y, param.m_LeftCurveWaight.x, param.m_LeftCurveWaight.y );
  setVertexShaderParam( CustomParam::ShaderSymbol_6, value );
  
  value.Set( param.m_MyRadius, param.m_LeftRadius, param.m_RightRadius, param.m_MerikomiScale );
  setVertexShaderParam( CustomParam::ShaderSymbol_7, value );
  
}

}  // namespace xy_system

