//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		H3dObonShaderModel.h
 *	@brief  ~VF[_[f
 *	@author	Masateru Ishiguro
 *	@date		2011.12.15
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#ifndef __H3d_Obon_SHADER_MODEL_H__
#define __H3d_Obon_SHADER_MODEL_H__

// CTR_SDK

// NW4C
#include <nw/gfx.h>
#include <nw/gfx/gfx_Model.h>

// gflib
#include <gfl_Macros.h>
#include <gfl_Heap.h>

//  gflib grp
#include <grp/gfl_RenderTarget.h>

// gflib grp g3d
#include <grp/g3d/gfl_G3dModel.h>
#include <grp/g3d/gfl_G3dCamera.h>
#include <grp/g3d/gfl_G3dShadowGroup.h>

#include <math/gfl_Vec.h>
#include <math/gfl_MathAABB.h>

#include <base/gfl_KeyContainer.h>

#include "H3dShaderModel.h"

#define DECLARE_ENUM_BEGIN( CLASSNAME )	\
	class CLASSNAME {											\
	public:																\
		enum Enum {
#define DECLARE_ENUM_END( CLASSNAME )		\
		};                                  \
	};

namespace xy_system {
  
class H3dObonShaderModel : public H3dShaderModel
{
  GFL_FORBID_COPY_AND_ASSIGN(H3dObonShaderModel);
  
  struct CustomParam{
    CustomParam();
    
    enum{
      ShaderSymbol_1 = 0,
      ShaderSymbol_2,
      ShaderSymbol_3,
      ShaderSymbol_4,
      ShaderSymbol_5,
      ShaderSymbol_6,
      ShaderSymbol_7,
      ParamMax
    };
    
    gfl::math::VEC4             m_Value[ParamMax];
    s32                         m_Handle[ParamMax];
  };
  
  static const char* s_ParamNames[H3dObonShaderModel::CustomParam::ParamMax];
  
public:
  
  struct MetaBallParam{
    gfl::math::VEC3       m_OwnPos;           ///! g̈ʒu
    gfl::math::VEC3       m_LeftPos;          ///! Ώۂڂ̈ʒu
    gfl::math::VEC3       m_RightPos;         ///! EΏۂڂ̈ʒu
    
    f32                   m_LeftPipeCurve;    ///! pCv̋Ȃ
    f32                   m_RightPipeCurve;   ///! pCv̋Ȃ
    f32                   m_LeftPipeWidth;    ///! pCv
    f32                   m_RightPipeWidth;   ///! pCv
    
    gfl::math::VEC2       m_LeftCurveWaight;  ///! pCvȂé͈idj
    gfl::math::VEC2       m_RightCurveWaight; ///! pCvȂé͈idj
    
    f32                   m_LeftKusaAlpha;    ///! ȂƂ͈̑
    f32                   m_RightKusaAlpha;   ///! ȂƂ͈̑
    
    f32                   m_LeftAnimTime;     ///! Đ(0.0?1.0f)
    f32                   m_RightAnimTime;    ///! Đ(0.0?1.0f)
    
    f32                   m_MyRadius;         ///! ̔a
    f32                   m_LeftRadius;       ///! Ώ۔a
    f32                   m_RightRadius;      ///! EΏ۔a
    f32                   m_MerikomiScale;    ///! ߂荞݃XP[(ŒlɂȂH)
    
    MetaBallParam():
      m_MerikomiScale(1.0f)
    {
      
    }
  };
  
  //-----------------------------------------------------------------------------
  /*
   *  @brief         RXgN^
   *                 Create͌Ă΂܂B
   */
  //-----------------------------------------------------------------------------
  H3dObonShaderModel(void);
  //-----------------------------------------------------------------------------
  /*
   *  @brief         fXgN^
   *                 DestroyĂт܂B
   */
  //-----------------------------------------------------------------------------
  virtual ~H3dObonShaderModel();
  
  //-----------------------------------------------------------------------------
  /*
   *  @brief         
   *
   *  @param[in]     allocator          AP[^
   *  @param[in]     device_allocator   foCX̃AP[^
   *  @param[in]     resource           \[X
   *  @param[in]     index_in_resource  \[XɂCfbNX
   *  @param[in]     description        ݒe
   */
  //-----------------------------------------------------------------------------
  virtual void Create(
      gfl::heap::NwAllocator*           allocator,
      gfl::heap::NwAllocator*           device_allocator,
      gfl::grp::g3d::H3dResource*       resource,
      s32                               index_in_resource,
      Description*                      description  = NULL
  );
  
  //-----------------------------------------------------------------------------
  /*
   *  @brief         j
   *                 ĂłvBfXgN^͌Ă΂܂B 
   */
  //-----------------------------------------------------------------------------
  virtual void Destroy(void);
  
  void SetMetaBallParam( const MetaBallParam &param );
  
private:
  
  s32                           m_MaterialCount;
  CustomParam                   *m_pCustomParamArray;
  CustomParam                   m_ParamCash;
  
  void readShaderParam(gfl::heap::NwAllocator* allocator);
  void setVertexShaderParam( int id, gfl::math::VEC4 param );
  
  
  
};
  
#undef		DECLARE_ENUM_BEGIN
#undef		DECLARE_ENUM_END

}  // namespace xy_system

#endif
