//==============================================================================
/**
 * @file	comm_wait_main.h
 * @brief	ʐM\Av	C
 * @author	ichiraku_katsuhiko
 * @data	2012/10/06, 14:23
 */
// =============================================================================

#if !defined( __COMM_WAIT_MAIN_H__ )
#define	__COMM_WAIT_MAIN_H__

#include <netapp/comm_wait/comm_wait.h>

#include "comm_wait_view.h"

GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(comm_wait)

class MainSystem
{
private:
	//-------------------------------------
	/// CV[PX`
  //=====================================
	typedef enum {
		MAINSEQ_INIT = 0,
		MAINSEQ_MAIN,
		MAINSEQ_FADE_OUT,
		MAINSEQ_RELEASE,
		MAINSEQ_END,
	}ENUM_MAIN_SEQ;

public:
  // RXgN^
  MainSystem( APP_PARAM *prm );
  // fXgN^
  virtual ~MainSystem( void );

public:
	bool Update( void );
	void Draw( void );

private:
	void CreateSubWork( void );
	void DeleteSubWork( void );

	void SetFadeIn( void );
	void SetFadeOut( void );
	void SetFinish( void );	// Iݒ
	void SetMainSeq( ENUM_MAIN_SEQ seq );
	
	bool DoSeqProcess( void );

	// EFCg
	void SetWait( const int wait );
	bool IsEndWait( void ) const;

private:
	// CV[PX
	void MainSeq_Init( void );
	bool MainSeq_Release( void );
	void MainSeq_Fade( ENUM_MAIN_SEQ seq );
	void MainSeq_Main( void );

private:
  static const u32 APP_HEAP_SIZE    = 0x12000;   // Avp[Jq[vTCY
  static const u32 DEVICE_HEAP_SIZE = 0xD8000;   // Avp[JfoCXq[vTCY

private:
	ViewWork*								m_view;						///< `Ǘ
  app::util::Heap         m_heap;           ///< q[vǗ
  APP_PARAM*              m_appParam;       ///< Np[^
  ENUM_MAIN_SEQ 					m_seq;						///< JgV[PX
  bool                    m_isFinish;       ///< fItO

	u16											m_subseq;					///< TuV[PX
	int											m_wait;						///< EFCg

};


GFL_NAMESPACE_END(comm_wait)
GFL_NAMESPACE_END(netapp)


#endif	/* __COMM_WAIT_MAIN_H__ */

