//==============================================================================
/**
 * @file	comm_wait.cpp
 * @brief	ʐM\Av
 * @author	ichiraku_katsuhiko
 * @data	2012/10/06, 14:11
 */
// =============================================================================


#include <netapp/comm_wait/comm_wait.h>
#include "comm_wait_main.h"



GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(comm_wait)

// RXgN^
Proc::Proc( APP_PARAM *prm )
{
	m_appParam  = prm;
  CreateHeap();
	pMain = GFL_NEW( pHeap )	MainSystem( prm );
}

// fXgN^

Proc::~Proc( void )
{
	DeleteHeap();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Proc
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::InitFunc( gfl::proc::Manager * )
{
	return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ProcI
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::EndFunc( gfl::proc::Manager * )
{
	GFL_DELETE	pMain;
	return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ProcAbvf[g
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::UpdateFunc( gfl::proc::Manager * )
{
	if( pMain->Update() )
	{
	  return gfl::proc::RES_CONTINUE;
	}
  return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Proc`揈
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Proc::DrawFunc( gfl::proc::Manager * )
{
	pMain->Draw();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		VXeq[v쐬
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Proc::CreateHeap(void)
{
	pHeap = GFL_CREATE_HEAP( gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP ),
                           HEAPID_COMM_WAIT_SYS, SYS_HEAP_SIZE, gfl::heap::HEAP_TYPE_EXP, false );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		VXeq[v폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void Proc::DeleteHeap(void)
{
	gfl::heap::Manager::DeleteHeap( pHeap );
}

GFL_NAMESPACE_END(comm_wait)
GFL_NAMESPACE_END(netapp)

