//============================================================================================
/**
 * @file		app_pokelist_TimeLimit.cpp
 * @brief		ԃ`FbN
 * @author	Hiroyuki Nakamura
 * @date		12.10.06
 *
 * namespace	app::pokelist::
 */
//============================================================================================
#include "app/pokelist/app_pokelist_TimeLimit.h"


namespace app {
namespace pokelist {


//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^
 *
 * @param		limit_sec		ԁibj
 */
//--------------------------------------------------------------------------------------------
TimeLimit::TimeLimit( u32 limit_sec ) :
	m_limitSec( limit_sec ),
	m_startTick( 0 ),
	m_sec( 0 )
{
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^
 */
//--------------------------------------------------------------------------------------------
TimeLimit::~TimeLimit()
{
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 *
 * @param		none
 *
 * @retval	"true = Ԃ𒴂"
 * @retval	"false = ȊO"
 */
//--------------------------------------------------------------------------------------------
bool TimeLimit::Update(void)
{
	// ԂȂ
	if( m_limitSec == 0 ){
		return false;
	}

	// ԃI[o[
	if( m_sec >= m_limitSec ){
		return true;
	}

	nn::os::Tick now = nn::os::Tick::GetSystemCurrent();

	if( m_startTick == 0 ){
		m_startTick = now;
	}else{
		nn::fnd::TimeSpan ss = m_startTick.ToTimeSpan();
		nn::fnd::TimeSpan es = now.ToTimeSpan();
		m_sec = static_cast<u32>( (es.GetNanoSeconds()-ss.GetNanoSeconds()) / 1000000000 );
	}

	return false;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		c莞Ԃ̎擾
 *
 * @param		none
 *
 * @return	c莞ԁibj
 */
//--------------------------------------------------------------------------------------------
u32 TimeLimit::GetLimitSecond(void) const
{
	if( m_sec >= m_limitSec ){
		return 0;
	}
	return ( m_limitSec - m_sec );
}


}	// pokelist
}	// app
