//=============================================================================
/**
 * @file   gflnet_NexRankingClientListener.h
 * @brief  RankingClient֘AʒmCxgnh
 * @author h.suzuki
 */
//=============================================================================

#ifndef __GFLNET_NEX_RANKING_CLIENT_LISTENER_H__
#define __GFLNET_NEX_RANKING_CLIENT_LISTENER_H__

#include <nn.h>
#include <nex.h>
#include <gflib.h>


GFL_NAMESPACE_BEGIN(gflnet)
GFL_NAMESPACE_BEGIN(nex)

//------------------------------------------------------------------
/*!
 * @brief LOʒmCxgnh
 *
 * @note LO֘A̒ʒm󂯎ꍇ́A
 *       {NXpz֐ĂB
 */
//------------------------------------------------------------------
class NexRankingClientListener
{
//  GFL_FORBID_COPY_AND_ASSIGN(NexRankingClientListener); //Rs[RXgN^{֎~
public:

  //------------------------------------------------------------------
  /**
  * @brief XRAAbv[h̊ʒm
  *
  * @param[in] category  ΏۃJeSID
  * @param[in] result    s
  */
  //------------------------------------------------------------------
  virtual void OnNexRankingUploadScoreFinish( const u32 category, const nn::nex::qResult& result ){};

  //------------------------------------------------------------------
  /**
  * @brief XRA폜̊ʒm
  *
  * @param[in] category  ΏۃJeSID
  * @param[in] result    s
  */
  //------------------------------------------------------------------
  virtual void OnNexRankingDeleteScoreFinish( const u32 category, const nn::nex::qResult& result ){};

  //------------------------------------------------------------------
  /**
  * @brief ʏAbv[h̊ʒm
  *
  * @param[in] result    s
  */
  //------------------------------------------------------------------
  virtual void OnNexRankingUploadCommonDataFinish( const nn::nex::qResult& result ){};

  //------------------------------------------------------------------
  /**
  * @brief ʏ폜̊ʒm
  *
  * @param[in] result    s
  */
  //------------------------------------------------------------------
  virtual void OnNexRankingDeleteCommonDataFinish( const nn::nex::qResult& result ){};

  //------------------------------------------------------------------
  /**
  * @brief XRAύX̊ʒm
  *
  * @param[in] category  ΏۃJeSID
  * @param[in] result    s
  */
  //------------------------------------------------------------------
  virtual void OnNexRankingChageAttributesFinish( const u32 category, const nn::nex::qResult& result ){};

  //------------------------------------------------------------------
  /**
  * @brief XRAv̎擾ʒm
  *
  * @param[in] status XRA̓v
  */
  //------------------------------------------------------------------
  virtual void OnNexRankingGetStatsSuccess( const nn::nex::RankingStats& status ){};

  //------------------------------------------------------------------
  /**
  * @brief XRAv̎擾sʒm
  *
  * @param[in] result s
  */
  //------------------------------------------------------------------
  virtual void OnNexRankingGetStatsFailed( const nn::nex::qResult& result ){};

  //------------------------------------------------------------------
  /**
  * @brief LOʃf[^̎擾ʒm
  *
  * @param[in] data LOʃf[^
  */
  //------------------------------------------------------------------
  virtual void OnNexRankingGetCommonDataSuccess( const nn::nex::qVector<qByte>& data ){};

  //------------------------------------------------------------------
  /**
  * @brief LOʃf[^̎擾sʒm
  *
  * @param[in] result s
  */
  //------------------------------------------------------------------
  virtual void OnNexRankingGetCommonDataFailed( const nn::nex::qResult& result ){};

  //------------------------------------------------------------------
  /**
  * @brief LOXgf[^̎擾ʒm
  *
  * @param[in] data LOXgf[^
  */
  //------------------------------------------------------------------
  virtual void OnNexRankingGetListDataSuccess( const nn::nex::RankingResult& data ){};

  //------------------------------------------------------------------
  /**
  * @brief LOXgXg̎擾sʒm
  *
  * @param[in] result s
  */
  //------------------------------------------------------------------
  virtual void OnNexRankingGetListDataFailed( const nn::nex::qResult& result ){};


};


GFL_NAMESPACE_END(nex)
GFL_NAMESPACE_END(gflnet)



#endif // __GFLNET_NEX_RANKING_CLIENT_LISTENER_H__
