//=============================================================================
/**
 * @file   gflnet_NexRankingClient.h
 *
 * @brief  nn::nex::RankingClient̃bp[NXB
 *
 * @author h.suzuki
 */
//=============================================================================

#ifndef __GFLNET_NEX_RANKING_CLIENT_H__
#define __GFLNET_NEX_RANKING_CLIENT_H__


#include <gflib.h>
#include <gflnet.h>
#include <nex/gflnet_NexTemplate.h>
#include <nex/gflnet_NexRankingClientListener.h>

GFL_NAMESPACE_BEGIN(gflnet)
GFL_NAMESPACE_BEGIN(nex)

//------------------------------------------------------------------
/**
*  @brief LOiRankingClientANZXjpNX
*
*  @attention OɃQ[T[oփOCĂ
*  @attention e񓯊ʐM͔rƂȂׁAs͕sB
*
*  @note  {NX֐ɂ[nn::nex::UniqueId]w肷邱Ƃ
*         Z[uf[^ɃLOǗ邱Ƃ\B
*
**/
//------------------------------------------------------------------
class NexRankingClient
{
  GFL_FORBID_COPY_AND_ASSIGN(NexRankingClient); //Rs[RXgN^{֎~

public:
  NexRankingClient( void );
  virtual ~NexRankingClient();

public:
  //------------------------------------------------------------------
  /**
  * @brief  RankingClient̏
  *
  * @param[in]  credentials     Q[T[o[OC
  *
  * @return ɐȂtrueԋp
  */
  //------------------------------------------------------------------
  bool Initialize( nn::nex::Credentials* credentials );

  //------------------------------------------------------------------
  /**
  * @brief  RankingClient̏I
  */
  //------------------------------------------------------------------
  void Finalize( void );

  //------------------------------------------------------------------
  /**
  * @brief  RankingClientCX^X̎擾
  */
  //------------------------------------------------------------------
  nn::nex::RankingClient* GetRankingClient( void );

public:
  //------------------------------------------------------------------
  /**
  * @brief LOpXi̓o^
  *
  * @param[in] listener o^Ώۂ̃LOpXiB
  *
  * @return o^ɐȂtrueԋp
  */
  //------------------------------------------------------------------
  bool RegistRankingClientListener( NexRankingClientListener* listener );

  //------------------------------------------------------------------
  /**
  * @brief LOpXỉ
  *
  * @param[in] listener 폜Ώۂ̃LOpXiB
  */
  //------------------------------------------------------------------
  void UnregistRankingClientListener( NexRankingClientListener* listener );

public:
  //------------------------------------------------------------------
  /**
  * @brief XRAo^(񓯊֐)
  *
  * @param[in] scoreData    XRA
  * @param[in] nexUniqueId  NEXj[NIDiȗ\j
  *
  * @attention ƓvVpID̃XRÂݓo^\B
  *
  * @note 񓯊ʐMIɁuNexRankingClientListener::OnNexRankingDeleteScoreFinish()vR[B
  * @note {֐sꍇNexRankingClientListenerCxg̓R[ȂB
  *
  * @return sʁBtrueԋpB
  */
  //------------------------------------------------------------------
  bool UploadScore( const nn::nex::RankingScoreData& scoreData, nn::nex::UniqueId nexUniqueId );

  //------------------------------------------------------------------
  /**
  * @brief XRA폜(񓯊֐)
  *
  * @param[in] categoryId   폜ΏۃJeS
  * @param[in] nexUniqueId  NEXj[NIDiȗ\j
  *
  * @attention ƓvVpID̃XRÂݍ폜\B
  *
  * @note 񓯊ʐMIɁuNexRankingClientListener::OnNexRankingDeleteScoreFinish()vR[B
  * @note {֐sꍇNexRankingClientListenerCxg̓R[ȂB
  *
  * @return sʁBtrueԋpB
  */
  //------------------------------------------------------------------
  bool DeleteScore( u32 categoryId, nn::nex::UniqueId nexUniqueId = nn::nex::INVALID_UNIQUEID );

  //------------------------------------------------------------------
  /**
  * @brief ʃf[^o^(񓯊֐)
  *
  * @param[in] pCommonData    ʏւ̃|C^
  * @param[in] commonDataSize ʏf[^TCY(ő255oCgj
  * @param[in] nexUniqueId    NEXj[NIDiȗ\j
  *
  * @attention ƓvVpID̋ʃf[^̂ݓo^\B
  *
  * @note 񓯊ʐMIɁuNexRankingClientListener::OnNexRankingUploadCommonDataFinish()vR[B
  * @note {֐sꍇNexRankingClientListenerCxg̓R[ȂB
  *
  * @return sʁBtrueԋpB
  */
  //------------------------------------------------------------------
  bool UploadCommonData( const void* pCommonData, qByte commonDataSize, nn::nex::UniqueId nexUniqueId = nn::nex::INVALID_UNIQUEID );

  //------------------------------------------------------------------
  /**
  * @brief ʃf[^폜(񓯊֐)
  *
  * @param[in] nexUniqueId  NEXj[NIDiȗ\j
  *
  * @attention ƓvVpID̃XRÂݍ폜\B
  *
  * @note 񓯊ʐMIɁuNexRankingClientListener::OnNexRankingDeleteScoreFinish()vR[B
  * @note {֐sꍇNexRankingClientListenerCxg̓R[ȂB
  *
  * @return sʁBtrueԋpB
  */
  //------------------------------------------------------------------
  bool DeleteCommonData( nn::nex::UniqueId nexUniqueId = nn::nex::INVALID_UNIQUEID );

  //------------------------------------------------------------------
  /**
  * @brief XRȂlύX(񓯊֐)
  *
  * @param[in] categorId    ύXJeSID
  * @param[in] changeParam  ύXڍ׏
  * @param[in] nexUniqueId  NEXj[NIDiȗ\j
  *
  * @attention ƓvVpID̃XRȂl̂ݕύX\B
  *
  * @note 񓯊ʐMIɁuNexRankingClientListener::OnNexRankingChageAttributesFinish()vR[B
  * @note {֐sꍇNexRankingClientListenerCxg̓R[ȂB
  *
  * @return sʁBtrueԋpB
  */
  //------------------------------------------------------------------
  bool ChangeAttributes( u32 categorId, const nn::nex::RankingChangeAttributesParam& changeParam, nn::nex::UniqueId nexUniqueId = nn::nex::INVALID_UNIQUEID );

  //------------------------------------------------------------------
  /**
  * @brief ʃf[^擾(񓯊֐)
  *
  * @param[in] nexUniqueId  NEXj[NIDiȗ\j
  *
  * @attention ƓvVpID̃XRȂl̂ݕύX\B
  *
  * @note  ÍuNexRankingClientListener::OnNexRankingGetCommonDataSuccess()vR[B
  * @note  G[́uNexRankingClientListener::OnNexRankingGetCommonDataFailed()vR[B
  * @note  {֐sꍇNexRankingClientListenerCxg̓R[ȂB
  *
  * @return sʁBtrueԋpB
  */
  //------------------------------------------------------------------
  bool GetCommonData( nn::nex::UniqueId nexUniqueId = nn::nex::INVALID_UNIQUEID );

  //------------------------------------------------------------------
  /**
  * @brief XRAv擾(񓯊֐)
  *
  * @param[in] categoryId   擾ΏۃJeSID
  * @param[in] orderParam   ʌvZpp[^
  * @param[in] flags        擾铝vlw肷tOBunn::nex::RankingConstants::StatsFlagv̘_a
  *
  * @note  ÍuNexRankingClientListener::OnNexRankingGetStatsSuccess()vR[B
  * @note  G[́uNexRankingClientListener::OnNexRankingGetStatsFailed()vR[B
  * @note  {֐sꍇNexRankingClientListenerCxg̓R[ȂB
  *
  * @return sʁBtrueԋpB
  */
  //------------------------------------------------------------------
  bool GetStats( u32 categoryId, const nn::nex::RankingOrderParam& orderParam, u32 flags );

public:
  //------------------------------------------------------------------
  // ȉ̓R[obN֐ɂ̂݊J邽߁A[U[gp֎~I
  //------------------------------------------------------------------
  void OnUploadScoreCompletion(nn::nex::CallContext *pContext);
  void OnUploadCommonDataCompletion(nn::nex::CallContext *pContext);
  void OnDeleteScoreCompletion(nn::nex::CallContext *pContext);
  void OnDeleteCommonDataCompletion(nn::nex::CallContext *pContext);
  void OnChangeAttributesCompletion(nn::nex::CallContext *pContext);
  void OnGetCommonDataCompletion(nn::nex::CallContext *pContext);
  void OnGetStatsCompletion(nn::nex::CallContext *pContext);

private:
  static const u32                              LISTENER_NUM = 4;         //!< Xiőo^\

  bool                                          m_isInit;                 //!< tO
  bool                                          m_isAccess;               //!< ʐMtO
  //
  nn::nex::RankingClient*                       m_rankingClient;          //!< RankingNCAg
  //
  NexRankingClientListener*                     m_listener[LISTENER_NUM]; //!< LOpXi
  //
  u32                                           m_categoryId;             //!< JeSID
  nn::nex::qVector<qByte>*                      m_commonData;             //!< ʏ
  nn::nex::RankingResult*                       m_rankResultInf;          //!< LOXg
  nn::nex::RankingStats*                        m_rankStats;              //!< XRAv
};

GFL_NAMESPACE_END(nex)
GFL_NAMESPACE_END(gflnet)

#endif  // __GFLNET_NEX_RANKING_CLIENT_H__
