//============================================================================
/**
 *
 *	@file		dowsing.cpp
 *	@brief  _EWO
 *	@data		2012.10.04
 *
 */
//============================================================================

#include "dowsing.h"
#include "field/hideitem/FieldHideItem.h"

namespace field
{

namespace dowsing
{

Dowsing::Dowsing( Fieldmap* p_Fieldmap, hideitem::Manager*  p_HideItemMng )
{
  mp_Fieldmap = p_Fieldmap;
  mp_HideItemMng = p_HideItemMng;

  mAboveSeFlag = false;
  mAboveSeWait = 0;

  mStatePrev = 0;
  mStateCurr = 0;

}

Dowsing::~Dowsing()
{
  ;
}

void Dowsing::Update( void )
{
  s32             player_grid_pos_x;
  s32             player_grid_pos_z;

  // ȌԂoĂ
  mStatePrev = mStateCurr;

  // 
  PlayerGrid* p_player = mp_Fieldmap->GetFieldPlayer();
  const Grid *p_grid = p_player->GetGrid();
  p_grid->GetPlanePos( &player_grid_pos_x, &player_grid_pos_z );
  gfl::math::VEC3 player_pos;
  p_player->GetPos( &player_pos );

  bool just_hit = false;

  // ACeT[`
  {
    int  item_search_num = mp_HideItemMng->GetDataNum();

    s32 rect_x_min = player_grid_pos_x - AREA_ORIGIN_X;  // rect_x_min<= <rect_x_max
    s32 rect_x_max = player_grid_pos_x + AREA_WIDTH - AREA_ORIGIN_X;
    s32 rect_z_min = player_grid_pos_z - AREA_ORIGIN_Z;  // rect_z_min<= <rect_z_max
    s32 rect_z_max = player_grid_pos_z + AREA_HEIGHT - AREA_ORIGIN_Z;
    
    u32       distance_sq_min = 0xFFFFFFFF;
    ITEM_INFO distance_min_item_info = { NULL };

    EventWork* evwork = mp_Fieldmap->GetGameManager()->GetGameData()->GetEventWork();

    for( int i=0; i<item_search_num;i++ ) 
    {
      s32       x;
      s32       z;
      u16 hide_item_data_num;
      const hideitem::Manager::HideItem*   hide_item_data;
      
      hide_item_data  =
        mp_HideItemMng->SearchHideItemForDowsing( i, evwork, player_grid_pos_x, player_grid_pos_z, &just_hit );
      
      if( hide_item_data == NULL )  // ACe݂Ȃꍇ͎̃ACe
      {
        continue;
      }
      x = hide_item_data->GPosX;
      z = hide_item_data->GPosZ;

      // ͂ރT[`͈͂̋`̒ɂ邩
      if( !(    rect_x_min<=x && x<rect_x_max
             && rect_z_min<=z && z<rect_z_max ) )
      {
        continue;
      }

      //WXgqbg΂Ɍ肵Ă܂
      if ( just_hit )
      {
        distance_min_item_info.item_data = hide_item_data;
        NOZOMU_PRINT("^ɂ\n");
      }


      // ł߂
      {
        u32 distance_sq =   ( x - player_grid_pos_x ) * ( x - player_grid_pos_x ) \
                          + ( z - player_grid_pos_z ) * ( z - player_grid_pos_z );
        if( distance_sq < distance_sq_min )
        {
          distance_sq_min = distance_sq;
          distance_min_item_info.item_data = hide_item_data;
        }
      }
    }//end for

    // ̏
    if ( distance_min_item_info.item_data != NULL )
    {
      mStateCurr = 0;//@todo  ̌ڃZbg
    }
    else mStateCurr = 0; //@todo
  }

  
  // ̏ԂɕKvȉ̏s
  {
    bool can_play_se = true;

    // ^ɂƂ炷
    {
      if( just_hit )
      {
        bool play = false;
        if( !mAboveSeFlag )
        {
          // ^ɂƂ߂Ė炷
          play = true;
          mAboveSeFlag = true;
        }
        else
        {
          // ^ɂƂ炵
          if( mAboveSeWait == ABOVE_SE_WAIT )
          {
            if( /*!PMSND_CheckPlaySE_byPlayerID( mAboveSeplayerID )*/0 ) //@todo
            {
              mAboveSeWait--;
            }
          }
          else if( mAboveSeWait == 0 )
          {
            play = true;
          }
          else
          {
            mAboveSeWait--;
          }
        }
        if( play )
        {
///          int pitch = ABOVE_SE_PITCH;
///          work->above_seplayer_id = PMSND_GetSE_DefaultPlayerID( SEQ_SE_FLD_120 );
///          PMSND_PlaySE_byPlayerID( SEQ_SE_FLD_120, work->above_seplayer_id );
///          PMSND_SetStatusSE_byPlayerID( work->above_seplayer_id, PMSND_NOEFFECT, pitch, PMSND_NOEFFECT );
              // l͈̔͂́A-32768`32767łBpitch͐̒lōցA̒lŒႢ֕ω܂B}64ł傤ǔω܂B
          
          mAboveSeWait = ABOVE_SE_WAIT;
        }
        can_play_se = false;
      }
      else
      {
        // ^ɂƂ͂炳Ȃ
        mAboveSeFlag = false;
      }
    }
#if 0
    // 񏉂߂ČtƂÁAႤACetƂ
    // t炷
    if( can_play_se )
    {
      if( mStateCurr != ITEM_HIT )
      {
        if( mItemInfoCurr.type != ITEM_TYPE_NONE )
        {
          BOOL different_item = false;
          
          // ꏊœႤf
          s32 prev_x;
          s32 prev_z;
          s32 curr_x;
          s32 curr_z;
          if( mItemInfoPrev.type == ITEM_TYPE_HIDE )
          {
            prev_x = mItemInfoPrev.item_data->x;
            prev_z = mItemInfoPrev.item_data->z;
          }
          else
          {
            // 񏉂߂ČtƂ
            different_item = true;
            break;
          }

          if( mItemInfoCurr.type == ITEM_TYPE_HIDE )
          {
            curr_x = mItemInfoCurr.item_data->x;
            curr_z = mItemInfoCurr.item_data->z;
          }

          if( prev_x != curr_x || prev_z != curr_z )
          {
            // ႤACetƂ
            if( mStatePrev != mStateCurr ) // ႤACetĂAbhĂȂACe͖炳ȂB
            {
              different_item = true;
            }
            break;
          }
          
          if( different_item )
          {
            SEPLAYER_ID seplayer_id = PMSND_GetSE_DefaultPlayerID( SEQ_SE_FLD_120 );
            int pan = ( (int)( kid_info[work->rod_curr].pan ) -8 ) * 16;
            if( pan < -127 )      pan = -127;  // {-128܂OKAEƍ킹-127܂łɂĂ
            else if( pan >  127 ) pan =  127;
            PMSND_PlaySE_byPlayerID( SEQ_SE_FLD_120, seplayer_id );
            PMSND_SetStatusSE_byPlayerID( seplayer_id, PMSND_NOEFFECT, PMSND_NOEFFECT, pan );
                // l͈̔͂́A-128`127łB̒lŉE̕ցA̒lō̕ֈړ܂B
            can_play_se = false;
          }
        }
      }
    }

    // bh炷
    if( can_play_se )
    {
      if( mStatePrev != mStateCurr )
      {
        PMSND_PlaySE( SEQ_SE_FLD_122 );
        can_play_se = false;
      }
    }
#endif
  }
 
}

} // namespace dowsing

} //namespace field
