//======================================================================
/**
 * @file  NexHttpResponse.cpp
 *
 * @author  suzuki
 */
//======================================================================

#include <netapp/http/NexHttpResponse.h>


GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(http)


//--------------------------------------------------------------------------------------------
/**
* @brief RXgN^
*
* @param none
*
* @return none
*/
//--------------------------------------------------------------------------------------------
NexHttpResponse::NexHttpResponse( void )
{
  m_receivedBuffer = qNew nn::nex::qVector<nn::nex::qByte>;
  m_statusCode = 0;
}


//--------------------------------------------------------------------------------------------
/**
* @brief fXgN^
*
* @param none
*
* @return none
*/
//--------------------------------------------------------------------------------------------
NexHttpResponse::~NexHttpResponse()
{
  gflnet::nex::NexFreeCollection( &m_receivedBuffer );
}


//--------------------------------------------------------------------------------------------
/**
* @brief HTTPXe[^XR[h擾
*
* @param none
*
* @return HTTPXe[^XR[h
*/
//--------------------------------------------------------------------------------------------
nn::nex::qInt NexHttpResponse::GetStatusCode() const
{
  return m_statusCode;
}


//--------------------------------------------------------------------------------------------
/**
* @brief HTTPX|Xobt@擾
*
* @param none
*
* @return HTTPX|Xobt@
*/
//--------------------------------------------------------------------------------------------
const nn::nex::qVector<nn::nex::qByte>& NexHttpResponse::GetReceiveBuffer() const
{
  return *m_receivedBuffer;
}


//--------------------------------------------------------------------------------------------
/**
* @brief HTTPX|Xobt@NA
*
* @param none
*
* @return none
*/
//--------------------------------------------------------------------------------------------
void NexHttpResponse::ResetReceiveBuffer()
{
  m_receivedBuffer->clear();
}



GFL_NAMESPACE_END(nex)
GFL_NAMESPACE_END(netapp)
