//======================================================================
/**
 * @file  NexHttpConnection.cpp
 *
 * @author  suzuki
 */
//======================================================================

#include <netapp/http/NexHttpConnection.h>


GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(http)


//--------------------------------------------------------------------------------------------
/**
* @brief RXgN^
*
* @param none
*
* @return none
*/
//--------------------------------------------------------------------------------------------
NexHttpConnection::NexHttpConnection( void )
{
}


//--------------------------------------------------------------------------------------------
/**
* @brief fXgN^
*
* @param none
*
* @return none
*/
//--------------------------------------------------------------------------------------------
NexHttpConnection::~NexHttpConnection()
{
}

//--------------------------------------------------------------------------------------------
/**
* @brief HTTPݒo^
*
* @param setting HTTPݒ
*
* @return none
*/
//--------------------------------------------------------------------------------------------
void NexHttpConnection::SetSetting( const HttpConnectSetting& setting )
{
  std::memcpy( &m_setting, &setting, sizeof(HttpConnectSetting) );
}


//--------------------------------------------------------------------------------------------
/**
* @brief HTTPX|X̎擾
*
* @param none
*
* @return HTTPX|X
*/
//--------------------------------------------------------------------------------------------
const NexHttpResponse& NexHttpConnection::GetHttpResponse( void )
{
  NexHttpResponse* response = this;
  return *response;
}


// HTTPNGXgOɌĂяo܂Bp[^A[gCAؖ̃ZbgȂǂs܂B
//--------------------------------------------------------------------------------------------
/**
* @brief HTTPNGXgOɃR[B[callback]
*
* @note p[^A[gCAؖ̃ZbgȂǖ{֐ɂčs
*
* @attention  VXeĂяopR[obN֐ׁ̈A[U[gp͋֎~I
*
* @param conn  HTTPRlNVCX^X
*
* @return none
*/
//--------------------------------------------------------------------------------------------
// overwride
void NexHttpConnection::PrepareRequest( nn::nex::HttpConnection* conn )
{
  // ؖݒ
  if( (m_setting.certData != NULL) && (m_setting.certDataSize>0) ){
    conn->AddRootCa(m_setting.certData, m_setting.certDataSize);
  }

  // GR[h^Cv
  if( m_setting.postEncodeType ==  nn::http::ENCODING_TYPE_MULTIPART ){
    conn->AddHeaderField("Content-Type", "multipart/form-data");
  }
  else{
    conn->AddHeaderField("Content-Type", "application/x-www-form-urlencoded");
  }

  // HTTPwb_
  for( int i = 0; i < m_setting.addHeaderFieldNum; i++ ){
    conn->AddHeaderField( m_setting.addHeaderField[i].fieldName, m_setting.addHeaderField[i].fieldValue );
  }

  // POST BODY
  for( int i = 0; i < m_setting.addPostParamNum; i++ )
  {
    gflnet::http::PostParam *param = &m_setting.addPostParam[i];

    if( param->type == gflnet::http::E_POST_TYPE_ASCII ){
      conn->AddPostData( param->queryName, param->queryValue );
    }
    else if( param->type == gflnet::http::E_POST_TYPE_RAW ){
      conn->AddPostDataRaw( param->queryValue, param->queryValueSize );
    }
    else if( param->type == gflnet::http::E_POST_TYPE_BINARY ){
      GFL_ASSERT( false );
    }
  }
}


//--------------------------------------------------------------------------------------------
/**
* @brief HTTPNGXgwb_̎擾ɃR[[callback]
*
* @attention VXeĂяopR[obN֐ׁ̈A[U[gp͋֎~I
*
* @param conn       HTTPRlNVCX^X
* @param statusCode HTTPXe[^XR[h
*
* @return none
*/
//--------------------------------------------------------------------------------------------
// overwride
void NexHttpConnection::ProcessResponseHeader( nn::nex::HttpConnection *conn, nn::nex::qInt statusCode )
{
  GFL_PRINT( "NexHttpConnection::ProcessResponseHeader(%u)\n", statusCode );

  m_statusCode = statusCode;
}


//--------------------------------------------------------------------------------------------
/**
* @brief HTTPX|X{fB擾ɃR[[callback]
*
* @attention VXeĂяopR[obN֐ׁ̈A[U[gp͋֎~I
*
* @param buffer     X|X{fB
* @param bufferSize X|X{fB̃TCY
*
* @return f[^̎MɊƂ true AłȂƂ false ԋpB
*         true Ԃꍇ̓_E[hpB
*         false Ԃꍇ͎̖{֐Ăяoōēxf[^nB
*         (false Ԃ邱Ƃɂ_E[hꎞf邱Ƃ\Bj
*/
//--------------------------------------------------------------------------------------------
// overwride
qBool NexHttpConnection::ProcessResponse( const nn::nex::qUnsignedInt8* buffer, qUnsignedInt32 bufferSize )
{
  if( m_receivedBuffer != NULL )
  {
    GFL_PRINT( "NexHttpConnection::ProcessResponse(%u)\n", bufferSize );

    const nn::nex::qByte* byteArray = static_cast<const nn::nex::qByte*>(buffer);
    m_receivedBuffer->insert(m_receivedBuffer->end(), byteArray, byteArray + bufferSize);
  }
  return true;
}





GFL_NAMESPACE_END(nex)
GFL_NAMESPACE_END(netapp)
