//======================================================================
/**
 * @file  NexHttpClient.cpp
 *
 * @brief NEXgHTTPCupbp[NX
 *
 * @author  suzuki
 */
//======================================================================
#include <netapp/http/NexHttpClient.h>
#include "NexHttpConnection.h"


GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(http)

//--------------------------------------------------------------------------------------------
/**
* @brief RXgN^
*
* @param none
*
* @return none
*/
//--------------------------------------------------------------------------------------------
NexHttpClient::NexHttpClient( void )
{
  std::memset( m_listener, 0, sizeof(m_listener) );
  m_isInit   = false;
  m_isAccess = false;
}


//--------------------------------------------------------------------------------------------
/**
* @brief fXgN^
*
* @param none
*
* @return none
*/
//--------------------------------------------------------------------------------------------
NexHttpClient::~NexHttpClient()
{
  Finalize();
}


//--------------------------------------------------------------------------------------------
/**
* @brief 
*
* @param none
*
* @return ɐȂtrueԋp
*/
//--------------------------------------------------------------------------------------------
bool NexHttpClient::Initialize( void )
{
  if( m_isInit ){
    Finalize();
  }
  m_isInit   = true;
  m_isAccess = false;

  m_httpClient = qNew nn::nex::SimpleHttpClient();
  m_connection = qNew netapp::http::NexHttpConnection();

  return (m_httpClient!=NULL) && (m_connection != NULL);
}


//--------------------------------------------------------------------------------------------
/**
* @brief I
*
* @param none
*
* @return none
*/
//--------------------------------------------------------------------------------------------
void NexHttpClient::Finalize( void )
{
  if( m_isInit )
  {
    gflnet::nex::NexFreeMemory(&m_httpClient);
    gflnet::nex::NexFreeMemory(&m_connection);
    m_isInit = false;
  }
}


//------------------------------------------------------------------
/**
* @brief NexHttpClientpXi̓o^
*
* @param[in] listener o^ΏۂNexHttpClientpXiB
*
* @return o^ɐȂtrueԋp
*/
//------------------------------------------------------------------
bool NexHttpClient::RegistNexHttpClientListener( NexHttpClientListener* listener )
{
  for( u32 i = 0; i < LISTENER_NUM; i++ )
  {
    if( m_listener[i] == listener ){
      return false; // o^ς
    }
  }
  for( u32 i = 0; i < LISTENER_NUM; i++ )
  {
    if( m_listener[i] == NULL )
    {
      m_listener[i] = listener;
      return true; // o^
    }
  }

  return false;
}


//------------------------------------------------------------------
/**
* @brief NexHttpClientpXỉ
*
* @param[in] listener 폜ΏۂNexHttpClientpXiB
*/
//------------------------------------------------------------------
void NexHttpClient::UnregistNexHttpClientListener( NexHttpClientListener* listener )
{
  for( u32 i = 0; i < LISTENER_NUM; i++ )
  {
    if( m_listener[i] == listener )
    {
      m_listener[i] = NULL;
      return;
    }
  }
}


//------------------------------------------------------------------
/**
* @brief PostʐM̊Jn
*
* @param[in] setting         ANZXݒ
* @param[in] relayBufferSize xɃobt@ɓǂݏőTCYB ̊֐ɓnőobt@TCYw肵܂B
*/
//------------------------------------------------------------------
bool NexHttpClient::StartPost( const HttpConnectSetting &setting, qUnsignedInt32 relayBufferSize )
{
  if( m_httpClient == NULL ){
    return false;
  }
  m_isAccess = true;

  nn::nex::ProtocolCallContext* pContext = qNew nn::nex::ProtocolCallContext();
  nn::nex::String               url( setting.url );

  m_connection->ResetReceiveBuffer();
  m_connection->SetSetting( setting );

  pContext->SetTimeout( setting.timeoutMillSeconds );

  if( m_httpClient->Post( pContext, url, m_connection, relayBufferSize ) )
  {
    // [pContext]ReLXg͏IR[obNŉ
    qNew gflnet::nex::CallContextCallback<NexHttpClient>(this, &NexHttpClient::OnConnectCompletion, pContext );
    return true;
  }
  else
  {
    qDelete pContext;
    m_isAccess = false;
    return false;
  }
}


//------------------------------------------------------------------
/**
* @brief GetʐM̊Jn
*
* @param[in] url             ANZXݒ
* @param[in] relayBufferSize xɃobt@ɓǂݏőTCYB ̊֐ɓnőobt@TCYw肵܂B
*/
//------------------------------------------------------------------
bool NexHttpClient::StartGet( const HttpConnectSetting &setting, qUnsignedInt32 relayBufferSize )
{
  if( m_httpClient == NULL ){
    return false;
  }
  m_isAccess = true;

  nn::nex::ProtocolCallContext* pContext = qNew nn::nex::ProtocolCallContext();
  nn::nex::String               url( setting.url );

  m_connection->ResetReceiveBuffer();
  m_connection->SetSetting( setting );

  pContext->SetTimeout( setting.timeoutMillSeconds );

  if( m_httpClient->Get( pContext, url, m_connection, relayBufferSize ) )
  {
    // [pContext]ReLXg͏IR[obNŉ
    qNew gflnet::nex::CallContextCallback<NexHttpClient>(this, &NexHttpClient::OnConnectCompletion, pContext );
    return true;
  }
  else
  {
    qDelete pContext;
    m_isAccess = false;
    return false;
  }
}


//------------------------------------------------------------------
/**
 * @brief  [eBOZbVQ̊ʒmmp֐
 *
 * @attention R[obN֐ɂ̂݊J邽߁A[U[gp֎~I
 *
 * @param[in,out]  pContext ʒmΏۂƂȂReLXg
 */
//------------------------------------------------------------------
void NexHttpClient::OnConnectCompletion(nn::nex::CallContext *pContext)
{
  nn::nex::qResult result = pContext->GetOutcome();

  if( (qBool)result )
  {
    if( m_connection != NULL )
    {
      for( u32 i = 0; i < LISTENER_NUM; i++ )
      {
        if( m_listener[i] != NULL ){
          m_listener[i]->OnNexHttpConnectionSuccess( m_connection->GetHttpResponse() );
        }
      }
    }
  }
  else
  {
    for( u32 i = 0; i < LISTENER_NUM; i++ )
    {
      if( m_listener[i] != NULL ){
        m_listener[i]->OnNexHttpConnectionError( result );
      }
    }
  }
}


GFL_NAMESPACE_END(nex)
GFL_NAMESPACE_END(netapp)
