//======================================================================
/**
 * @file  NexHttpClient.h
 *
 * @author  suzuki
 */
//======================================================================
#ifndef __NETAPP_NEX_HTTP_CLIENT_H__
#define __NETAPP_NEX_HTTP_CLIENT_H__

#include <gflib.h>
#include <gflnet.h>

#include <netapp/http/NexHttpClientListener.h>
#include <netapp/http/NexHttpResponse.h>
#include <OnlineCore/src/NintendoHTTP/SimpleHttpClient.h>

GFL_NAMESPACE_BEGIN(netapp)

/**
 * @namespace netapp::http
 * @brief     NEXgHTTPCu
 */
GFL_NAMESPACE_BEGIN(http)


class NexHttpConnection;

//--------------------------------------------------------------------------------------------
/**
* @brief HTTPʐM`pp[^
*/
//--------------------------------------------------------------------------------------------
struct HttpConnectSetting
{
  char*                     url;                                     //!< ANZXURL
  s32                       timeoutMillSeconds;                      //!< ʐM^CAEg(~bj
  size_t                    addPostParamNum;                         //!< Postp[^
  gflnet::http::PostParam   addPostParam[HTTP_SETTING_PARAM_SIZE];   //!< Postp[^
  size_t                    addHeaderFieldNum;                       //!< MɒǉHttpwb_
  gflnet::http::HeaderParam addHeaderField[HTTP_SETTING_PARAM_SIZE]; //!< Headerp[^
  nn::http::EncodingType    postEncodeType;                          //!< GR[h^Cv
  u8*                       certData;                                //!< ؖւ̃|C^
  size_t                    certDataSize;                            //!< ؖ̃TCY


  void Initialize( void )
  {
    timeoutMillSeconds = 30 * 1000;
    addPostParamNum    = 0;
    addHeaderFieldNum  = 0;
    postEncodeType     = nn::http::ENCODING_TYPE_AUTO;
    certData           = NULL;
    certDataSize       = 0;
  }

  HttpConnectSetting()
  {
    Initialize();
  }
};


//--------------------------------------------------------------------------------------------
/**
 * @brief NEXgHTTPCupbp[NX
 *
 */
//--------------------------------------------------------------------------------------------
class NexHttpClient
{
public:
  //--------------------------------------------------------------------------------------------
  /**
   * @brief RXgN^
   *
   * @param none
   *
   * @return none
   */
  //--------------------------------------------------------------------------------------------
   NexHttpClient( void );

   //--------------------------------------------------------------------------------------------
   /**
    * @brief fXgN^
    *
    * @param none
    *
    * @return none
    */
   //--------------------------------------------------------------------------------------------
   virtual ~NexHttpClient();

public:
  //------------------------------------------------------------------
  /**
  * @brief NexHttpClientpXi̓o^
  *
  * @param[in] listener o^ΏۂNexHttpClientpXiB
  *
  * @return o^ɐȂtrueԋp
  */
  //------------------------------------------------------------------
  bool RegistNexHttpClientListener( NexHttpClientListener* listener );

  //------------------------------------------------------------------
  /**
  * @brief NexHttpClientpXỉ
  *
  * @param[in] listener 폜ΏۂNexHttpClientpXiB
  */
  //------------------------------------------------------------------
  void UnregistNexHttpClientListener( NexHttpClientListener* listener );

public:
  //--------------------------------------------------------------------------------------------
  /**
  * @brief 
  *
  * @param none
  *
  * @return ɐȂtrueԋp
  */
  //--------------------------------------------------------------------------------------------
  bool Initialize( void );

  //--------------------------------------------------------------------------------------------
  /**
  * @brief I
  *
  * @param none
  *
  * @return none
  */
  //--------------------------------------------------------------------------------------------
  void Finalize( void );

public:
  //--------------------------------------------------------------------------------------------
  /**
  * @brief PostʐM̊Jn
  *
  * @param[in] setting         ANZXݒ
  * @param[in] relayBufferSize xɃobt@ɓǂݏőTCYB ̊֐ɓnőobt@TCYw肵܂B
  */
  //--------------------------------------------------------------------------------------------
  bool StartPost( const HttpConnectSetting &setting, qUnsignedInt32 relayBufferSize = nn::nex::HttpConnection::DEFAULT_RELAY_BUFFER_SIZE );

  //--------------------------------------------------------------------------------------------
  /**
  * @brief GetʐM̊Jn
  *
  * @param[in] setting         ANZXݒ
  * @param[in] relayBufferSize xɃobt@ɓǂݏőTCYB ̊֐ɓnőobt@TCYw肵܂B
  */
  //--------------------------------------------------------------------------------------------
  bool StartGet( const HttpConnectSetting &setting, qUnsignedInt32 relayBufferSize = nn::nex::HttpConnection::DEFAULT_RELAY_BUFFER_SIZE );

public:
  //------------------------------------------------------------------
  /**
   * @brief  [eBOZbVQ̊ʒmmp֐
   *
   * @attention R[obN֐ɂ̂݊J邽߁A[U[gp֎~I
   *
   * @param[in,out]  pContext ʒmΏۂƂȂReLXg
   */
  //------------------------------------------------------------------
  void OnConnectCompletion(nn::nex::CallContext *pContext);

private:
  static const u32                 LISTENER_NUM = 4;          //!< Xiőo^\
  //
  bool                             m_isInit;                  //!< tO
  bool                             m_isAccess;                //!< ANZXtO
  //
  NexHttpClientListener*           m_listener[LISTENER_NUM];  //!< [eBOpXi
  nn::nex::SimpleHttpClient*       m_httpClient;              //!< HTTPNCAg
  netapp::http::NexHttpConnection* m_connection;              //!< HTTPRlNV
};


GFL_NAMESPACE_END(nex)
GFL_NAMESPACE_END(netapp)

#endif  // __NETAPP_NEX_HTTP_CLIENT_H__
