//======================================================================
//   ze ʃXNvg
//======================================================================

#include "message/script/msg_hotel_scr.h"
#include "poke_tool/poke_tool_Ribbon.h"

//--------------------------------------------------------------------------------
//  defines
//--------------------------------------------------------------------------------

#define WORK_HOTEL_GUEST_STATUS_ (LOCALWORK0)
#define WORK_HOTEL_MADAM_STATUS_ (LOCALWORK1)
#define WORK_HOTEL_MADAM_DATE_   (LOCALWORK2)

//! ze
enum // kHotelType
{
  kHotelTypeT03R0202 = 0,
  kHotelTypeT09R0402,
  kHotelTypeC03R0102,
  kHotelTypeT04R0102,
  kHotelTypeC05R0302,
  kHotelTypeT06R0102,

  kHotelTypeMax
};

/*!
 *  @brief  ւόq̏og
 *  - zeʂƓł邱
 */
enum // kHotelGuestArea
{
  kHotelGuestAreaKanto = 0, // Jg[
  kHotelGuestAreaJohto,     // WEg
  kHotelGuestAreaHoenn,     // zEG
  kHotelGuestAreaShinnoh,   // VIE
  kHotelGuestAreaUnova,     // CbV
  kHotelGuestAreaOther,     // ̑

  kHotelGuestAreaMax
};

//! j`
enum // kHotelWeek
{
  kHotelWeekMon = 0,
  kHotelWeekTue,
  kHotelWeekWed,
  kHotelWeekThu,
  kHotelWeekFri,
  kHotelWeekSat,     // 2000N 1 1(RTCJn)͓yj
  kHotelWeekSun,

  kHotelWeekDays
};

//--------------------------------------------------------------------------------
//  fields
//--------------------------------------------------------------------------------

// MsgLoad()ێp
new g_messageBuffer = NULL;

// ւόq̃bZ[We[u
new messages_[kHotelGuestAreaMax][6] =
{
  { // Jg[
    msg_hotel_scr_travel1_01, // Dx 1
    msg_hotel_scr_travel1_02, // Dx 2
    msg_hotel_scr_travel1_06, // Dx 3
    msg_hotel_scr_travel1_07, // J
    msg_hotel_scr_travel1_08, // J
    msg_hotel_scr_travel1_11, // JI
  },
  { // WEg
    msg_hotel_scr_travel2_01, // Dx 1
    msg_hotel_scr_travel2_02, // Dx 2
    msg_hotel_scr_travel2_06, // Dx 3
    -1,                       // J
    msg_hotel_scr_travel2_07, // J
    msg_hotel_scr_travel2_08, // JI
  },
  { // zEG
    msg_hotel_scr_travel3_01, // Dx 1
    msg_hotel_scr_travel3_02, // Dx 2
    msg_hotel_scr_travel3_06, // Dx 3
    -1,                       // J
    msg_hotel_scr_travel3_07, // J
    msg_hotel_scr_travel3_08, // JI
  },
  { // VIE
    msg_hotel_scr_travel4_01, // Dx 1
    msg_hotel_scr_travel4_02, // Dx 2
    msg_hotel_scr_travel4_06, // Dx 3
    msg_hotel_scr_travel4_07, // J
    msg_hotel_scr_travel4_08, // J
    msg_hotel_scr_travel4_11, // JI
  },
  { // CbV
    msg_hotel_scr_travel5_01, // Dx 1
    msg_hotel_scr_travel5_02, // Dx 2
    msg_hotel_scr_travel5_06, // Dx 3
    msg_hotel_scr_travel5_07, // J
    msg_hotel_scr_travel5_08, // J
    -1,                       // JI
  },
  { // ̑
    msg_hotel_scr_travel6_01, // Dx 1
    msg_hotel_scr_travel6_02, // Dx 2
    msg_hotel_scr_travel6_06, // Dx 3
    -1,                       // J
    msg_hotel_scr_travel6_07, // J
    msg_hotel_scr_travel6_08, // JI
  }
};

// {΂ɂ炦郊{
new ribbons_[kHotelWeekDays] =
{
  // see c:/home/xy_project/prog/include/poke_tool/poke_tool_Ribbon.h
  RIBBON_NO_SYAKKIRI,         ///<  8{
  RIBBON_NO_DOKKIRI,          ///<  9ǂ{
  RIBBON_NO_SYONBORI,         ///< 10ڃ{
  RIBBON_NO_UKKARI,           ///< 11{
  RIBBON_NO_SUKKIRI,          ///< 12{
  RIBBON_NO_GUSSURI,          ///< 13{
  RIBBON_NO_NIKKORI           ///< 14ɂ{
};


//--------------------------------------------------------------------------------
//  methods
//--------------------------------------------------------------------------------

//----------------------------------------
// bJn
//----------------------------------------
stock talkStart_()
{
  TalkMdlStart(/* WorkGet(SCWK_TARGET_OBJID) */);
}

//----------------------------------------
// bI
//----------------------------------------
stock talkEnd_()
{
  TalkMdlEnd(/* WorkGet(SCWK_TARGET_OBJID) */);
}

//----------------------------------------
// obt@w胁bZ[W\RA
//----------------------------------------
stock msgCore_(msg_id, win_type = WIN_TYPE_TALK_C)
{
  new objId = WorkGet(SCWK_TARGET_OBJID);

  if (msg_id < 0)
  {
    return false; // \̂Ȃꍇ͂̂܂ܖ߂
  }

  if (g_messageBuffer != NULL)
  {
    // obt@̃eLXg\
    if (win_type == WIN_TYPE_SYS)
    {
      SysMsgBuf(msg_id, SYS_WIN_POS_D, g_messageBuffer);
    }
    else
    {
      MdlMsgPosBuf(msg_id, objId, win_type, WIN_POS_C, WIN_POS_D, WIN_OPTION_NONE, g_messageBuffer);
    }
  }
  else
  {
    // WeLXg\
    if (win_type == WIN_TYPE_SYS)
    {
      SysMsg(msg_id, SYS_WIN_POS_D);
    }
    else
    {
      MdlMsgPos(msg_id, objId, win_type, WIN_POS_C, WIN_POS_D, WIN_OPTION_NONE);
    }
  }

  return true;
}

//----------------------------------------
/*
 *  @brief  ݓtւqݒ
 *  - ][Ă΂A[J[Nɕۑ
 */
//----------------------------------------
stock Hotel_getGuest(type, date)
{
  return (type + date) % kHotelTypeMax; // zeƓt猻݂̓ւqZo
}

//----------------------------------------
/*
 *  @brief  ݓt烊{̎ނݒ
 *  - ][Ă΂A[J[Nɕۑ
 */
//----------------------------------------
stock Hotel_getRibbon(date)
{
  return (date + kHotelWeekSat) % kHotelWeekDays; // yjn܂肩猎jn܂ɕϊjZo
}

//----------------------------------------
/*
 *  @brief  ւόqANZT
 */
//----------------------------------------

// ւόq̉bisx擾
stock Hotel_getGuestWork(area)
{
  return WorkGet(WK_SCENE_HOTEL_GUEST_01 + area);
}

// ւόq̉bisxݒ
stock Hotel_setGuestWork(area, value)
{
  WorkSet(WK_SCENE_HOTEL_GUEST_01 + area, value);
}

// ][̒n擾
stock Hotel_getGuestArea()
{
  return WorkGet(WORK_HOTEL_GUEST_STATUS_) & 0x00ff;
}

// ][̒nݒ
stock Hotel_setGuestArea(value)
{
  WorkSet(WORK_HOTEL_GUEST_STATUS_, (WorkGet(WORK_HOTEL_GUEST_STATUS_) & 0xff00) | value);
}

// ][̍Dx擾
stock Hotel_getGuestStep()
{
  return (WorkGet(WORK_HOTEL_GUEST_STATUS_) & 0x0f00) >> 8;
}

// ][̍Dxݒ
stock Hotel_setGuestStep(value)
{
  WorkSet(WORK_HOTEL_GUEST_STATUS_, (WorkGet(WORK_HOTEL_GUEST_STATUS_) & 0xf0ff) | (value << 8));
}

// DxAbvς݂H
stock Hotel_isGuestDone()
{
  return (WorkGet(WORK_HOTEL_GUEST_STATUS_) & 0x8000) ? true : false;
}

// DxAbv
stock Hotel_guestDone()
{
  WorkSet(WORK_HOTEL_GUEST_STATUS_, WorkGet(WORK_HOTEL_GUEST_STATUS_) | 0x8000);
}

//----------------------------------------
/*
 *  @brief  {΂ANZT
 */
//----------------------------------------

// ][̓t擾
stock Hotel_getMadamDate()
{
  return WorkGet(WORK_HOTEL_MADAM_DATE_);
}

// ][̓tݒ
stock Hotel_setMadamDate(value)
{
  WorkSet(WORK_HOTEL_MADAM_DATE_, value);
}

// ][̃{ނ擾
stock Hotel_getMadamRibbon()
{
  return WorkGet(WORK_HOTEL_MADAM_STATUS_) & 0x00ff;
}

// ][̃{ނݒ
stock Hotel_setMadamRibbon(value)
{
  WorkSet(WORK_HOTEL_MADAM_STATUS_, (WorkGet(WORK_HOTEL_MADAM_STATUS_) & 0xff00) | value);
}

// {H
stock Hotel_isMadamDone()
{
  return (WorkGet(WORK_HOTEL_MADAM_STATUS_) & 0x8000) ? true : false;
}

// {
stock Hotel_madamDone()
{
  WorkSet(WORK_HOTEL_MADAM_STATUS_, WorkGet(WORK_HOTEL_MADAM_STATUS_) | 0x8000);
}

// RvF肵H
stock Hotel_isMadamComp()
{
  return (WorkGet(WORK_HOTEL_MADAM_STATUS_) & 0x4000) ? true : false;
}

// RvF肷
stock Hotel_madamComp()
{
  WorkSet(WORK_HOTEL_MADAM_STATUS_, WorkGet(WORK_HOTEL_MADAM_STATUS_) | 0x4000);
}

//----------------------------------------
/*
 *  @brief  ze̋ʃ][
 *  @param  [in]  type ze
 */
//----------------------------------------
stock Hotel_init(type)
{
  new date    = GetDateTimeToDay();         // 2000N 1 1(y)̌oߓ
  new area    = Hotel_getGuest(type, date); // ւόq̎
  new ribbon  = Hotel_getRibbon(date);      // IW̃{
  new objCode = NONDRAW;
  new vanish  = true;

  // ւόq̐ݒ
  Hotel_setGuestArea(area);
  Hotel_setGuestStep(Hotel_getGuestWork(area));
  if (FlagGet(TMFLG_HOTEL_GUEST_01 + area) == true)
  {
    Hotel_guestDone(); // Dx㏸ς
  }

  // {΂̐ݒ
  Hotel_setMadamDate(date);
  Hotel_setMadamRibbon(ribbon);
  if (FlagGet(TMFLG_HOTEL_RIBBON_DONE) == true)
  {
    Hotel_guestDone(); // {擾ς
  }
  if (FlagGet(TMFLG_HOTEL_RIBBON_COMP) == true)
  {
    Hotel_madamComp(); // RvbZ[W\ς
  }

  // ognւq̊Oς
  switch (area)
  {
  case kHotelGuestAreaKanto   : { objCode = HEROINE; }
  case kHotelGuestAreaJohto   : { objCode = HERO;    }
  case kHotelGuestAreaHoenn   : { objCode = FRIEND1; }
  case kHotelGuestAreaShinnoh : { objCode = FRIEND2; }
  case kHotelGuestAreaUnova   : { objCode = FRIEND3; }
  case kHotelGuestAreaOther   : { objCode = HAKASE1; }
  }

  WorkSet(OBJCHRWORK0, objCode);

  // {΂񂪂邩H
  switch (ribbon)
  {
  case kHotelWeekMon : { vanish = (type == kHotelTypeT09R0402) ? false : true; }
  case kHotelWeekTue : { vanish = (type == kHotelTypeT03R0202) ? false : true; }
  case kHotelWeekWed : { vanish = (type == kHotelTypeT04R0102) ? false : true; }
  case kHotelWeekThu : { vanish = (type == kHotelTypeC05R0302) ? false : true; }
  case kHotelWeekFri : { vanish = (type == kHotelTypeT06R0102) ? false : true; }
  case kHotelWeekSat : { vanish = (type == kHotelTypeC03R0102) ? false : true; }
  case kHotelWeekSun : { vanish = (type == kHotelTypeC05R0302) ? false : true; }
  }

  if (vanish == true)
  {
    FlagSet(FV_HOTEL_RIBBON_01);   // ʂ̃zeɑ؍ݒ
  }
  else
  {
    FlagReset(FV_HOTEL_RIBBON_01); // 
  }
}

//----------------------------------------
/*
 *  @brief  ւόqƂ̉b
 */
//----------------------------------------
stock Hotel_talkGuest()
{
  new area = Hotel_getGuestArea();
  new step = Hotel_getGuestStep();
  new select;

  MsgLoad(true, SCRMSG_DATID_HOTEL);   // bZ[Wǂݍ݃NGXgo
  g_messageBuffer = MsgWaitLoad(true); // ߂lbZ[Wobt@ƂȂ
  Assert(g_messageBuffer != NULL);     // bZ[Wobt@̎擾Ɏsassert

  talkStart_();

  if ((step < 3) || (step >= 5))
  {
    // 3iKڂƍŏIiK̓bZ[W\̂
    msgCore_(messages_[area][step]);
    LastKeyWait();

    if (Hotel_isGuestDone() == false)
    {
      FlagSet(TMFLG_HOTEL_GUEST_01 + area);
      Hotel_guestDone(); // ][`FW܂ōDxςȂ悤ɂ

      if (step < 3)
      {
        Hotel_setGuestWork(area, step + 1);
      }
    }
    goto exit_;
  }

  if (step == 3)
  {
    // J̓bZ[WȂꍇ
    if (msgCore_(messages_[area][step]) == true)
    {
      ABKeyWaitMark(); // bZ[Wꍇ
    }

    step = 4;
    Hotel_setGuestWork(area, step);
    Hotel_setGuestStep(      step);
  }

  if      (area == kHotelGuestAreaKanto  )
  {
    // w|PƃRCLOƌ
    Hotel_setGuestWork(area, 5);
    Hotel_setGuestStep(      5);
  }
  else if (area == kHotelGuestAreaJohto  )
  {
    // ܂񂶂イ
    msgCore_(messages_[area][step]);
    ABKeyWaitMark();

    ItemEvent(ITEM_IKARIMANZYUU, 1);
    ABKeyWaitMark();

    step = 5;
    Hotel_setGuestWork(area, step);
    Hotel_setGuestStep(      step);

    msgCore_(messages_[area][step]);
    LastKeyWait();
  }
  else if (area == kHotelGuestAreaHoenn  )
  {
    // tGׂ
    msgCore_(messages_[area][step]);
    ABKeyWaitMark();

    ItemEvent(ITEM_HUENSENBEI, 1);
    ABKeyWaitMark();

    step = 5;
    Hotel_setGuestWork(area, step);
    Hotel_setGuestStep(      step);

    msgCore_(messages_[area][step]);
    LastKeyWait();
  }
  else if (area == kHotelGuestAreaShinnoh)
  {
    // w|PƖ|P
    Hotel_setGuestWork(area, 5);
    Hotel_setGuestStep(      5);
  }
  else if (area == kHotelGuestAreaUnova  )
  {
    /*
     *  W[_[̏
     *  ̊όqstep = 4ŌŒ肳
     */

    for (;;)
    {
      msgCore_(messages_[area][step]);

      ListMenuInit(MENU_X1, MENU_Y1, 0, true, false);

      ListMenuAdd(msg_hotel_scr_select_01, 1, g_messageBuffer); // rI
      ListMenuAdd(msg_hotel_scr_select_02, 2, g_messageBuffer); // Rj
      ListMenuAdd(msg_hotel_scr_select_03, 3, g_messageBuffer); // }[V
      ListMenuAdd(msg_hotel_scr_select_04, 4, g_messageBuffer); // SWJ
      ListMenuAdd(msg_hotel_scr_select_05, 0, g_messageBuffer); // ߂

      select = ListMenuStart();
      if (select == SCR_LISTMENU_CANCEL) // B{^LZw߂x̌ʂƓɐݒ
      {
        select = 0;
      }
    
      if (select == 0) // ߂ or LZ
      {
        msgCore_(msg_hotel_scr_travel5_13);
        LastKeyWait();
        break;
      }

      // g[i[̐
      msgCore_(msg_hotel_scr_travel5_09 + (select - 1));
      ABKeyWaitMark();
    }
  }
  else if (area == kHotelGuestAreaOther  )
  {
    // ACeƌ
    msgCore_(messages_[area][step]);
    ABKeyWaitMark();

    ItemEvent(ITEM_HUENSENBEI, 1);
    LastKeyWait();

    Hotel_setGuestWork(area, 5);
    Hotel_setGuestStep(      5);
  }

exit_:
  if (g_messageBuffer != NULL)
  {
    MsgRelease();
    g_messageBuffer = NULL;
  }

  MsgClose();

  talkEnd_();
}

//----------------------------------------
/*
 *  @brief  {Rv`FbN
 *  - 莝|P{Rv[gĂ邩H
 */
//----------------------------------------
stock Hotel_ribbonIsComplete()
{
  new count = PokePartyGetCount(POKE_COUNT_TYPE_ALL);
  new ribbon;
  new i;
  new j;

  /*
   *  |Pj̕[vƂĂ͒IA
   *  zANZX炵ĐoCgR[h̑x
   *  コeXĝߗj|P̏Ń`FbN
   */
  for (i = 0; i < kHotelWeekDays; ++i)
  {
    ribbon = ribbons_[i];
    for (j = 0; j < count; ++j)
    {
      if (PokePartyGetParam(j, SCRID_ribbon, ribbon) == false)
      {
        return false;
      }
    }
  }

  return true;
}

//----------------------------------------
/*
 *  @brief  {v[g
 */
//----------------------------------------
stock Hotel_ribbonPresent(ribbon)
{
  new count = PokePartyGetCount(POKE_COUNT_TYPE_ALL);
  new done  = false;
  new i;

  for (i = 0; i < count; ++i)
  {
    if (PokePartyGetParam(i, SCRID_ribbon, ribbon) == false) // ꉞ`FbN
    {
      PokePartySetParam(i, SCRID_ribbon, ribbon); // t^
      done = true;
    }
  }

  return done;
}

//----------------------------------------
/*
 *  @brief  {΂Ƃ̉b
 */
//----------------------------------------
stock Hotel_talkRibbon()
{
  new ribbon = Hotel_getMadamRibbon();
  new done   = Hotel_isMadamDone();
  new comp   = Hotel_isMadamComp();

  MsgLoad(true, SCRMSG_DATID_HOTEL);   // bZ[Wǂݍ݃NGXgo
  g_messageBuffer = MsgWaitLoad(true); // ߂lbZ[Wobt@ƂȂ
  Assert(g_messageBuffer != NULL);     // bZ[Wobt@̎擾Ɏsassert

  talkStart_();

  if (done == true)
  {
    // {Ă
    if (Hotel_ribbonIsComplete() == true)
    {
      comp = true;
    }

    if (comp == true)
    {
      // RvĂ
      goto comp_;
    }

    msgCore_(msg_hotel_scr_ribbon_01 + ribbon * 2 + 1);
    LastKeyWait();
  }
  else
  {
    // {ĂȂ
    if (Hotel_ribbonPresent(ribbons_[ribbon]) == false)
    {
      // 莝|PׂĖ{̃{擾ς
      if (Hotel_ribbonIsComplete() == true)
      {
        // 擪|PRvς
        comp = true;
      }

      if (comp == true)
      {
        goto comp_;
      }

      // Rv܂ł͂ĂȂ
      msgCore_(msg_hotel_scr_ribbon_01 + ribbon * 2 + 1);
      LastKeyWait();
    }
    else
    {
      // {擾
      done = true;

      msgCore_(msg_hotel_scr_ribbon_01 + ribbon * 2);
      if (Hotel_ribbonIsComplete() == true)
      {
        // 擪|P{Rv
        comp = true;

        ABKeyWaitMark();
        goto comp_;
      }
      LastKeyWait();
    }
  }
  goto exit_;

comp_:
  msgCore_(msg_hotel_scr_ribbon_15);
  LastKeyWait();
  goto exit_;

exit_:
  /*
   *  b̓^CtOZbgȂ̂
   *  ܂CɂĂĂ܂Ă܂Ȃ
   *
   *  Ȃ݂ɓ͈ȉ̒ʂ
   *  if (Hotel_getMadamDate() == GetDateTimeToDay()) {}
   */
  if (done == true)
  {
    FlagSet(TMFLG_HOTEL_RIBBON_DONE);
    Hotel_madamDone(); // Ń][`FW܂łԂɂȂ
  }
  if (comp == true)
  {
    FlagSet(TMFLG_HOTEL_RIBBON_COMP);
    Hotel_madamComp(); // Ń][`FW܂ŃRvԂɂȂ
  }

  if (g_messageBuffer != NULL)
  {
    MsgRelease();
    g_messageBuffer = NULL;
  }

  MsgClose();

  talkEnd_();
}

