//=============================================================================
/**
 * @brief ݒʏʂ̃p[^\
 * @file app_config_Params.h
 * @author takada_keisuke
 * @date 2012.10.01
 */
//=============================================================================
#ifndef __APP_CONFIG_PARAMS_H__
#define __APP_CONFIG_PARAMS_H__
#include <gflib.h>
#include <pmlib.h>
#include "print/xy_msgWin.h"
#include "app/util/app_util.h"
#include "app/util/app_util_G2dLayoutContainer.h"
#include "./app_config_IDrawer.h"
#include "app_config_GameData.h"



namespace app {
  namespace config {

    class Common;

    class Params :
    public IDrawer,
    public app::util::G2dLayoutContainer,
    public app::util::LytUtil {
      GFL_FORBID_COPY_AND_ASSIGN(Params);

    public:
      //-----------------------------------------------------------------------
      // {
      //-----------------------------------------------------------------------
      Params(Common* common);
      virtual ~Params();
      void Update(void);
      virtual void Draw(void);

      //-----------------------------------------------------------------------
      // p[^̕\
      //-----------------------------------------------------------------------
      void ChangeDispParameter(u8 plateIndex); // \ύX
      void StartParameterDisplay(void); // p[^\



    private:

      enum AnimationData {
        ANIME_DATA_NUM,
      };

      enum Animation {
        ANIME_NUM,
      };

      static const u32 APP_HEAPSIZE;
      static const u32 DEVICE_HEAPSIZE;
      static const gfl::grp::g2d::LytWkSetUp LAYOUT_WORK_SETUP_DATA;
      static const gfl::grp::ProjectionParam PROJECTION_PARAM[2];
      static const gfl::grp::ViewParam VIEW_PARAM[2];
      static const gfl::grp::FragmentOperationParam OPERATION_PARAM;
      static const gfl::grp::g2d::LytArcIndex ANIME_DATA_TABLE[ ANIME_DATA_NUM ];
      static const s8 DESCRIPTION_MESSAGE[ SETTINGS_NUM ];

      Common* mCommon; ///< ʃNX
      s8 mPreviousPlateIndexOnSettingCursor; ///< Ot[őIĂv[gԍ
      s8 mPreviousSelectOptions; ///< Ot[őIꂢݒ荀
      print::MsgWin* mMsgWin; ///< bZ[WEBhE

      void SetupStaticStrings(void);
      void SetupParam(u8 plateIndex);

      void UpdateParameter(void); // XV

      void CreateMessageWindow(void);
      void DeleteMessageWindow(void);
      gfl::str::StrWin::Result PrintMessage(void);
    };


  } // namespace config 
} // namespace app


#endif  // __APP_CONFIG_PARAMS_H__
