//=============================================================================
/**
 * @brief ݒʏʂ̃p[^\
 * @file app_config_Params.h
 * @author takada_keisuke
 * @date 2012.10.01
 */
//=============================================================================
#include <gflib.h>
#include <pmlib.h>
#include "system/main.h"
#include "app/util/app_util.h"
#include "app/util/app_util_G2dLayoutContainer.h"
#include "./app_config_IDrawer.h"
#include "./app_config_Params.h"
#include "app_config_Common.h"

#include <arc/arc_def.h>
#include <arc/config.gaix>
#include <message/msg_option.h>
#include "layout_upper.h"
#include "layout_upper_pane.h"

#include "common_res/msg_window_res.h"

namespace app
{
  namespace config
  {


    // q[vTCY
    const u32 Params::APP_HEAPSIZE = 0x1000;
    const u32 Params::DEVICE_HEAPSIZE = 0x100000;



    const gfl::grp::g2d::LytWkSetUp Params::LAYOUT_WORK_SETUP_DATA = {
      gfl::math::VEC3( 0, 0, 0 ), // pos
      gfl::math::VEC2( 1, 1 ), // scale
      gfl::math::VEC3( 0, 0, 0 ), // rotate
      1, // priority
    };


    const gfl::grp::ProjectionParam Params::PROJECTION_PARAM[2] = {
      // 
      {
        gfl::grp::PROJECTION_ORTHO,
        { -200.0f, 200.0f, -120.0f, 120.0f},
        0.10f,
        300.0f,
        gfl::math::PIVOT_UPSIDE_TO_TOP,
      },
      // 
      {
        gfl::grp::PROJECTION_ORTHO,
        { -160.0f, 160.0f, -120.0f, 120.0f},
        0.10f,
        300.0f,
        gfl::math::PIVOT_UPSIDE_TO_TOP,
      },
    };


    const gfl::grp::ViewParam Params::VIEW_PARAM[2] = {
      // 
      {
        gfl::math::VEC3( 0, 0, 100 ), // JW
        gfl::math::VEC3( 0, 1, 0 ), // 
        gfl::math::VEC3( 0, 0, 0 ), // ^[QbgW
      },
      // 
      {
        gfl::math::VEC3( 0, -290, 100 ), // JW
        gfl::math::VEC3( 0, 1, 0 ), // 
        gfl::math::VEC3( 0, -290, 0 ), // ^[QbgW
      },
    };


    const gfl::grp::FragmentOperationParam Params::OPERATION_PARAM = {
      gfl::grp::CULL_NONE, // JO[hiENV_CULL`j
      false, // VU[eXgitrue/falsej
      {0}, //
      false, // A[[fvXeXg(true/false)
      false, // XeVeXg(true/false)
      {0}, // 
      0.0f, // Wobt@ݒi0.0fŖj
      0.0f, // fvXW Near
      1.0f, // fvXW Far
      0, // fvXl ŏlɑ΂XP[l
      false, // fvXeXg(true/false)
      gfl::grp::TEST_FUNC_LEQUAL, // fvXeXgr֐(ENV_TEST_FUNC_`)
      false, // fvXobt@ւ݂̏\(true/false)
      true, // J[obt@֐Ԃނitrue/falsej
      true, // J[obt@֐Ԃނitrue/falsej
      true, // J[obt@֐Ԃނitrue/falsej
      true, // J[obt@֐Ԃނitrue/falsej
      true, // J[obt@̓ǂݍ݂\itrue/falsej
      true, // J[obt@݂̏\itrue/falsej
      false, // fvXobt@̓ǂݍ݂\itrue/falsej
      false, // fvXobt@݂̏\itrue/falsej
      false, // XeVobt@̓ǂݍ݂\itrue/falsej
      false, // XeVobt@݂̏\itrue/falsej
    };


    // Aj[Vf[^e[u
    const gfl::grp::g2d::LytArcIndex Params::ANIME_DATA_TABLE[ Params::ANIME_DATA_NUM ] = {
    };

    // bZ[W
    const s8 Params::DESCRIPTION_MESSAGE[SETTINGS_NUM] = {
      msg_option_01_info, msg_option_02_info, msg_option_03_info,
      msg_option_04_info, msg_option_05_info, msg_option_06_info,
      msg_option_07_info, msg_option_08_info
    };

    /**
     * @brief RXgN^
     * @param system_heap   `ɎgpVXeq[v
     * @param device_heap   `ɎgpfoCXq[v
     */
    Params::Params( Common* common ) :
    IDrawer( ),
    G2dLayoutContainer( ),
    app::util::LytUtil( ),
    mCommon( common ),
    mPreviousPlateIndexOnSettingCursor( -1 ),
    mPreviousSelectOptions( -1 )
    {
      gfl::heap::HeapBase* systemHeap = common->GetAppHeap( )->pHeap;
      gfl::heap::HeapBase* deviceHeap = common->GetAppHeap( )->pDevHeap;
      gfl::grp::g2d::LytSys* layoutSystem = common->GetLayoutSystem( );

      this->InitLytUtil( systemHeap );

      static const u32 ADD_TEX_NUM = LYTRES_MSG_WINDOW_RES_END;

      static const app::util::G2DUtil::LYT_RES_DATA LYTRES_TABLE[] = {
        { ARCID_CONFIG, GARC_config_layout_upper_LYTDAT_LZ, ADD_TEX_NUM, app::util::G2DUtil::ATTACH_ROOT},
        { ARCID_COMMON_MSGWINDOW, 0, 0, app::util::G2DUtil::ATTACH_RESOURCE},
      };
      static const app::util::G2DUtil::LYTWK_DATA LYTWK_DATA_TABLE[] = {
        {
          0,
          LYTRES_LAYOUT_UPPER_CONFIG_UPPER_BCLYT,
          ANIME_DATA_TABLE,
          ANIME_DATA_NUM,
          ANIME_NUM,
          false,
          app::util::G2DUtil::SETUP_UPPER,
          true,
        }
      };

      this->SetupLayout(
                         systemHeap,
                         deviceHeap,
                         layoutSystem,
                         GFL_NELEMS( LYTWK_DATA_TABLE ),
                         LYTRES_TABLE,
                         GFL_NELEMS( LYTRES_TABLE ),
                         LYTWK_DATA_TABLE,
                         GFL_NELEMS( LYTWK_DATA_TABLE ),
                         NULL,
                         0 );

      gfl::grp::g2d::LytWk* layout_work = this->GetLayoutWork( );
      layout_work->SetAutoDrawFlag( false );

      // ÓIZbg
      this->SetupStaticStrings( );

      // bZ[WEChE𐶐
      this->CreateMessageWindow( );
    }

    /**
     * @brief bZ[WEChE쐬 
     */
    void Params::CreateMessageWindow( void )
    {
      mMsgWin = GFL_NEW( mCommon->GetAppHeap( )->pHeap ) print::MsgWin(
                                                                        mCommon->GetUiDeviceManager( ),
                                                                        this->GetLayoutWork( ),
                                                                        2,
                                                                        0,
                                                                        mCommon->GetAppHeap( )->pHeap );
      mMsgWin->AddLinePaneIdx( PANENAME_CONFIG_UPPER_PANE_TEXTBOX_00 );
      mMsgWin->AddLinePaneIdx( PANENAME_CONFIG_UPPER_PANE_TEXTBOX_01 );
    }

    /**
     * @brief ÓIZbg
     */
    void Params::SetupStaticStrings( void )
    {
      gfl::str::MsgData* message = mCommon->GetCommonMessage( );
      gfl::grp::g2d::LytWk* layoutWork = this->GetLayoutWork( );
      //this->SetTextboxPaneMessage( layoutWork, PANENAME_, message, PARAM_ );
    }

    /**
     * @brief fXgN^
     */
    Params::~Params( )
    {
      this->DeleteMessageWindow( );
      this->CleanupLayout( );
      this->FinalizeLytUtil( );
    }

    /**
     * @brief bZ[WEChEj 
     */
    void Params::DeleteMessageWindow( void )
    {
      if ( mMsgWin != NULL )
      {
        GFL_DELETE mMsgWin;
        mMsgWin = NULL;
      }
    }

    /**
     * @brief \p[^ύX
     * @param poke  p[^\|P
     */
    void Params::ChangeDispParameter( u8 plateIndex )
    {
      this->SetupParam( plateIndex );
    }

    /**
     * @brief p[^\ZbgAbv
     * @param poke  \p[^
     */
    void Params::SetupParam( u8 plateIndex )
    {
      gfl::grp::g2d::LytWk* layoutWork = this->GetLayoutWork( );

      if ( plateIndex < SETTINGS_NUM )
      {
        this->SetPaneVisible( layoutWork, PANENAME_CONFIG_UPPER_PANE_DESCRIPTION_ROOT );

        gfl::str::MsgData* message = mCommon->GetCommonMessage( );

        if ( plateIndex == SETTINGS_TALKING_SPEED )
        {
          this->SetPaneVisible( layoutWork, PANENAME_CONFIG_UPPER_PANE_TEXTBOX_01 );

          gfl::str::StrBuf* tempbuf = this->GetTempStrBuf( );
          message->GetString( DESCRIPTION_MESSAGE[ plateIndex ], *tempbuf );
          //WordSet * wordSet = mCommon->GetCommonWordSet( );
          //wordSet->Expand( tempbuf, tempbuf );
          mMsgWin->SetString( *tempbuf );
          savedata::Config::MSG_SPEED msgSpeed = static_cast < savedata::Config::MSG_SPEED >( mCommon->GetConfigData( )->currentSelectOptions[plateIndex] );
          mMsgWin->SetMessageSpeed( msgSpeed );
        }
        else
        {
          this->SetPaneInvisible( layoutWork, PANENAME_CONFIG_UPPER_PANE_TEXTBOX_01 );

          // bZ[Wf[^擾&Zbg
          this->SetTextboxPaneMessage( layoutWork, PANENAME_CONFIG_UPPER_PANE_TEXTBOX_00, message, DESCRIPTION_MESSAGE[ plateIndex ] );
        }
      }
      else
      {
        this->SetPaneInvisible( layoutWork, PANENAME_CONFIG_UPPER_PANE_DESCRIPTION_ROOT );
      }
    }

    /**
     * @brief p[^\
     */
    void Params::StartParameterDisplay( void )
    {
    }

    /**
     * @brief XV
     */
    void Params::Update( void )
    {
      this->UpdateParameter( );
      gfl::str::StrWin::Result result = this->PrintMessage( );

      gfl::grp::g2d::LytWk * layoutWork = this->GetLayoutWork( );
      layoutWork->Update( );
    }

    /**
     * @brief p[^[XV 
     */
    void Params::UpdateParameter( void )
    {
      u8 currentSelectSetting = mCommon->GetConfigData( )->currentSelectSetting;
      u8 currentSelectOptions = mCommon->GetConfigData( )->currentSelectOptions[ currentSelectSetting ];

      if ( currentSelectSetting != mPreviousPlateIndexOnSettingCursor ||
           currentSelectOptions != mPreviousSelectOptions )
      {
        this->ChangeDispParameter( currentSelectSetting );
      }

      mPreviousPlateIndexOnSettingCursor = currentSelectSetting;
      mPreviousSelectOptions = currentSelectOptions;
    }

    /**
     * @brief `揈
     */
    void Params::Draw( void )
    {
      gfl::grp::GraphicsSystem* graphicsSystem = mCommon->GetGraphicsSystem( );
      gfl::grp::RenderTarget* upperBuffer = graphicsSystem->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER );
      gfl::grp::RenderTarget* rightBuffer = graphicsSystem->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER_RIGHT );
      gfl::grp::g2d::LytWk* layoutWork = this->GetLayoutWork( );
      layoutWork->Draw( graphicsSystem, gfl::grp::DISPLAY_UPPER, upperBuffer, rightBuffer );
    }

    /**
     * @brief bZ[W` 
     * @return 
     */
    gfl::str::StrWin::Result Params::PrintMessage( void )
    {
      gfl::str::StrWin::Result result = mMsgWin->Proc( );

#if 0
      if ( mMsgCursor != NULL )
      {
        if ( mMsgCursor->Start( ) == false )
        {
          if ( result == gfl::str::StrWin::RES_PAUSE )
          {
            mMsgCursor->SetVisible( true );
          }
          else
          {
            mMsgCursor->SetVisible( false );
          }
        }
      }
#endif

      return result;
    }

  } // namespace config 
} // namespace app
