
#ifndef __SEQUENCE_UTIL_H__
#define __SEQUENCE_UTIL_H__

#include <gflib.h>

GFL_NAMESPACE_BEGIN(xy_system)
GFL_NAMESPACE_BEGIN(sequence)

namespace Util{
  void H3dLoadAndSetup(
    gfl::grp::g3d::H3dResource* resource,
    gfl::heap::NwAllocator* allocator,
    gfl::heap::NwAllocator* device_allocator,
    gfl::fs::ArcFile::ARCID arcID,
    gfl::fs::ArcFile::ARCDATID datID,
    u32 common_resource_flag
  );
  
  void H3dLoadAndSetup(
    gfl::grp::g3d::H3dResource* resource,
    gfl::heap::NwAllocator* allocator,
    gfl::heap::NwAllocator* device_allocator,
    gfl::fs::ArcFile::ARCID arcID,
    gfl::fs::ArcFile::ARCDATID datID,
    gfl::grp::g3d::H3dResource* shader,
    u32 common_resource_flag
  );
  
  class H3dLoader
  {
  public:
    void StartLoad(
      gfl::grp::g3d::H3dResource* resource,
      gfl::heap::NwAllocator* allocator,
      gfl::heap::NwAllocator* device_allocator,
      gfl::fs::ArcFile::ARCID arcID,
      gfl::fs::ArcFile::ARCDATID datID,
      u32 common_resource_flag
    );
    void StartLoad(
      gfl::grp::g3d::H3dResource* resource,
      gfl::heap::NwAllocator* allocator,
      gfl::heap::NwAllocator* device_allocator,
      gfl::fs::ArcFile::ARCID arcID,
      gfl::fs::ArcFile::ARCDATID datID,
      gfl::grp::g3d::H3dResource* shader,
      u32 common_resource_flag
    );
    
    bool IsReady();
    void AfterLoad();
    
    void Delete();
    
  private:
    gfl::grp::g3d::H3dResource* m_resource;
    gfl::heap::NwAllocator* m_allocator;
    gfl::heap::NwAllocator* m_device_allocator;
    gfl::grp::g3d::H3dResource* m_shader;
    u32 m_common_resource_flag;
    
    
    gfl::fs::ArcFile* m_arc;
    void* buffer;
  };
  
};

GFL_NAMESPACE_END(sequence)
GFL_NAMESPACE_END(xy_system)

#endif //__SEQUENCE_UTIL_H__
