
#include "Util.h"

#include "system/thread_priority.h"

GFL_NAMESPACE_BEGIN(xy_system)
GFL_NAMESPACE_BEGIN(sequence)

namespace Util{
  void H3dLoadAndSetup(
    gfl::grp::g3d::H3dResource* resource,
    gfl::heap::NwAllocator* allocator,
    gfl::heap::NwAllocator* device_allocator,
    gfl::fs::ArcFile::ARCID arcID,
    gfl::fs::ArcFile::ARCDATID datID,
    u32 common_resource_flag
  )
  {
    // ARCǂݍ
    u32 init_flag = gfl::fs::ArcFile::OPEN;
#if PM_DEBUG && GFL_HIO_ENABLE
    if(1)
    {
      const wchar_t* filename = gfl::fs::ArcFile::GetHioFileName(s_arc);
      if( gfl::fs::FileSystem::CheckHioFileExist( filename ) )
      {
        init_flag = gfl::fs::ArcFile::HIO | gfl::fs::ArcFile::OPEN;
      }
    }
#endif
    gfl::fs::ArcFile* arc = GFL_NEW(allocator->GetHeapBase()) gfl::fs::ArcFile(allocator->GetHeapBase(), arcID, init_flag);
    
    // ARCΏۂ̃\[Xt@Cǂݍ
    u32 size = arc->GetDataSize(datID);
    void* buffer = GflHeapAllocMemoryAlign(device_allocator->GetHeapBase(), size, 128);
    arc->LoadData(datID, buffer);
    
    // A^b`ZbgAbv
    resource->AttachBuffer(buffer);
    resource->Setup(allocator, device_allocator, NULL, common_resource_flag);
    
    // @todo AJbuffer̊JGflHeapFreeMemorysKv邩
    
    GFL_DELETE arc;
  }
  
  void H3dLoadAndSetup(
    gfl::grp::g3d::H3dResource* resource,
    gfl::heap::NwAllocator* allocator,
    gfl::heap::NwAllocator* device_allocator,
    gfl::fs::ArcFile::ARCID arcID,
    gfl::fs::ArcFile::ARCDATID datID,
    gfl::grp::g3d::H3dResource* shader,
    u32 common_resource_flag
  )
  {
    // ARCǂݍ
    u32 init_flag = gfl::fs::ArcFile::OPEN;
#if PM_DEBUG && GFL_HIO_ENABLE
    if(1)
    {
      const wchar_t* filename = gfl::fs::ArcFile::GetHioFileName(ARCID_DEMO_DATA);
      if( gfl::fs::FileSystem::CheckHioFileExist( filename ) )
      {
        init_flag = gfl::fs::ArcFile::HIO | gfl::fs::ArcFile::OPEN;
      }
    }
#endif
    gfl::fs::ArcFile* arc = GFL_NEW(allocator->GetHeapBase()) gfl::fs::ArcFile(allocator->GetHeapBase(), arcID, init_flag);
    
    // ARCΏۂ̃\[Xt@Cǂݍ
    u32 size = arc->GetDataSize(datID);
    void* buffer = GflHeapAllocMemoryAlign(device_allocator->GetHeapBase(), size, 128);
    arc->LoadData(datID, buffer);
    
    // A^b`ZbgAbv
    resource->AttachBuffer(buffer);
    resource->Setup(allocator, device_allocator, shader, common_resource_flag);
    
    // @todo AJbuffer̊JGflHeapFreeMemorysKv邩
    
    GFL_DELETE arc;
  }
  
  
  void H3dLoader::StartLoad(
    gfl::grp::g3d::H3dResource* resource,
    gfl::heap::NwAllocator* allocator,
    gfl::heap::NwAllocator* device_allocator,
    gfl::fs::ArcFile::ARCID arcID,
    gfl::fs::ArcFile::ARCDATID datID,
    u32 common_resource_flag
  )
  {
    this->StartLoad(resource, allocator, device_allocator, arcID, datID, NULL, common_resource_flag);
  }
    
  void H3dLoader::StartLoad(
    gfl::grp::g3d::H3dResource* resource,
    gfl::heap::NwAllocator* allocator,
    gfl::heap::NwAllocator* device_allocator,
    gfl::fs::ArcFile::ARCID arcID,
    gfl::fs::ArcFile::ARCDATID datID,
    gfl::grp::g3d::H3dResource* shader,
    u32 common_resource_flag
  )
  {
    m_resource = resource;
    m_allocator = allocator;
    m_device_allocator = device_allocator;
    m_common_resource_flag = common_resource_flag;
    m_shader = shader;
    
    // ARCǂݍ
    u32 init_flag = gfl::fs::ArcFile::OPEN;
    /*
#if PM_DEBUG && GFL_HIO_ENABLE
    if(1)
    {
      const wchar_t* filename = gfl::fs::ArcFile::GetHioFileName(s_arc);
      if( gfl::fs::FileSystem::CheckHioFileExist( filename ) )
      {
        init_flag = gfl::fs::ArcFile::HIO | gfl::fs::ArcFile::OPEN;
      }
    }
#endif
    */
    m_arc= GFL_NEW(allocator->GetHeapBase()) gfl::fs::ArcFile(allocator->GetHeapBase(), arcID, init_flag);
    m_arc->SetupForFastMode(allocator->GetHeapBase());
    
    // ARCΏۂ̃\[Xt@Cǂݍ
    u32 size = m_arc->GetDataSize(datID);
    buffer = GflHeapAllocMemoryAlign(device_allocator->GetHeapBase(), size, 128);
    //m_arc->LoadData(datID, buffer);
    bool ret = m_arc->StartAsyncRead(gfl::heap::Manager::GetHeapByHeapId(HEAPID_FILEREAD), datID, buffer, MAIN_THREAD_PRIORITY +1 );
    GFL_PRINT("start async read:%d\n", ret);
  }
  
  bool H3dLoader::IsReady()
  {
    return (m_arc == NULL || !m_arc->WaitAsyncRead());
  }
    
  void H3dLoader::AfterLoad()
  {
    // A^b`ZbgAbv
    m_resource->AttachBuffer(buffer);
    
    m_resource->Setup(m_allocator, m_device_allocator, m_shader, m_common_resource_flag);
    
    GFL_DELETE m_arc;
    m_arc = NULL;
    
    
    // @todo buffergflheapFreememory͕KvH
  }
  
  void H3dLoader::Delete()
  {
    GflHeapFreeMemory(buffer);
    GFL_PRINT("sequence::util::Jꂽ\n");
  }
};

GFL_NAMESPACE_END(sequence)
GFL_NAMESPACE_END(xy_system)
