#! ruby -Ks
#[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
#
#
#	@file		scenery_conveter.rb
#	@brief  ꏊ̕iRo[^
#	@author	Toru=Nagihashi
#	@date		2012.10.04
#
#
#]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
require "conv_tool.rb"
require "../../tools/headerdata.rb"

#-------------------------------------
# 
#=====================================
CSVNAME       = ARGV[0]
MSTXTNAME     = ARGV[1]
OUTPUTNAME    = ARGV[2]

#=============================================================================
#
#   W[
#
#=============================================================================
#-------------------------------------
# BodyRo[g
#=====================================

ROW_START        = 1     #s:Jnʒu
COL_ID           = 1     #:ID
COL_CODE         = 2     #:R[h
COL_MSG          = 3     #:bZ[W

def convert( csv, cdat, txt, header )
 
  cdat.write( "static const struct {\n" )
  cdat.write( "  u32 msg;\n" )
  cdat.write( "} zone_scenery[]  = {\n" )

  header.write( "enum ZoneScenery {\n" )

  cnt = 0
  for row in ROW_START...csv.row_length-1
    
    id         = csv.get( row, COL_ID   )
    code       = csv.get( row, COL_CODE )
    msg        = csv.get( row, COL_MSG  )

    
    if id.to_i != cnt
      puts "#{id.to_i}͘AԂłOX^[głȂ΂Ȃ܂B"
      exit(1)
    end
    cnt += 1

    header.write( "  ZONE_SCENERY_#{code.to_s},\n" )
    
    cdat.write( "  {//ZONE_SCENERY_#{code.to_s} \n" )
    
    begin
      msg_no = txt.search( msg.to_s, "" )
      cdat.write( "    #{msg_no.to_i},\n" )
    rescue HeaderSearchError
      puts "bZ[W݂܂ #{msg}\n"
      exit(1)
    end
 
    cdat.write( "  },\n" )
  end
  
  header.write( "  ZONE_SCENERY_MAX,\n" )
  header.write( "};\n" )
  cdat.write( "};\n" )
  
end

#=============================================================================
#
#   C
#
#=============================================================================
begin

  #csvǍ
  csv = CsvLoader.new
  csv.setPrefix( '#start' )
  csv.setSuffix( '#end' )
  csv.load( CSVNAME )
  
  #eLXgf[^̍쐬
  txt = HeaderDataArray.new
  txt.load( MSTXTNAME )

  #cdat쐬
  cdat    = TextBuilder.new
  cdat.write_header( "#{OUTPUTNAME}.cdat", 
                    "][̕if[^łB",
                    "Toru=Nagihashi" ) 
  
  #wb_쐬
  header    = TextBuilder.new
  header.write_header( "#{OUTPUTNAME}.h", 
                    "][̕ĩwb_[ł",
                    "Toru=Nagihashi" ) 

  #Ro[g
  convert( csv, cdat, txt, header )

  #wb_
  header.genelate( "#{OUTPUTNAME}.h" )

  #cdat
  cdat.genelate( "#{OUTPUTNAME}.cdat" )

end
