//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		townmap_MapView.cpp
 *	@brief
 *	@author	Toru=Nagihashi
 *	@date		2012.10.01
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "townmap_MapView.h"

namespace app {
namespace townmap {

//-----------------------------------------------------------------------
// Ej
//-----------------------------------------------------------------------
/**
 * @brief RXgN^
 *
 * @param heap  q[v
 * @param graphics_system OtBbNXVXe
 * @param layout_system CAEgVXe
 * @param game_manager  Q[}l[W[
 */
MapView::MapView(app::util::Heap * heap, gfl::grp::GraphicsSystem *graphics_system, gfl::grp::g2d::LytSys* layout_system, TownmapData *townDat, const Description & desc ) :
  app::ui::UIView( heap ),
  m_heap( heap ),
  m_townDat(townDat),
  m_mapPos(0,0,0),
  m_heroPos(0,0,0),
  m_cursorPos(0,0,0),
  m_scroll(0,0,0),
  m_scale(1.0f),
  m_scaleTarget( 1.0f ),
  m_isEnableScroll( true ),
  m_isDraw( false ),
  m_scaleChangeCounter( 0 ),
  m_currentPlace( UNKNOWN_PAIN ),
  m_desc( desc )
{
  m_graphicSystem = graphics_system;

  this->CreateLayout( m_heap, layout_system );
  this->SetInputListener( this );
}
/**
 * @brief fXgN^
 */
MapView::~MapView()
{
  this->DeleteLayout();
}

//-----------------------------------------------------------------------
// VXe
//-----------------------------------------------------------------------
/**
 * @brief XV
 */
void MapView::Update(void)
{
  m_scale = TownmapUtil::DoConvergenceFloat( m_scale, m_scaleTarget, 0.1f );

  this->app::ui::UIView::Update();
  
  // XXV
  if( m_isDraw )
  {
    AdsorbCursorWithPane();
  }

  if( m_scaleChangeCounter > 0 )
  {
    SetCursorPosWithScale( GetScale() );
    m_scaleChangeCounter--;
  }

  // XN[lXV̈
  MoveCursor(0.0f, 0.0f, false);

  // {֐͍ŌɎsĂI
  UpdatePane();

}
/**
 * @brief `
 */
void MapView::Draw(void)
{
  m_g2dUtil->Draw2D( m_graphicSystem, 0 );
  m_isDraw  = true;
}
/**
 * @brief Xi[Zbg
 *
 * @param listener  Xi[
 */
void MapView::SetListener( MapViewListener *listener )
{
  m_townUIListener  = listener;
}

//-----------------------------------------------------------------------
// 
//-----------------------------------------------------------------------
 /**
  * @brief   lACȐʒuyCgpĐݒ肷
  *
  * @param   paneId ʒuɎgpyChc
  *
  * @return  none
  */
void MapView::SetHeroPositionWithPane( u32 paneId )
{
  // J[\ʒuElʒu
  gfl::math::VEC3 pos = m_g2dUtil->GetPanePos( 0, paneId );
  SetPanePos( 0, PANENAME_TOWNMAP_LOWER_PANE_HERO_OBJ, &pos );
  SetPanePos( 0, PANENAME_TOWNMAP_LOWER_PANE_CURSOL_NULL, &pos );
  
  m_g2dUtil->SetPaneVisible( 0, PANENAME_TOWNMAP_LOWER_PANE_HERO_OBJ, true );

  gfl::math::VEC3 heroPos = GetPlayerIconPanePos();
  SetHeroPos( heroPos );   // lW̎擾
  SetCursorPos( heroPos ); // J[\W̎擾

  m_currentPlace = paneId;
}

//-----------------------------------------------------------------------
// app::ui::UIInputListener
//-----------------------------------------------------------------------
/**
* @brief  L[͂̌m
*         ^b`pl̓͂D悳
*
* @param  pKey    \L[
* @param  pStick  AiOXeBbN
*
* @return t[ł̑̓CxgȂtrueA
*         ̃CxgrȂfalseԋp邱ƁB
*/
// @override
bool MapView::OnKeyAction( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick)
{
  // gk͑s
  if( m_scaleChangeCounter == 0 ){
    ControlCursor( pKey, pStick );
  }

  if( pKey->IsTrigger( gfl::ui::BUTTON_A ) )
  {
    DecideRoutePoint();
    return false;
  }
  return true;
}
/**
* @brief  ^b`plCxǧm
*
* @param  pTouchPanel ^b`pl
* @param  isTouch     ^b`ԂłȂtrueA^b`ĂȂȂfalse
*                     (^b`gK𒲂ׂꍇTouchPanel::IsTouchTrigger()ɂĔf\j
*
* @return t[ł̑̓CxgȂtrueA
*         ̃CxgrȂfalseԋp邱ƁB
*/
// @override
bool MapView::OnTouchEvent( gfl::ui::TouchPanel* pTouchPanel, bool isTouch )
{
  // ^b`Ă
  if( isTouch )
  {
    const nw::lyt::Size barSize  = GetMenuBarPaneSize();
    s16                 displayX = pTouchPanel->GetX();
    s16                 displayY = pTouchPanel->GetY();

    // j[o[GA̓^b`ΏۊO
    if( displayY >= (DISPLAY_LOWER_HEIGHT-barSize.height) ){
      return true;
    }

    // ߂ă^b`I
    if( pTouchPanel->IsTouchTrigger() )
    {
      // ʍW烌CAEgWɕϊAJ[\ݒ
      gfl::math::VEC3 cursorPos( (displayX-(DISPLAY_LOWER_WIDTH/2)), ((DISPLAY_LOWER_HEIGHT/2)-displayY), 0.0f );
      SetCursorPos( cursorPos );

      if( !DecideRoutePoint() )
      {
        // [gOA_uNbN͊gk
        if( pTouchPanel->IsDoubleClick() )
        {
          ChangeScale();
        }
      }
    }
    // hbOH
    else
    {
      MoveCursor( pTouchPanel->GetMoveX(), -pTouchPanel->GetMoveY(), true );
    }
    return false;
  }
  return true;
}


//-----------------------------------------------------------------------
// PRIVATE  
//-----------------------------------------------------------------------
/**
 * @brief CAEg쐬
 *
 * @param heap  q[v
 * @param layout_system CAEgVXe
 */
void MapView::CreateLayout( app::util::Heap * heap,gfl::grp::g2d::LytSys* layout_system )
{
  static const app::util::G2DUtil::LYT_RES_DATA ResTbl[] = {
    { ARCID_TOWNMAP_LYT_GRA, 0, LYTRES_MSG_WINDOW_RES_END, app::util::G2DUtil::ATTACH_ROOT },
  };

  // Ajf[^iʁj
  static const gfl::grp::g2d::LytArcIndex LowerAnmIndex[] =
  {
    LYTRES_RES_TOWNMAP_LAYOUT_TOWNMAP_LOWER_CURSOL_BCLAN,
    LYTRES_RES_TOWNMAP_LAYOUT_TOWNMAP_LOWER_HERO_ANIME_BCLAN,
  };

  // CAEgf[^
  static const app::util::G2DUtil::LYTWK_DATA layoutData[] =
  {
    { // 
      RES_DATA_INDEX_MAIN,
      LYTRES_RES_TOWNMAP_LAYOUT_TOWNMAP_LOWER_BCLYT,
      LowerAnmIndex,
      GFL_NELEMS(LowerAnmIndex),
      GFL_NELEMS(LowerAnmIndex),
      true,
      app::util::G2DUtil::SETUP_LOWER,
      true,
    },
  };

  this->Create2D( heap, layout_system, 1,
                  ResTbl, GFL_NELEMS(ResTbl),
                  layoutData, GFL_NELEMS(layoutData),
                  GARC_message_townmap_DAT );

  m_g2dUtil->StartAnime( 0, ANMID_CURSOR );
  m_g2dUtil->StartAnime( 0, ANMID_HERO   );
  m_g2dUtil->SetPaneVisible( 0, PANENAME_TOWNMAP_LOWER_PANE_HERO_OBJ, false );
  
  gfl::math::VEC3 pos( 0,0,0 );
  SetPanePos( 0, PANENAME_TOWNMAP_LOWER_PANE_CURSOL_NULL, &pos );
  
  SetPanePos( 0, PANENAME_TOWNMAP_LOWER_PANE_CURSOL_NULL, &pos );
  SetCursorPos( pos ); // J[\W̎擾

  // MAPW̎擾
  gfl::math::VEC3 mapPos = GetMapPanePos();
  SetMapPos( mapPos );
}
/**
 * @brief CAEgj
 */
void MapView::DeleteLayout( void )
{
  this->Delete2D();
}

//-----------------------------------------------------------------------
// PRIVATE  
//-----------------------------------------------------------------------
// }bvJ[\ړ
void MapView::MoveCursor( float moveX, float moveY, bool isScroll )
{
  const float           scaleRate  = GetScale();
  const gfl::math::VEC3 mapPos     = GetMapPos();
  gfl::math::VEC3       cursorPos  = GetCursorPos();
  gfl::math::VEC3       scroll     = GetScroll();

  // J[\ʒuEXN[lvZ
  CalculateScreen( isScroll, moveX, moveY, scaleRate, mapPos, cursorPos, scroll );

  // J[\ʒuR~bg
  SetCursorPos( cursorPos );

  // XN[lR~bg
  SetScroll( scroll );
}


// XP[ύXɂJ[\XN[l̕ύX
void MapView::SetCursorPosWithScale( float scale )
{
  float           targetScale  = GetScaleTarget();
  gfl::math::VEC3 targetPos    = m_cursorPosOrigin;
  gfl::math::VEC3 mapPos       = GetMapPos();

  TownmapUtil::AdjustVEC3WithScale( &targetPos, scale );

  // SW̕␳
  targetPos.x -= (mapPos.x * (scale-1.0f));
  targetPos.y -= (mapPos.y * (scale-1.0f));

  if( targetScale == 2.0f )
  {
    // ȑÕJ[\ʒuƓlɂȂ悤AXN[ʒuZo
    gfl::math::VEC3 targetScroll(0.0f, 0.0f, 0.0f);
    targetScroll.x = m_cursorDispBackup.x - targetPos.x;
    targetScroll.y = m_cursorDispBackup.y - targetPos.y;
    SetScroll( targetScroll );
  }
  else
  {
    // XN[lOɎ
    gfl::math::VEC3 targetScroll = GetScroll();
    targetScroll.x = m_scrollBackup.x * (scale-1.0f);
    targetScroll.y = m_scrollBackup.y * (scale-1.0f);
    SetScroll( targetScroll );

    // J[\ʒuSCALE1.0̍WɎ
    gfl::math::VEC3 cursorPos = GetCursorPos();
    cursorPos.x = targetPos.x + targetScroll.x;
    cursorPos.y = targetPos.y + targetScroll.y;
    SetCursorPos( cursorPos );
  }
}


// XP[ύXɂJ[\ړʒu̐ݒ
// SScale1.0̍Wɐݒ肷邱
void MapView::SetBackupCursorInfo( float targetScale )
{
  gfl::math::VEC3 cursorPos = GetCursorPos();

  m_scaleChangeCounter   = 10;
  m_cursorDispBackup     = cursorPos;

  //-------------------------------------------------
  float           scale     = GetScale();
  gfl::math::VEC3 mapPos    = GetMapPos();
  gfl::math::VEC3 scroll    = GetScroll();

  m_scrollBackup     = scroll;
  m_cursorPosOrigin  = cursorPos;

  // SW̕␳
  m_cursorPosOrigin.x   += (mapPos.x * (scale-1.0f));
  m_cursorPosOrigin.y   += (mapPos.y * (scale-1.0f));
  // {Wɕϊ
  m_cursorPosOrigin.x    = (m_cursorPosOrigin.x-scroll.x) / scale;
  m_cursorPosOrigin.y    = (m_cursorPosOrigin.y-scroll.y) / scale;
}


// J[\́uXEyCvւ̋z
bool MapView::AdsorbCursorWithPane( void )
{
  gfl::math::VEC3 cursorPos = GetCursorPos();
  gfl::math::VEC3 panePos;

  u32 painID = GetAbosorbRangePaneId( GetCursorPos(), &panePos );
  u32 nextID = UNKNOWN_PAIN;

  // yCɃJ[\݂H
  if( painID != UNKNOWN_PAIN )
  {
    // J[\ڕWWɎňړ
    float moveX = TownmapUtil::GetSubFloatValueWithLimit( cursorPos.x, panePos.x, -ABOSORB_MOVE_LIMIT, ABOSORB_MOVE_LIMIT );
    float moveY = TownmapUtil::GetSubFloatValueWithLimit( cursorPos.y, panePos.y, -ABOSORB_MOVE_LIMIT, ABOSORB_MOVE_LIMIT );

    if( !TownmapUtil::IsEqualWithFloat(moveX,0.0f) || !TownmapUtil::IsEqualWithFloat(moveY,0.0f) )
    {
      MoveCursor( moveX, moveY, false );
    }
    
    Place *place = m_townDat->GetPlaceInfo( painID );
    GFL_ASSERT( place );
    nextID = place->m_posPainId;
  }

  // ݂̃J[\ʒuɂyCOƈقȂH
  if( m_currentPlace != nextID
      && nextID != UNKNOWN_PAIN )
  {
    if( m_townUIListener != NULL ){
      m_townUIListener->OnChangeSelectedZone( nextID );
    }
    m_currentPlace = nextID;
  }

  return (nextID != UNKNOWN_PAIN);
}


// }bvJ[\쏈
void MapView::ControlCursor( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick )
{
  f32  moveX       = 0;  // Xړ
  f32  moveY       = 0;  // Yړ
  f32  moveSpeed   = 3.0f;  // ړx
  s32  moveDir     = app::ui::UIResponder::GetDirectionFlag( *pKey, *pStick );

  // L[
  if( (moveDir & gfl::ui::BUTTON_UP) != 0 ){
    moveY  = moveSpeed;
  }
  else if( (moveDir & gfl::ui::BUTTON_DOWN) != 0 ){
    moveY  = -moveSpeed;
  }
  if( (moveDir & gfl::ui::BUTTON_LEFT) != 0 ){
    moveX  = -moveSpeed;
  }
  else if( (moveDir & gfl::ui::BUTTON_RIGHT) != 0 ){
    moveX  = moveSpeed;
  }

  // J[\ړ
  if( (moveX != 0) || (moveY != 0) )
  {
    MoveCursor(moveX, moveY, false);
  }
}

/**
 * @brief \XP[؂ւ
 */
void MapView::ChangeScale( void )
{
  if( m_desc.use_scale )
  {
    if( GetScale() == 1.0f )
    {
      SetBackupCursorInfo( 2.0f );
      SetScale( 2.0f );
    }
    else
    {
      SetBackupCursorInfo( 1.0f );
      SetScale( 1.0f );
    }
    
    if( m_townUIListener != NULL ){
      m_townUIListener->OnScaleChange( GetScaleTarget() );
    }
  }
}


// uXEyCvʒuł̊m葀
bool MapView::DecideRoutePoint( void )
{
  if( m_desc.use_decide_zone )
  {
    u32 selectedPane = GetPaneIdWithCursorPos( GetCursorPos() );
    if( selectedPane != MapView::UNKNOWN_PAIN)
    {
      if( m_townUIListener != NULL ){
        m_townUIListener->OnDecideZone( selectedPane );
      }
      return true;
    }
  }
  return false;
}
/**
 * @brief TownmapData̒lƂɃyCXV
 *
 * @param isScroll  [in]    J[\ړɂ킹ăXN[Ȃtruew
 * @param moveX     [in]    J[\̂wړ
 * @param moveY     [in]    J[\̂xړ
 * @param scaleRate [in]    g嗦
 * @param mapPos    [in]    n}摜̒SWʒu
 * @param cursorPos [in/out]J[\̍Wʒu
 * @param scroll    [in/out]}bvXN[
 *
 * @return none
 */
void MapView::CalculateScreen( const bool isScroll, const float moveX, const float moveY, const float scaleRate, const gfl::math::VEC3 mapPos, gfl::math::VEC3& cursorPos, gfl::math::VEC3& scroll )
{
  const nw::lyt::Size barSize    = GetPaneSize( 0, PANENAME_TOWNMAP_LOWER_PANE_TOUCH_BAR_POS );
  const nw::lyt::Size mapSize    = GetPaneSize( 0, PANENAME_TOWNMAP_LOWER_PANE_TOWNMAP_BG1 );

  float               mapLeft    = (-(mapSize.width /2.0f)+mapPos.x) * scaleRate;
  float               mapRight   = ( (mapSize.width /2.0f)+mapPos.x) * scaleRate;
  float               mapTop     = ( (mapSize.height/2.0f)+mapPos.y) * scaleRate;
  float               mapBottom  = (-(mapSize.height/2.0f)+mapPos.y) * scaleRate;
  float               adjustY    = (mapPos.y*(scaleRate-1.0f));

  float               scrollXMin = -((-mapLeft)  - (DISPLAY_LOWER_WIDTH/2));                            // XN[Xŏl
  float               scrollXMax =  (mapRight    - (DISPLAY_LOWER_WIDTH/2));                            // XN[Xő
  float               scrollYMin = -(mapTop      - (DISPLAY_LOWER_HEIGHT/2)-adjustY);                   // XN[Yŏl
  float               scrollYMax =  ((-mapBottom)- ((DISPLAY_LOWER_HEIGHT/2)-barSize.height)+adjustY);  // XN[Yő

  float               scrollX    = 0.0f;
  float               scrollY    = 0.0f;
  float               leftLimit  = -((DISPLAY_LOWER_WIDTH/2.0f));
  float               rightLimit =  ((DISPLAY_LOWER_WIDTH/2.0f));//-(MapView::CURSOR_AREA*2.0f));
  float               topLimit   =  ((DISPLAY_LOWER_HEIGHT/2.0f));//-(MapView::CURSOR_AREA*2.0f));
  float               bottomLimit= -((DISPLAY_LOWER_HEIGHT/2.0f)-barSize.height);

  // J[\ʒuXV
  cursorPos.x = cursorPos.x + moveX;
  cursorPos.y = cursorPos.y + moveY;

  if( cursorPos.y < bottomLimit )
  {
    scrollY = bottomLimit - cursorPos.y ;
    cursorPos.y = bottomLimit;
  }
  else if( cursorPos.y > topLimit )
  {
    scrollY = topLimit-cursorPos.y;
    cursorPos.y = topLimit;
  }
  if( cursorPos.x < leftLimit )
  {
    scrollX = leftLimit-cursorPos.x;
    cursorPos.x = leftLimit;
  }
  else if( cursorPos.x > rightLimit ){
    scrollX =  rightLimit-cursorPos.x;
    cursorPos.x = rightLimit;
  }

  // J[\ړƓɃXN[
  if( isScroll )
  {
    scrollX = moveX;
    scrollY = moveY;
  }

  // XN[ʒuXV
  scroll.x  += scrollX;
  scroll.y  += scrollY;

  // XN[~bg
  if( scroll.y < scrollYMin ){
    scroll.y = scrollYMin;
  }
  else if( scroll.y > scrollYMax ){
    scroll.y = scrollYMax;
  }
  if( scroll.x < scrollXMin ){
    scroll.x = scrollXMin;
  }
  else if( scroll.x > scrollXMax ){
    scroll.x = scrollXMax;
  }
}
/**
 * @brief yCXV
 *
 * @param none
 *
 * @return none
 */
void MapView::UpdatePane( void )
{
  const nw::lyt::Size cursorSize = GetPaneSize( 0, PANENAME_TOWNMAP_LOWER_PANE_CURSOL_NULL );

  float           scaleRate = GetScale();
  gfl::math::VEC3 cursorPos = GetCursorPos();
  gfl::math::VEC3 scroll    = GetScroll();
  gfl::math::VEC3 mapPos    = GetMapPos();
  gfl::math::VEC3 heroPos   = GetHeroPos();
  gfl::math::VEC2 scale( scaleRate, scaleRate );
  // J[\WJ[\摜w悤ɕ␳
  // cursorPos.x += CURSOR_AREA;
  // cursorPos.y += CURSOR_AREA;

  // gkɂW␳
  TownmapUtil::AdjustVEC3WithScale( &heroPos, scaleRate );
  // }bvzuSW̍␳
  heroPos.y   -= (mapPos.y*(scaleRate-1.0f));

  // lACRE}bv̓XN[l𔽉f
  heroPos.x += scroll.x;
  heroPos.y += scroll.y;
  mapPos.x  += scroll.x;
  mapPos.y  += scroll.y;

  // WύX
  SetPanePos( 0, PANENAME_TOWNMAP_LOWER_PANE_CURSOL_NULL, &cursorPos );
  SetPanePos( 0, PANENAME_TOWNMAP_LOWER_PANE_TOWNMAP_BG1, &mapPos  );
  SetPanePos( 0, PANENAME_TOWNMAP_LOWER_PANE_TOWNMAP_BG2, &mapPos  );
  SetPanePos( 0, PANENAME_TOWNMAP_LOWER_PANE_HERO_OBJ,    &heroPos );

  // XP[ύX
  const gfl::math::VEC2& nowScale = GetPaneScale( 0, PANENAME_TOWNMAP_LOWER_PANE_TOWNMAP_BG1 );
  if( !TownmapUtil::IsEqualWithFloat(nowScale.x,scale.x) || !TownmapUtil::IsEqualWithFloat(nowScale.y,scale.y) )
  {
    SetPaneScale( 0, PANENAME_TOWNMAP_LOWER_PANE_TOWNMAP_BG1, &scale );
    SetPaneScale( 0, PANENAME_TOWNMAP_LOWER_PANE_TOWNMAP_BG2, &scale );
  }
}
/**
 * @brief n}pyCʒu̎擾
 *
 * @param none
 *
 * @return n}pyCʒu
 */
gfl::math::VEC3 MapView::GetMapPanePos( void )
{
  return GetPanePos( 0, PANENAME_TOWNMAP_LOWER_PANE_TOWNMAP_BG1 );
}
 /**
  * @brief   J[\ʒuɑyChc擾
  *
  * @param   cursorPos  J[\ʒu
  * @param   hitPanePos yCWi[BNULLw肷邱Ƃ\
  *
  * @return  ghsyChc
  */
u32 MapView::GetPaneIdWithCursorPos( const gfl::math::VEC3& cursorPos, gfl::math::VEC3* hitPanePos )
{
  // CAEgWʍWɕϊ
  u16 displayX  = (u16)(cursorPos.x + (DISPLAY_LOWER_WIDTH/2));
  u16 displayY  = (u16)((DISPLAY_LOWER_HEIGHT/2) - cursorPos.y);

  for( u32 i = 0; i < m_townDat->GetPlaceNum(); i++ )
  {
    Place *place = m_townDat->GetPlaceInfoByIndex( i );
    if( !GetG2DUtil()->GetHitPane( 0, place->m_posPainId, displayX, displayY ) ){
      continue; // ghs
    }

    if( hitPanePos != NULL ){
      *hitPanePos = GetPaneScreenPos( 0, place->m_posPainId );
    }
    return place->m_posPainId;
  }

  return UNKNOWN_PAIN;
}

 /**
  * @brief   z͈͂J[\ʒuɑyChc擾
  *
  * @param   cursorPos  J[\ʒu
  * @param   hitPanePos yCWi[BNULLw肷邱Ƃ\
  *
  * @return  ghsyChc
  */
u32 MapView::GetAbosorbRangePaneId( const gfl::math::VEC3& cursorPos, gfl::math::VEC3* hitPanePos )
{ 
  // CAEgWʍWɕϊ
  u16 displayX  = (u16)(cursorPos.x + (DISPLAY_LOWER_WIDTH/2));
  u16 displayY  = (u16)((DISPLAY_LOWER_HEIGHT/2) - cursorPos.y);
  
  //Ԕ͈͓̃yC
  u32 most_near_pane  = UNKNOWN_PAIN;
  f32 most_near_disitance = 10000000.0f; //Kɑ傫Ȓl
  
  gfl::math::VEC3 cursor_pane = GetPaneScreenPos( 0, PANENAME_TOWNMAP_LOWER_PANE_CURSOL_NULL );
  for( u32 i = 0; i < m_townDat->GetPlaceNum(); i++ )
  {
    Place *place = m_townDat->GetPlaceInfoByIndex( i );
    
    //z͈͂傫
    nw::lyt::Size normal = GetG2DUtil()->GetSize( 0, place->m_posPainId );
    nw::lyt::Size abosorb;
    abosorb.width   = normal.width * ABOSORB_RANGE_RATE;
    abosorb.height  = normal.height * ABOSORB_RANGE_RATE;
    GetG2DUtil()->SetSize( 0, place->m_posPainId, abosorb );
    if( GetG2DUtil()->GetHitPane( 0, place->m_posPainId, displayX, displayY ) )
    {
      //pos ̈ʒuAMAPItZbgAXN[lĂ
      //J[\
      gfl::math::VEC3 pos = GetPaneScreenPos( 0, place->m_posPainId );
      
      f32 dist = gfl::math::VEC3Dist( &cursor_pane, &pos );
      
      if( dist < most_near_disitance )
      {
        most_near_pane  = place->m_posPainId;
        most_near_disitance = dist;
      }
    }
    GetG2DUtil()->SetSize( 0, place->m_posPainId, normal );
  }
  
  if( most_near_pane != UNKNOWN_PAIN )
  {   
    if( hitPanePos != NULL ){
      *hitPanePos = GetPaneScreenPos( 0, most_near_pane );
    }
  }
  return most_near_pane;
}

/**
 * @brief lACRpyCʒu̎擾
 *
 * @param none
 *
 * @return lACRpyCʒu
 */
gfl::math::VEC3 MapView::GetPlayerIconPanePos( void )
{
  return GetPanePos( 0, PANENAME_TOWNMAP_LOWER_PANE_HERO_OBJ );
}

/**
 * @brief j[o[pyCTCY̎擾
 *
 * @param none
 *
 * @return j[o[pyCTCY
 */
const nw::lyt::Size MapView::GetMenuBarPaneSize( void )
{
  return GetPaneSize( 0, PANENAME_TOWNMAP_LOWER_PANE_TOUCH_BAR_POS );
}

/**
 * @brief tOACR
 */
void MapView::SetupArriveIcon( void )
{
  for( s32 i = 0; i < m_townDat->GetPlaceNum(); ++i )
  {
    Place*  place = m_townDat->GetPlaceInfoByIndex( i );
    if( place->m_iconPainId != 0 )
    {
      if( m_townDat->IsArrive( place->m_posPainId )  )
      {
        m_g2dUtil->SetPaneVisible( 0, place->m_iconPainId, true );
      }
      else
      {
        m_g2dUtil->SetPaneVisible( 0, place->m_iconPainId, false );
      }
    }
  }
}

/**
 * lʒu̐ݒ
 * @param pos ݒW
 */
inline void MapView::SetHeroPos( const gfl::math::VEC3& pos )
{
  m_heroPos = pos;
}

/**
 * J[\ʒu̎擾
 * @return J[\ʒu
 */
inline gfl::math::VEC3 MapView::GetHeroPos( void )
{
  return m_heroPos;
}

/**
 * J[\ʒu̐ݒ
 * @param pos ݒW
 */
inline void MapView::SetCursorPos( const gfl::math::VEC3& pos )
{
  m_cursorPos = pos;
}

/**
 * J[\ʒu̎擾
 * @return J[\ʒu
 */
inline gfl::math::VEC3 MapView::GetCursorPos( void )
{
  return m_cursorPos;
}

/**
 * MAPʒu̐ݒ
 * @param pos ݒW
 */
inline void MapView::SetMapPos( const gfl::math::VEC3& pos )
{
  m_mapPos = pos;
}

/**
 * MAPʒu̎擾
 * @return MAPʒu
 */
inline gfl::math::VEC3 MapView::GetMapPos( void )
{
  return m_mapPos;
}

/**
 * XN[ʂ̐ݒ
 * @param value
 */
inline void MapView::SetScroll( const gfl::math::VEC3& value )
{
  if( m_isEnableScroll ){
    m_scroll = value;
  }
}

/**
 * XN[ʂ̎擾
 * @return XN[
 */
inline gfl::math::VEC3 MapView::GetScroll( void )
{
  return m_scroll;
}

/**
 * XN[ۂ̎擾
 * @return XN[\Ȃtrueԋp
 */
inline bool            MapView::IsEnableScroll( void )
{
  return m_isEnableScroll;
}

/**
 * XP[l̐ݒ
 * param m_scale XP[l
 */
inline void            MapView::SetScale( float scale )
{
  m_scaleTarget = scale;
}

/**
 * ڕWXP[l̎擾
 * @return ڕWXP[l
 */
inline float           MapView::GetScaleTarget( void )
{
  return m_scaleTarget;
}

/**
 * XP[l̎擾
 * @return XP[l
 */
inline float           MapView::GetScale( void )
{
  return m_scale;
}


} //townmap
} //app
