
//=============================================================================
/**
 * @file   CameraGameLookAtOffset.cpp
 * @brief  Q[J_ItZbgNX
 * @author rc N
 * @date   2012.10.03
 */
//=============================================================================

#include "CameraGameLookAtOffset.h"

namespace field
{
  //-----------------------------------------------------------------------------
  // RXgN^
  //-----------------------------------------------------------------------------
  CCameraGameLookAtOffset::CCameraGameLookAtOffset()
  {
  }

  //-----------------------------------------------------------------------------
  // t[
  //-----------------------------------------------------------------------------
  void CCameraGameLookAtOffset::Update(gfl::math::VEC3* pOfst, const CCameraInfo& inCamera, const CCameraGameTarget& inTarget, const CCameraGameDataManager& inDataManager, const bool bIsReset, const float fDiffTime)
  {
    gfl::math::VEC3 inAxisX; gfl::math::MTX33GetAxisX(&inAxisX, inCamera.m_inMatrix);
    gfl::math::VEC3 inAxisY; gfl::math::MTX33GetAxisY(&inAxisY, inCamera.m_inMatrix);

    gfl::math::VEC3 inOfstX, inOfstY;
    gfl::math::VEC3Scale(&inOfstX, &inAxisX, inDataManager.GetData()->m_fLookAtOfstX);
    gfl::math::VEC3Scale(&inOfstY, &inAxisY, inDataManager.GetData()->m_fLookAtOfstY);

    gfl::math::VEC3Add(pOfst, &inOfstX, &inOfstY);
    pOfst->y += inDataManager.GetData()->m_fLookAtOfstYWorld;
  }

  //-----------------------------------------------------------------------------
  // fobO`
  //-----------------------------------------------------------------------------
  void CCameraGameLookAtOffset::DrawDebug()
  {
  }

} // namespace field

/*  EOF  */





