//==============================================================================
/**
 * @file	battle_match_proc_check_poke.cpp
 * @brief	og}b`@TuvbN@|P`FbN
 * @author	ichiraku_katsuhiko
 * @data	2012/10/02, 18:27
 */
// =============================================================================


#include <message/msg_battle_match.h>

#include "battle_match_proc_check_poke.h"


GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match)
GFL_NAMESPACE_BEGIN(proc)

// RXgN^
ProcCheckPoke::ProcCheckPoke( void ) : ProcBase()
{
	ICHI_PRINT("ProcCheckPoke::ProcCheckPoke\n");
}

// fXgN^
ProcCheckPoke::~ProcCheckPoke( void )
{
	ICHI_PRINT("ProcCheckPoke::~ProcCheckPoke\n");
}

//--------------------------------------------------------------------------
/**
 * @brief			֐
 * @return		result
 * 
 * @note			RES_FINISHԂƂUpdateFuncɐi
 */
//--------------------------------------------------------------------------
RESULT ProcCheckPoke::InitFunc( void )
{
	gamesystem::GameData  *game_data = m_game_manager->GetGameData();

	// qviewN
	m_view->RegistWait();
	m_view->RegistStandby();

	// qview擾
	m_view_lower = m_view->GetSubViewWait();
	m_view_upper = m_view->GetSubViewStandby();

	// |PACR
	m_view_upper->CreatePokeIcon();

	// ʂɃ|PACR\
	if( m_common_data->poke_select == POKE_BATTLE_BOX )
	{
		// og{bNX
		savedata::BattleBox *pBattleBox = game_data->GetBattleBox();
		m_view_upper->UpdateSelectBoxPokemon( pBattleBox );
	}
	else
	{
		// 莝
		const pml::PokeParty *pPokeParty = game_data->GetPlayerParty();
		m_view_upper->UpdateSelectBoxPokemon( pPokeParty );
	}

	// eLXg
	m_view_lower->SetTextWait( battle_match_guide_08 );
	m_view_upper->SetTextTitle( m_common_data->select_mode, m_common_data->battle_rule );

	// AjJn
	m_view_lower->StartTimeIcon();
	m_view_upper->StartAnime( ANMID_UPPER_STANDBY );

	return RESULT_FINISH;
}

//--------------------------------------------------------------------------
/**
 * @brief			XV֐
 * @return		result
 * 
 * @note			RES_FINISHԂƂExitFuncɐi
 */
//--------------------------------------------------------------------------
RESULT ProcCheckPoke::UpdateFunc( void )
{
	// M[V`FbN
	SetFinish( NEXT_REGULATION_CHECK );

	if( m_isEnd == true )
	{
		return RESULT_FINISH;
	}
	
	return RESULT_CONTINUE;
}

//--------------------------------------------------------------------------
/**
 * @brief			I֐
 * @return		result
 * 
 * @note			RES_FINISHԂƂUpdateFuncɐi
 */
//--------------------------------------------------------------------------
RESULT ProcCheckPoke::ExitFunc( void )
{
	// view͂̂܂
	return RESULT_FINISH;
}

GFL_NAMESPACE_END(proc)
GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)


