
//==============================================================================
/**
 * @file    xy_ExtSaveSystem.cpp
 * @brief   gZ[u[h̃Rg[sNX
 * @author  tamada
 * @date    2012.09.25
*/
//==============================================================================
#include <gflib.h>
//#include <system/thread_priority.h>
#include "extsavedata/xy_ExtSaveSystem.h"
#include "extsavedata/xy_ExtSaveData.h"

namespace extsavedata{

//===================================================================
//===================================================================


#if 1
//===================================================================
//
//
//  Z[u[hpXbh
//
//
//===================================================================
//--------------------------------------------------------------
/**
 * @class ExtSaveLoadControlThread
 */
//--------------------------------------------------------------
class ExtSaveLoadControlThread: public gfl::base::Thread
{
  private:
    XyExtSaveSystem *     m_pSaveLoadControl;
    EXTFILE_PARAM *            m_pSaveData;
    gfl::heap::HeapBase * m_pHeap;

  public:
    //--------------------------------------------------------------
    /// Constructor
    //--------------------------------------------------------------
    ExtSaveLoadControlThread(
        gfl::heap::HeapBase * heap,
        u32 stack_size,
        XyExtSaveSystem* svld_control,
        EXTFILE_PARAM * file_param) :
      Thread( heap, stack_size ),
      m_pSaveLoadControl(svld_control),
      m_pSaveData(file_param),
      m_pHeap(heap)
    {
    }

    //--------------------------------------------------------------
    /// Destructor
    //--------------------------------------------------------------
    ~ExtSaveLoadControlThread()
    {
    }

    //--------------------------------------------------------------
    /// Main
    //--------------------------------------------------------------
    virtual void Main( void )
    {
      m_pSaveLoadControl->ThreadCallBack(m_pHeap, m_pSaveData);
      this->Kill();
    }
};
#endif





//===================================================================
//===================================================================
//--------------------------------------------------------------
/**
 * @brief   RXgN^
 */
//--------------------------------------------------------------
XyExtSaveSystem::XyExtSaveSystem(gfl::heap::HeapBase* heap) :
  mpExtSaveSystem(NULL),
  m_pMyThread(NULL)
{
  mpExtSaveSystem = GFL_NEW(heap) gfl::fs::ExtSaveSystem(heap);
}


//--------------------------------------------------------------
/**
 * @brief   fXgN^
 */
//--------------------------------------------------------------
XyExtSaveSystem::~XyExtSaveSystem()
{
  GFL_DELETE(mpExtSaveSystem);
}



//--------------------------------------------------------------
/**
 * @brief   
 */
//--------------------------------------------------------------
void XyExtSaveSystem::Initialize( u32 id, void * iconData, size_t iconDataSize )
{
  mpExtSaveSystem->Initialize( id, iconData, iconDataSize,
      XyExtSaveData::GetMaxDirectoryCount(), XyExtSaveData::GetMaxFileCount() );
}


//--------------------------------------------------------------
/**
 * @brief   Z[uf[^̔񓯊Jn
 * @retval  gfl::fs::ExtSaveSystem::RESULT_OK       Jn
 */
//--------------------------------------------------------------
gfl::fs::ExtSaveSystem::Result XyExtSaveSystem::CreateFileStart( gfl::heap::HeapBase *pHeap )
{
  m_threadSystemResult = gfl::fs::ExtSaveSystem::RESULT_CONTINUE;
  this->StartThread( SAVE_THREAD_PRIORITY, THREAD_MODE_CREATE, pHeap, NULL );
  GFL_PRINT("Save Format Start\n");
  return gfl::fs::ExtSaveSystem::RESULT_OK;
}

//--------------------------------------------------------------
/**
 * @brief   Z[uf[^̔񓯊C
 * @retval  gfl::fs::ExtSaveSystem::RESULT_OK       
 * @retval  gfl::fs::ExtSaveSystem::RESULT_CONTINUE p
 * @retval  gfl::fs::ExtSaveSystem::RESULT_NG_xxxx  s
 */
//--------------------------------------------------------------
gfl::fs::ExtSaveSystem::Result XyExtSaveSystem::CreateFileMain(void)
{
  if (this->IsAsyncFinished() )
  {
    return m_threadSystemResult;
  }
  return gfl::fs::ExtSaveSystem::RESULT_CONTINUE;
}

//--------------------------------------------------------------
/**
 * @brief   Z[ü쐬 ͍蒼
 * @retval  gfl::fs::ExtSaveSystem::RESULT_OK       Z[uJn
 * @retval  gfl::fs::ExtSaveSystem::RESULT_NG_xxxx  Z[uJnɎs
 */
//--------------------------------------------------------------
gfl::fs::ExtSaveSystem::Result XyExtSaveSystem::CreateFile( const wchar_t * path ,size_t size )
{
  //m_threadSystemResult = mpExtSaveSystem->CreateBackupFile( path, size );
  if( gfl::fs::ExtSaveSystem::RESULT_OK != m_threadSystemResult)
  {
    return m_threadSystemResult;
  }
  m_threadSystemResult = gfl::fs::ExtSaveSystem::RESULT_OK;
  return m_threadSystemResult;
}

//--------------------------------------------------------------
//--------------------------------------------------------------
bool XyExtSaveSystem::StartWrite( gfl::heap::HeapBase * pHeap, EXTFILE_PARAM * file_param )
{
  this->StartThread( SAVE_THREAD_PRIORITY, THREAD_MODE_SAVE, pHeap, file_param );
  return true;
}

//--------------------------------------------------------------
//--------------------------------------------------------------
bool XyExtSaveSystem::WaitWrite( gfl::fs::BackupFile::Result * result )
{
  GFL_PRINT("XyExtSaveSystem::WaitWrite\n");
  if (IsAsyncFinished())
  {
    *result = m_threadFileResult;
    return true;
  }
  return false;
}

//--------------------------------------------------------------
//--------------------------------------------------------------
bool XyExtSaveSystem::StartRead( gfl::heap::HeapBase * pHeap, EXTFILE_PARAM * file_param )
{
  this->StartThread( SAVE_THREAD_PRIORITY, THREAD_MODE_LOAD, pHeap, file_param );
  return true;
}

//--------------------------------------------------------------
//--------------------------------------------------------------
bool XyExtSaveSystem::WaitRead( gfl::fs::BackupFile::Result * result )
{
  GFL_PRINT("XyExtSaveSystem::WaitRead\n");
  if (IsAsyncFinished())
  {
    *result = m_threadFileResult;
    return true;
  }
  return false;
}

//--------------------------------------------------------------
/**
 * @brief   t@C`FbN
 * @retval  t@Cfalse V[PXɂ
 * @retval  t@Ctrue ǂݍ
 *
 * @todo    t@CATCYȂǂ؂Kv
 * @todo    Ăꍇ̏l
 */
//--------------------------------------------------------------
bool XyExtSaveSystem::CheckFileExist( EXTFILE_PARAM * file_param )
{
  int index = GetEntryIndex( file_param );
  return false;
  //return mpExtSaveSystem->CheckBackupFileExist( mExtSaveData[index].name );
}


//===================================================================
//
//
//                      PrivateȊ֐
//
//
//===================================================================
//--------------------------------------------------------------
/**
 * @brief Z[uS̃f[^̃|C^T[`ACfbNX擾
 */
//--------------------------------------------------------------
int XyExtSaveSystem::GetEntryIndex( const EXTFILE_PARAM * file_param )
{
  GFL_ASSERT_STOP( 0 );
  return 0;
}
//--------------------------------------------------------------
/**
 * @brief obNAbvXbh
 * @param priority    Xbh̃vCIeB
 * @param mode        [h
 * @param pHeap       gpƗpq[v
 * @param file_param   Z[uf[^ւ̃|C^
 */
//--------------------------------------------------------------
void XyExtSaveSystem::StartThread(
    u8 priority, THREAD_MODE mode, gfl::heap::HeapBase * pHeap, EXTFILE_PARAM * file_param )
{
  m_threadMode = mode;
  m_pMyThread  = GFL_NEW( pHeap ) ExtSaveLoadControlThread( pHeap, 4096, this, file_param );
  m_pMyThread->Start( priority );
}

//--------------------------------------------------------------
/**
 * @brief XbhI҂
 * @return  bool  truêƂIĂ
 */
//--------------------------------------------------------------
bool XyExtSaveSystem::IsAsyncFinished( void )
{
  if (!m_pMyThread) return true;
  if (m_pMyThread->IsAlive() ) return false;

  GFL_DELETE m_pMyThread;
  m_pMyThread = NULL;
  m_threadMode = THREAD_MODE_NOTHING;
  return true;
}

//--------------------------------------------------------------
/**
 * @brief XbhĂ΂obNAbvC
 *
 * @note  [hɂŕ򂵂ĂB
 * @todo  Mount/CommitȂǂGFLIB̂̂g悤ɏC
 */
//--------------------------------------------------------------
void XyExtSaveSystem::ThreadCallBack(gfl::heap::HeapBase * pHeap, EXTFILE_PARAM * file_param )
{
  switch ( m_threadMode )
  {
  case THREAD_MODE_NOTHING:
    GFL_ASSERT(0);
    return;

  case THREAD_MODE_LOAD:
    {
      nn::Result mount_result = nn::fs::MountSaveData("data:");
      GFL_PRINT("nn::fs::MountSaveData\n");
      NN_DBG_PRINT_RESULT( mount_result );

      gfl::fs::BackupFile * pFile = GFL_NEW( pHeap ) gfl::fs::BackupFile();
      //m_threadFileResult = this->Load( pFile, file_param, pHeap );
      GFL_DELETE pFile;

      nn::fs::Unmount("data:");
    }
    break;

  case THREAD_MODE_SAVE:
    {
      nn::Result mount_result = nn::fs::MountSaveData("data:");
      GFL_PRINT("nn::fs::MountSaveData\n");
      NN_DBG_PRINT_RESULT( mount_result );

      gfl::fs::BackupFile * pFile = GFL_NEW( pHeap ) gfl::fs::BackupFile();
      //m_threadFileResult = this->Save( pFile, file_param, pHeap );
      GFL_DELETE pFile;

      // dĂꍇɂCommit삪Kv
      nn::Result commit_result = nn::fs::CommitSaveData();
      if ( commit_result.IsFailure() )
      {
        GFL_PRINT(" CommitSaveData is Failure!\n");
        NN_DBG_CHECK_RESULT( commit_result );
      }
      nn::fs::Unmount("data:");
    }
    break;

  case THREAD_MODE_CREATE:
    //m_threadSystemResult = this->CreateFile();
    GFL_PRINT("CreateFile()[%d]", m_threadSystemResult);
    break;
  }
}


} //namespace extsavedata

