//==============================================================================
/**
 * @file    xy_ExtSaveData.cpp
 * @brief   gZ[uf[^̒`
 * @author  tamada
 * @date    2012.09.25
 */
//==============================================================================
#include "extsavedata/xy_ExtSaveData.h"

GFL_NAMESPACE_BEGIN(extsavedata)



//-----------------------------------------------------------------------------
/**
 */
//-----------------------------------------------------------------------------
const ExtSaveDataFormat xy_ExtSaveDataFormat[] = {
  { //ogrfI
    L"btvideo",
    100,
    7000,
  },
  { //zO[
    L"hgmail",
    32,
    32816,
  },
  { //M[V
    L"reg",
    5,
    420
  },
  { //v[VrfI
    L"pv",
    10,
    400
  },
  { //3DJFB
    L"3dcam_mine",
    10,
    40000,
  },
  { //3DJFR[h擾
    L"3dcam_other",
    10,
    40000,
  },
  { //PSSACR@
    L"pss_me",
    1,
    3200,
  },
  { //PSSACR@FB
    L"pss_fr",
    100,
    3200,
  },
  { //PSSACR@m荇
    L"pss_ot",
    100,
    3200,
  },
  { //gCAnEX
    L"trhouse",
    30,
    4532,
  },
};

const int xy_ExtSaveDataFormatCount = GFL_NELEMS(xy_ExtSaveDataFormat);

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
int XyExtSaveData::GetMaxDirectoryCount( void )
{
  return ReservedDirectoryCount + xy_ExtSaveDataFormatCount;
}


//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
int XyExtSaveData::GetMaxFileCount( void )
{
  int count = 0;
  for (int i = 0; i < xy_ExtSaveDataFormatCount; ++ i )
  {
    count += xy_ExtSaveDataFormat[i].max_file_num;
  }
  return ReservedFileCount + count;
}





















GFL_NAMESPACE_END(extsavedata)
