
#ifndef __XY_EXTSAVESYSTEM_H__
#define __XY_EXTSAVESYSTEM_H__
//==============================================================================
/**
 * @file    xy_ExtSaveSystem.h
 * @brief   gZ[u[h̃Rg[sNX
 * @author  tamada
 * @date    2012.09.25
 */
//==============================================================================
#pragma once
#include <gflib.h>



GFL_NAMESPACE_BEGIN(extsavedata)

  class ExtSaveLoadControlThread;
  class xy_ExtSaveData;

  struct EXTFILE_PARAM {
    XY_EXTSAVE_ID id;
    u32 file_id;
    const char * filename;
    u32 size;
  };

//--------------------------------------------------------------
/**
 * @class XyExtSaveSystem
 */
//--------------------------------------------------------------
class XyExtSaveSystem{
  GFL_FORBID_COPY_AND_ASSIGN(XyExtSaveSystem); //Rs[RXgN^{֎~

  friend class ExtSaveLoadControlThread;

  enum THREAD_MODE{
    THREAD_MODE_NOTHING = 0,
    THREAD_MODE_LOAD,
    THREAD_MODE_SAVE,
    THREAD_MODE_CREATE,
  };
  static const int MAX_FILE_PATH_LENGTH = nn::fs::MAX_FILE_PATH_LENGTH;

private:
  gfl::fs::ExtSaveSystem* mpExtSaveSystem;

  THREAD_MODE m_threadMode;
  ExtSaveLoadControlThread * m_pMyThread;
  gfl::fs::BackupFile::Result m_threadFileResult;
  gfl::fs::ExtSaveSystem::Result m_threadSystemResult;

  wchar_t temp_path[ MAX_FILE_PATH_LENGTH ];

private:
  void StartThread( u8 priority, THREAD_MODE mode, gfl::heap::HeapBase * pHeap, EXTFILE_PARAM * pSaveData );
  void ThreadCallBack(gfl::heap::HeapBase * pHeap, EXTFILE_PARAM * pSaveData );
  bool IsAsyncFinished( void );
  int GetEntryIndex( const EXTFILE_PARAM * file_param );



public:
  //--------------------------------------------------------------
  /**
   * @brief   RXgN^
   */
  //--------------------------------------------------------------
  XyExtSaveSystem(gfl::heap::HeapBase* heap);

  //--------------------------------------------------------------
  /**
   * @brief   fXgN^
   */
  //--------------------------------------------------------------
  ~XyExtSaveSystem();

  //--------------------------------------------------------------
  /**
   * @brief   ŏɌĂ
   * @param  indexnum  Ǘf[uf[^
   */
  //--------------------------------------------------------------
  void Initialize( u32 id, void * iconData, size_t iconDataSize );


  //--------------------------------------------------------------
  /**
   * @brief   Z[ü쐬
   * @retval  gfl::fs::ExtSaveSystem::RESULT_OK       Z[uJn
   * @retval  gfl::fs::ExtSaveSystem::RESULT_NG_xxxx  Z[uJnɎs
   */
  //--------------------------------------------------------------
  gfl::fs::ExtSaveSystem::Result CreateFile( const wchar_t * path, size_t size );
  gfl::fs::ExtSaveSystem::Result CreateFile( const EXTFILE_PARAM * param );

  //--------------------------------------------------------------
  /**
   * @brief   Z[uf[^̔񓯊Jn
   * @retval  gfl::fs::ExtSaveSystem::RESULT_OK       Jn
   */
  //--------------------------------------------------------------
  gfl::fs::ExtSaveSystem::Result CreateFileStart( gfl::heap::HeapBase *pHeap );

  //--------------------------------------------------------------
  /**
   * @brief   Z[uf[^̔񓯊C
   * @retval  gfl::fs::ExtSaveSystem::RESULT_OK       
   * @retval  gfl::fs::ExtSaveSystem::RESULT_CONTINUE p
   * @retval  gfl::fs::ExtSaveSystem::RESULT_NG_xxxx  s
   */
  //--------------------------------------------------------------
  gfl::fs::ExtSaveSystem::Result CreateFileMain(void);

  //--------------------------------------------------------------
  /**
   * @brief   t@C`FbN
   * @param   file_param
   * @retval  t@Cfalse V[PXɂ
   * @retval  t@Ctrue ǂݍ
   */
  //--------------------------------------------------------------
  bool CheckFileExist( EXTFILE_PARAM * file_param );
  //--------------------------------------------------------------
  /**
   * @brief   Q[f[^ɃZ[us
   * @param   gamedata    Q[f[^ւ̃|C^
   * @retval  gfl::fs::ExtSaveSystem::RESULT_OK       Z[uJn
   * @retval  gfl::fs::ExtSaveSystem::RESULT_NG_xxxx  Z[uJnɎs
   */
  //--------------------------------------------------------------
  bool StartWrite( gfl::heap::HeapBase * pHeap, EXTFILE_PARAM * file_param );

  //--------------------------------------------------------------
  /**
   * @brief   Q[f[^ɃZ[us
   * @retval  gfl::fs::ExtSaveSystem::RESULT_OK       Z[u
   * @retval  gfl::fs::ExtSaveSystem::RESULT_NG_xxxx  Z[us
   */
  //--------------------------------------------------------------
  bool WaitWrite( gfl::fs::BackupFile::Result * result );

  //--------------------------------------------------------------
  /**
   * @brief   Q[f[^Ƀ[hs
   * @param   gamedata    Q[f[^ւ̃|C^
   * @retval  gfl::fs::ExtSaveSystem::RESULT_OK       [hJn
   * @retval  gfl::fs::ExtSaveSystem::RESULT_NG_xxxx  [hJnɎs
   */
  //--------------------------------------------------------------
  bool StartRead( gfl::heap::HeapBase * pHeap, EXTFILE_PARAM * file_param );

  //--------------------------------------------------------------
  /**
   * @brief   Q[f[^Ƀ[hs
   * @retval  gfl::fs::ExtSaveSystem::RESULT_OK           [h
   * @retval  gfl::fs::ExtSaveSystem::RESULT_CONTINUE     [h
   * @retval  gfl::fs::ExtSaveSystem::RESULT_NG_xxxx      [hs
   */
  //--------------------------------------------------------------
  bool WaitRead( gfl::fs::BackupFile::Result * result );




}; //class XyExtSaveSystem

GFL_NAMESPACE_END(extsavedata)

#endif //__XY_EXTSAVESYSTEM_H__
