#if !defined( __XY_EXTSAVEDATA_H__ )
#define __XY_EXTSAVEDATA_H__
//==============================================================================
/**
 * @file    xy_ExtSaveData.h
 * @brief   gZ[uf[^̒`
 * @author  tamada
 * @date    2012.09.25
 */
//==============================================================================
#pragma once

#include <gflib.h>


GFL_NAMESPACE_BEGIN(extsavedata)

class SaveLoadControl;


//-----------------------------------------------------------------------------
/**
 * @brief gZ[uf[^`
 */
//-----------------------------------------------------------------------------
struct ExtSaveDataFormat
{
  const wchar_t * directory_name;
  int             max_file_num;
  size_t          max_file_size;
};

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
enum XY_EXTSAVE_ID
{
  EXTID_BATTLEVIDEO,
  EXTID_HGMAIL,
  EXTID_REGULATION,
  EXTID_PROMOTIONVIDEO,
  EXTID_3DCAMERA_MINE,
  EXTID_3DCAMERA_OTHER,
  EXTID_PSSICON_MINE,
  EXTID_PSSICON_FRIEND,
  EXTID_PSSICON_OTHER,
  EXTID_TRIALHOUSE,
};

//-----------------------------------------------------------------------------
/**
 * @class XyExtSaveData
 */
//-----------------------------------------------------------------------------
class XyExtSaveData : public gfl::base::Singleton<XyExtSaveData>
{
  GFL_FORBID_COPY_AND_ASSIGN(XyExtSaveData); //Rs[RXgN^{֎~

public:
  //RXgN^
  XyExtSaveData( gfl::heap::HeapBase * heap );
  //fXgN^
  virtual ~XyExtSaveData(){};


  static int GetMaxDirectoryCount(void);
  static int GetMaxFileCount(void);

  //----------------------------------------------------------
  /**
   */
  //----------------------------------------------------------

private:
  static const int ReservedFileCount = 100;
  static const int ReservedDirectoryCount = 15;
  


};  //XyExtSaveData

GFL_NAMESPACE_END(extsavedata)



#endif  // __XY_EXTSAVEDATA_H__




