//=============================================================================
/**
 * @file   gflnet_NexMessageClient.cpp
 *
 * @brief  nn::nex::MessageClient̃bp[NXB
 *
 * @author h.suzuki
 */
//=============================================================================


#include <netapp/rating/NexRatingClient.h>
#include <nex/gflnet_NexTemplate.h>

GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(rating)



//------------------------------------------------------------------
/**
 * @brief  NexRatingClientRXgN^
 */
//------------------------------------------------------------------
NexRatingClient::NexRatingClient( void )
{
  m_ratingClient       = NULL;
  m_ratingSessionToken = NULL;
  m_isInit             = false;
  m_isAccess           = false;
  m_statusList         = NULL;

  std::memset( m_reportStats, 0, sizeof(m_reportStats) );
}


//------------------------------------------------------------------
/**
 * @brief  NexRatingClientfXgN^
 */
//------------------------------------------------------------------
NexRatingClient::~NexRatingClient()
{
  Finalize();
}


//------------------------------------------------------------------
/**
* @brief  NexRatingClient̏
*
* @param[in]  credentials     Q[T[o[OC
*
* @return ɐȂtrueԋp
*/
//------------------------------------------------------------------
bool NexRatingClient::Initialize( nn::nex::Credentials* credentials )
{
  if( !m_isInit )
  {
    m_isInit   = true;
    m_isAccess = false;

    m_ratingClient       = qNew nn::nex::RatingClient();
    m_ratingSessionToken = qNew nn::nex::RatingSessionToken();
    m_statusList         = qNew nn::nex::qList<nn::nex::RatingStats>;

    for( u32 i = 0; i < (u32)E_SLOT_MAX; i++ )
    {
      if( m_reportStats[i] == NULL )
      {
        m_reportStats[i] = qNew nn::nex::RatingStats();
        if( m_reportStats[i] == NULL ){
          return false;
        }
      }
    }

    if( !m_ratingClient->Bind(credentials) ){
      return false;
    }
  }
  return true;
}


//------------------------------------------------------------------
/**
* @brief  NexRatingClient̏I
*/
//------------------------------------------------------------------
void NexRatingClient::Finalize( void )
{
  if( m_isInit )
  {
    m_isInit   = false;
    m_isAccess = false;

    std::memset( m_listener, 0, sizeof(m_listener) );

    if( m_ratingClient != NULL )
    {
      if( m_ratingClient->GetCredentials() != NULL ){
        m_ratingClient->Unbind();
      }
    }

    for( u32 i = 0; i < (u32)E_SLOT_MAX; i++ )
    {
      gflnet::nex::NexFreeMemory(&m_reportStats[i]);
    }
    gflnet::nex::NexFreeCollection( &m_statusList );
    gflnet::nex::NexFreeMemory(&m_ratingSessionToken);
    gflnet::nex::NexFreeMemory(&m_ratingClient);
  }
}


//------------------------------------------------------------------
/**
* @brief [eBOpXi̓o^
*
* @param[in] listener o^Ώۂ̃bZ[WpXiB
*
* @return o^ɐȂtrueԋp
*/
//------------------------------------------------------------------
bool NexRatingClient::RegistRatingClientListener( NexRatingClientListener* listener )
{
  for( u32 i = 0; i < LISTENER_NUM; i++ )
  {
    if( m_listener[i] == listener ){
      return false; // o^ς
    }
  }
  for( u32 i = 0; i < LISTENER_NUM; i++ )
  {
    if( m_listener[i] == NULL )
    {
      m_listener[i] = listener;
      return true; // o^
    }
  }

  return false;
}


//------------------------------------------------------------------
/**
* @brief [eBOpXỉ
*
* @param[in] listener 폜Ώۂ̃bZ[WpXiB
*/
//------------------------------------------------------------------
void NexRatingClient::UnregistRatingClientListener( NexRatingClientListener* listener )
{
  for( u32 i = 0; i < LISTENER_NUM; i++ )
  {
    if( m_listener[i] == listener )
    {
      m_listener[i] = NULL;
      return;
    }
  }
}


//------------------------------------------------------------------
/**
* @brief [eBOZbV𐶐i񓯊ʐMj
*
* @param  none
*
* @note  ʐḾuNexRatingClientListener::OnCreateRatingSessionSuccess()vR[B
* @note  ʐMśuNexRatingClientListener::OnCreateRatingSessionFailed()vR[B
* @note  {֐sꍇNexRatingClientListenerCxg̓R[ȂB
*
* @return sɐȂtrueԋp
*/
//------------------------------------------------------------------
bool NexRatingClient::CreateRatingSession( void )
{
  if( m_isAccess || !m_isInit ){
    return false;   // ʐM, 
  }
  m_isAccess = true;

  nn::nex::ProtocolCallContext *pContext = qNew nn::nex::ProtocolCallContext();

  if( m_ratingClient->CreateSession(pContext, m_ratingSessionToken) )
  {
    // [pContext]ReLXg͏IR[obNŉ
    qNew gflnet::nex::CallContextCallback<NexRatingClient>(this, &NexRatingClient::OnCreateSessionCompletion, pContext );
    return true;
  }
  else
  {
    qDelete pContext;
    m_isAccess = false;
    return false;
  }
}


//------------------------------------------------------------------
/**
* @brief [eBOZbVɎQi񓯊ʐMj
*
* @param  none
*
* @note  ʐMÍuNexRatingClientListener::OnJoinRatingSessionFinish()vR[B
* @note  {֐sꍇNexRatingClientListenerCxg̓R[ȂB
*
* @return sɐȂtrueԋp
*/
//------------------------------------------------------------------
bool NexRatingClient::JoinRatingSession( const nn::nex::qVector<qByte>& sessionKey )
{
  if( m_isAccess || !m_isInit ){
    return false;   // ʐM, 
  }
  m_isAccess = true;

  m_ratingSessionToken->SetKey( sessionKey );

  nn::nex::ProtocolCallContext *pContext = qNew nn::nex::ProtocolCallContext();

  if( m_ratingClient->JoinSession(pContext, *m_ratingSessionToken) )
  {
    // [pContext]ReLXg͏IR[obNŉ
    qNew gflnet::nex::CallContextCallback<NexRatingClient>(this, &NexRatingClient::OnJoinSessionCompletion, pContext );
    return true;
  }
  else
  {
    qDelete pContext;
    m_isAccess = false;
    return false;
  }
}


//------------------------------------------------------------------
/**
* @brief vf[^[eBOT[oɑMi񓯊ʐMj
*
* @attention {֐sOɕKSetReportStatusInfo()ɂ2̌ʏZbg邱ƁI
*
* @note  ʐMÍuNexRatingClientListener::OnRatingReportFinish()vR[B
* @note  {֐sꍇNexRatingClientListenerCxg̓R[ȂB
*
* @return sɐȂtrueԋp
*/
//------------------------------------------------------------------
bool NexRatingClient::ReportRatingStats( void )
{
  if( m_isAccess || !m_isInit ){
    return false;   // ʐM, 
  }
  m_isAccess = true;

  nn::nex::ProtocolCallContext *pContext = qNew nn::nex::ProtocolCallContext();

  m_statusList->clear();
  for( u32 i = 0; i < (u32)E_SLOT_MAX; i++ ){
    m_statusList->push_back( *m_reportStats[i] );
  }

  if( m_ratingClient->ReportStats(pContext, *m_ratingSessionToken, *m_statusList) )
  {
    // [pContext]ReLXg͏IR[obNŉ
    qNew gflnet::nex::CallContextCallback<NexRatingClient>(this, &NexRatingClient::OnReportRatingCompletion, pContext );
    return true;
  }
  else
  {
    qDelete pContext;
    m_isAccess = false;
    return false;
  }
}


//------------------------------------------------------------------
/**
* @brief ΐ팋ʃf[^Zbg
*
* @attention ReportRatingStats()sOɕK{֐ɂ2̌ʏZbg邱ƁI
*
* @param slot            ݒ肷XbgID
* @param pid             vVoID
* @param nexUniqueId     NEXj[NID
* @param dissconnectFlag ʐMؒftO
* @param rate            ΐ팋ʃ[g
*
* @return sɐȂtrueԋp
*/
//------------------------------------------------------------------
bool NexRatingClient::SetReportStatusInfo( REPORT_SLOT_ID slot,
                                           gflnet::friends::PrincipalId pid,
                                           u64 nexUniqueId,
                                           nn::nex::RatingStatsFlags::RatingStatsFlags dissconnectFlag,
                                           REPORT_RATE rate )
{
  if( m_isAccess || !m_isInit ){
    return false;   // ʐM, 
  }
  nn::nex::qVector<float> point;

  if( rate == E_RATE_WIN ){
    point.push_back( 1.0f );
  }
  else if( rate == E_RATE_DRAW ){
    point.push_back( 0.5f );
  }
  else{
    point.push_back( 0.0f );
  }

  m_reportStats[slot]->SetPrincipalID( pid );
  m_reportStats[slot]->SetFlag( dissconnectFlag );
  m_reportStats[slot]->SetUniqueID( nexUniqueId );
  m_reportStats[slot]->SetListValues( point );

  return true;
}



//------------------------------------------------------------------
/**
 * @brief  [eBOZbV̊ʒmmp֐
 *
 * @attention R[obN֐ɂ̂݊J邽߁A[U[gp֎~I
 *
 * @param[in,out]  pContext ʒmΏۂƂȂReLXg
 */
//------------------------------------------------------------------
void NexRatingClient::OnCreateSessionCompletion(nn::nex::CallContext *pContext)
{
  nn::nex::qResult result = pContext->GetOutcome();

  if( (qBool)result )
  {
    nn::nex::qVector<qByte> key;
    m_ratingSessionToken->GetKey(key);

    for( u32 i = 0; i < LISTENER_NUM; i++ )
    {
      if( m_listener[i] != NULL ){
        m_listener[i]->OnCreateRatingSessionSuccess( key );
      }
    }
  }
  else
  {
    for( u32 i = 0; i < LISTENER_NUM; i++ )
    {
      if( m_listener[i] != NULL ){
        m_listener[i]->OnCreateRatingSessionFailed( result );
      }
    }
  }
}


//------------------------------------------------------------------
/**
 * @brief  [eBOZbVQ̊ʒmmp֐
 *
 * @attention R[obN֐ɂ̂݊J邽߁A[U[gp֎~I
 *
 * @param[in,out]  pContext ʒmΏۂƂȂReLXg
 */
//------------------------------------------------------------------
void NexRatingClient::OnJoinSessionCompletion(nn::nex::CallContext *pContext)
{
  nn::nex::qResult result = pContext->GetOutcome();

  for( u32 i = 0; i < LISTENER_NUM; i++ )
  {
    if( m_listener[i] != NULL ){
      m_listener[i]->OnJoinRatingSessionFinish( result );
    }
  }
}


//------------------------------------------------------------------
/**
 * @brief  [eBO񍐂̊ʒmmp֐
 *
 * @attention R[obN֐ɂ̂݊J邽߁A[U[gp֎~I
 *
 * @param[in,out]  pContext ʒmΏۂƂȂReLXg
 */
//------------------------------------------------------------------
void NexRatingClient::OnReportRatingCompletion(nn::nex::CallContext *pContext)
{
  nn::nex::qResult result = pContext->GetOutcome();

  for( u32 i = 0; i < LISTENER_NUM; i++ )
  {
    if( m_listener[i] != NULL ){
      m_listener[i]->OnRatingReportFinish( result );
    }
  }
}




GFL_NAMESPACE_END(rating)
GFL_NAMESPACE_END(netapp)
