//=============================================================================
/**
 * @file   NexRatingClientListener.h
 * @brief  RatingClient֘AʒmCxgnh
 * @author h.suzuki
 */
//=============================================================================

#ifndef __NEX_RATING_CLIENT_LISTENER_H__
#define __NEX_RATING_CLIENT_LISTENER_H__

#include <gflib.h>


GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(rating)

//------------------------------------------------------------------
/*!
 * @brief RatingClientʒmCxgnh
 *
 * @note [eBO֘A̒ʒm󂯎ꍇ́A
 *       {NXpz֐ĂB
 */
//------------------------------------------------------------------
class NexRatingClientListener
{
//  GFL_FORBID_COPY_AND_ASSIGN(NexRatingClientListener); //Rs[RXgN^{֎~
public:
  //------------------------------------------------------------------
  /**
  * @brief RatingZbV쐬̐ʒm
  *
  * @param[in] sessionKey ꂽZbVL[
  */
  //------------------------------------------------------------------
  virtual void OnCreateRatingSessionSuccess( const nn::nex::qVector<qByte>& sessionKey ){};

  //------------------------------------------------------------------
  /**
  * @brief RatingZbV쐬̎sʒm
  *
  * @param[in] result  s
  */
  //------------------------------------------------------------------
  virtual void OnCreateRatingSessionFailed( nn::nex::qResult& result ){};

  //------------------------------------------------------------------
  /**
  * @brief RatingZbVQIʒm
  *
  * @param[in] result  s
  */
  //------------------------------------------------------------------
  virtual void OnJoinRatingSessionFinish( nn::nex::qResult& result ){};

  //------------------------------------------------------------------
  /**
  * @brief RatingT[oւ̌ʑMIʒm
  *
  * @param[in] result  s
  */
  //------------------------------------------------------------------
  virtual void OnRatingReportFinish( nn::nex::qResult& result ){};
};


GFL_NAMESPACE_END(rating)
GFL_NAMESPACE_END(netapp)



#endif // __NEX_RATING_CLIENT_LISTENER_H__
