//=============================================================================
/**
 * @file   NexRatingClient.h
 *
 * @brief  nn::nex::Rating̃bp[NXB
 *
 * @author h.suzuki
 */
//=============================================================================

#ifndef __NEX_RATING_CLIENT_H__
#define __NEX_RATING_CLIENT_H__


#include <gflib.h>
#include <gflnet.h>
#include <netapp/rating/NexRatingClientListener.h>


GFL_NAMESPACE_BEGIN(netapp)

/**
 * @namespace netapp::rating
 * @brief     NEX[eBOgCu֘A
 */
GFL_NAMESPACE_BEGIN(rating)


//------------------------------------------------------------------
/**
*  @brief [eBOǗNXiRatingClientANZXjpNX
*
*  @attention OɃQ[T[oփOCĂ
*  @attention NexManager::Dispatch() sɃR[邱Ƃ͂łȂB
*  @attention e񓯊ʐM͔rƂȂׁAs͕sB
*
**/
//------------------------------------------------------------------
class NexRatingClient
{
public:
    /**
    * @brief |[gɎwłXbg
    */
    typedef enum
    {
      E_SLOT1,      //!< ΐi[Xbg1
      E_SLOT2,      //!< ΐi[Xbg2
      E_SLOT_MAX    //!< ΐi[Xbgő吔
    }REPORT_SLOT_ID;

    /**
     * @brief ΐ팋ʃ[g
     */
    typedef enum
    {
      E_RATE_WIN,    //!< 
      E_RATE_DRAW,   //!< 
      E_RATE_LOSE,   //!< sk
    }REPORT_RATE;


public:
    NexRatingClient( void );
    virtual ~NexRatingClient();

public:
  //------------------------------------------------------------------
  /**
  * @brief  RatingClient̏
  *
  * @param[in]  credentials     Q[T[o[OC
  *
  * @return ɐȂtrueԋp
  */
  //------------------------------------------------------------------
  bool Initialize( nn::nex::Credentials* credentials );

  //------------------------------------------------------------------
  /**
  * @brief  RatingClient̏I
  */
  //------------------------------------------------------------------
  void Finalize( void );

public:
  //------------------------------------------------------------------
  /**
  * @brief [eBOpXi̓o^
  *
  * @param[in] listener o^Ώۂ̃[eBOpXiB
  *
  * @return o^ɐȂtrueԋp
  */
  //------------------------------------------------------------------
  bool RegistRatingClientListener( NexRatingClientListener* listener );

  //------------------------------------------------------------------
  /**
  * @brief [eBOpXỉ
  *
  * @param[in] listener 폜Ώۂ̃[eBOpXiB
  */
  //------------------------------------------------------------------
  void UnregistRatingClientListener( NexRatingClientListener* listener );

public:
  //------------------------------------------------------------------
  /**
  * @brief [eBOZbV𐶐i񓯊ʐMj
  *
  * @attention }b`CNZbṼI[i[̂ݎs\B
  * @attention nn::nex::MatchmakeExtensionClient::OpenParticipation()R[OɎs邱ƁB
  *
  * @param  none
  *
  * @note  ʐMÍuNexRatingClientListener::OnCreateRatingSessionFinish()vR[B
  * @note  {֐sꍇNexRatingClientListenerCxg̓R[ȂB
  *
  * @return sɐȂtrueԋp
  */
  //------------------------------------------------------------------
  bool CreateRatingSession( void );

  //------------------------------------------------------------------
  /**
  * @brief [eBOZbVɎQi񓯊ʐMj
  *
  * @attention OɃ}b`CNZbVɎQĂKvB
  * @attention }b`CNZbV̔I[i[̂ݎs\
  *
  * @param  sessionKey QZbṼL[
  *
  * @note  ʐMÍuNexRatingClientListener::OnJoinRatingSessionFinish()vR[B
  * @note  {֐sꍇNexRatingClientListenerCxg̓R[ȂB
  *
  * @return sɐȂtrueԋp
  */
  //------------------------------------------------------------------
  bool JoinRatingSession( const nn::nex::qVector<qByte>& sessionKey );

  //------------------------------------------------------------------
  /**
  * @brief vf[^[eBOT[oɑMi񓯊ʐMj
  *
  * @attention {֐sOɕKSetReportStatusInfo()ɂ2̌ʏZbg邱ƁI
  *
  * @note  ʐMÍuNexRatingClientListener::OnRatingReportFinish()vR[B
  * @note  {֐sꍇNexRatingClientListenerCxg̓R[ȂB
  *
  * @return sɐȂtrueԋp
  */
  //------------------------------------------------------------------
  bool ReportRatingStats( void );

  //------------------------------------------------------------------
  /**
  * @brief ΐ팋ʃf[^Zbg
  *
  * @attention ReportRatingStats()sOɕK{֐ɂ2̌ʏZbg邱ƁI
  *
  * @param slot            ݒ肷XbgID
  * @param pid             vVoID
  * @param nexUniqueId     NEXj[NID
  * @param dissconnectFlag ʐMؒftO
  * @param rate            ΐ팋ʃ[g
  *
  * @return sɐȂtrueԋp
  */
  //------------------------------------------------------------------
  bool SetReportStatusInfo( REPORT_SLOT_ID slot,
                            gflnet::friends::PrincipalId pid,
                            u64 nexUniqueId,
                            nn::nex::RatingStatsFlags::RatingStatsFlags dissconnectFlag,
                            REPORT_RATE rate );

public:
  //------------------------------------------------------------------
  /**
   * @brief  ʒmmp֐
   *
   * @attention R[obN֐ɂ̂݊J邽߁A[U[gp֎~I
   *
   * @param[in,out]  pContext ʒmΏۂƂȂReLXg
   */
  //------------------------------------------------------------------
  void OnCreateSessionCompletion(nn::nex::CallContext *pContext);
  void OnJoinSessionCompletion(nn::nex::CallContext *pContext);
  void OnReportRatingCompletion(nn::nex::CallContext *pContext);

private:
    static const u32             LISTENER_NUM = 4;          //!< Xiőo^\
    //
    NexRatingClientListener*     m_listener[LISTENER_NUM];  //!< [eBOpXi
    //
    bool                         m_isInit;                  //!< tO
    bool                         m_isAccess;                //!< ʐMtO
    //
    nn::nex::RatingClient*       m_ratingClient;            //!< [eBONCAg
    nn::nex::RatingSessionToken* m_ratingSessionToken;      //!< ZbVg[N
    nn::nex::RatingStats*        m_reportStats[E_SLOT_MAX]; //!< |[g
    //
    nn::nex::qList<nn::nex::RatingStats>* m_statusList;     //!< |[g񃊃Xg
};





GFL_NAMESPACE_END(rating)
GFL_NAMESPACE_END(netapp)

#endif      // __NEX_RATING_CLIENT_H__
