//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		FieldResident.cpp
 *	@brief  tB[h@풓
 *	@author	tomoya takahashi
 *	@date		2012.09.30
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "field/FieldResident.h"

#include "field/FieldmapProc.h"

#include "gamesystem/GameManager.h"

namespace field{

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------

  //----------------------------------------------------------------------------
  /**
   *	@brief  RXgN^
   */
  //-----------------------------------------------------------------------------
  Resident::Resident(void) : 
    m_IsSetup(false),
    m_pHeapField(NULL),
    m_pDeviceHeapField(NULL),
    m_pHeapAreaKeep(NULL),
    m_pHeapAreaKeepDevice(NULL),
    m_pHeapFieldAllocator(NULL),        // tB[hfoCXAP[^
    m_pDeviceHeapFieldAllocator(NULL),        // tB[hfoCXAP[^
    m_pHeapAreaKeepAllocator(NULL),        // 
    m_pHeapAreaKeepDeviceAllocator(NULL)    // 
  {
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  fXgN^
   */
  //-----------------------------------------------------------------------------
  Resident::~Resident()
  {
    this->Finalize();
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  
   *
   *	@param	p_heap        ẽq[vID
   *	@param	p_device      ẽfoCXq[vID
   *	@param	p_gamemanager Q[}l[W
   */
  //-----------------------------------------------------------------------------
  void Resident::Initialize( gfl::heap::HeapBase* p_heap, gfl::heap::HeapBase* p_device, gamesystem::GameManager* p_gamemanager )
  {
    if( m_IsSetup == false ){

      m_pHeapAreaKeep = GFL_CREATE_HEAP( 
                              p_heap,
                              HEAPID_FIELD_AREAKEEP_HEAP,        //VHEAPID
                              HEAP_FIELD_AREAKEEP_SIZE,     //q[ṽTCY
                              gfl::heap::HEAP_TYPE_EXP,  //q[v̎
                              false );
      
      m_pHeapAreaKeepDevice = GFL_CREATE_HEAP( 
                              p_device,
                              HEAPID_FIELD_AREAKEEP_DEVICE,        //VHEAPID
                              HEAP_FIELD_AREAKEEP_DEVICE_SIZE,     //q[ṽTCY
                              gfl::heap::HEAP_TYPE_EXP,  //q[v̎
                              false );


      // tB[h}bvpq[v
      m_pHeapField  = GFL_CREATE_HEAP( 
                              p_heap,
                              HEAPID_FIELDMAP,        //VHEAPID
                              HEAP_FIELDMAP_SIZE,     //q[ṽTCY
                              gfl::heap::HEAP_TYPE_EXP,  //q[v̎
                              false );

      // tB[h}bvpfoCXq[v
      m_pDeviceHeapField  = GFL_CREATE_HEAP( 
                              p_device,
                              HEAPID_FIELDMAP_DEVICE,        //VHEAPID
                              DEVICEHEAP_FIELDMAP_SIZE,     //q[ṽTCY
                              gfl::heap::HEAP_TYPE_EXP,  //q[v̎
                              false );

      // tB[h}bv@풓q[v
      m_pHeapFieldResident =  GFL_CREATE_HEAP(
                                m_pHeapField,
                                HEAPID_FIELD_RESIDENT,        //VHEAPID
                                HEAP_FIELD_RESIDENT_SIZE,     //q[ṽTCY
                                gfl::heap::HEAP_TYPE_EXP,  //q[v̎
                                false );


      m_pHeapFieldAllocator             = GFL_NEW(m_pHeapField) gfl::heap::NwAllocator( m_pHeapField );
      m_pDeviceHeapFieldAllocator       = GFL_NEW(m_pHeapField) gfl::heap::NwAllocator( m_pDeviceHeapField );
      m_pHeapAreaKeepAllocator = GFL_NEW(m_pHeapField) gfl::heap::NwAllocator( m_pHeapAreaKeep );        // 
      m_pHeapAreaKeepDeviceAllocator = GFL_NEW(m_pHeapField) gfl::heap::NwAllocator( m_pHeapAreaKeepDevice );    // 

      // OtBbNXVXȅ
      m_pGameManager = p_gamemanager;
      m_pGameManager->GetGraphicsSystem()->InitializeApplicationMemory( m_pDeviceHeapFieldAllocator );

      // FileReadManagerɏ풓ARCIDݒ
      {
        gfl::fs::FileReadManager* p_fileman = m_pGameManager->GetFileReadManager();
        p_fileman->AppendManageFile( m_pHeapFieldResident, ARCID_MESSAGE );
      }
  
      // [hZbg
      m_pResidentWordSetLoader = GFL_NEW( m_pHeapFieldResident ) WordSetLoader(
          m_pHeapFieldResident, m_pGameManager->GetFileReadManager(), PRELOAD_ITEMNAME );
      m_pResidentWordSetLoader->StartLoad();

      m_IsSetup = true;
    }
  }

  //---------------------------------------------------------------------------
  /**
   *	@brief  j
   */
  //-----------------------------------------------------------------------------
  void Resident::Finalize( void )
  {
    if(m_IsSetup){

      m_pGameManager->GetGraphicsSystem()->FinalizeApplicationMemory();

      // [hZbgj
      GFL_SAFE_DELETE(m_pResidentWordSetLoader);

      // FileReadManagerɏ풓ARCIDj
      {
        gfl::fs::FileReadManager* p_fileman = m_pGameManager->GetFileReadManager();
        p_fileman->RemoveManageFile( ARCID_MESSAGE );
      }

      GFL_DELETE m_pHeapFieldAllocator;
      m_pHeapFieldAllocator = NULL;
      GFL_DELETE m_pDeviceHeapFieldAllocator;
      m_pDeviceHeapFieldAllocator = NULL;
      GFL_DELETE m_pHeapAreaKeepAllocator;        // 
      m_pHeapAreaKeepAllocator = NULL;
      GFL_DELETE m_pHeapAreaKeepDeviceAllocator;    // 
      m_pHeapAreaKeepDeviceAllocator = NULL;

      // q[vj
      gfl::heap::Manager::DeleteHeap( m_pHeapFieldResident );
      m_pHeapFieldResident  = NULL;
      gfl::heap::Manager::DeleteHeap( m_pDeviceHeapField );
      m_pDeviceHeapField = NULL;
      gfl::heap::Manager::DeleteHeap( m_pHeapField );
      m_pHeapField = NULL;
      gfl::heap::Manager::DeleteHeap( m_pHeapAreaKeepDevice );
      m_pHeapAreaKeepDevice = NULL;
      gfl::heap::Manager::DeleteHeap( m_pHeapAreaKeep );
      m_pHeapAreaKeep = NULL;

      m_IsSetup = false;
    }
  }

  // 
  //----------------------------------------------------------------------------
  /**
   *	@brief  풓[hZbg̃ZbgAbv܂
   *	@retval true    ZbgAbv
   *	@retval false   ZbgAbvr
   */
  //-----------------------------------------------------------------------------
  bool Resident::IsWordSetLoaderSetUp( void )
  {
    if( m_IsSetup ){
      return m_pResidentWordSetLoader->WaitLoad();
    }
    return true;
  }

} // field

