//============================================================================================
/**
 * @file    sv_gamesync.h
 * @brief   Q[VNpZ[uf[^
 * @author  hisanao_suzuki
 */
//============================================================================================

#ifndef __SV_GAME_SYNC_H__
#define __SV_GAME_SYNC_H__

#pragma once

#include <gflib.h>

namespace savedata
{

class GameSync : public SaveDataInterface
{
public:
  static const u32 STOCK_ITEM_MAX = 100;  //!< XgbNłACeXbg

  typedef struct
  {
    //------------------------------
    u16   m_isUploaded         : 1;   //!< T[oɃZ[uf[^Abv[hAĂȂ𐧌B
    u16   m_isNoRegistPGL      : 1;   //!< PGLɖo^ԂŃQ[VNĎsۂONBA[g{OFFB
    u16   m_isEnableAutoSync   : 1;   //!< I[gVNONAOFFBlONB
    u16   m_isSendingMileage   : 1;   //!< }C[W𑗂AȂ𐧌Bl͑B
    u16   m_isDispedGuide1     : 1;   //!< Q[VNƂ́H̐Sēǂ
    u16   m_isDispedGuide2     : 1;   //!< Q[VN̂тSēǂ
    u16   m_isDispedGuide3     : 1;   //!< Q[VN̂肩Sēǂ
    u16   m_isDispedFirstGuide : 1;   //!< Q[VNʂ̏eLXg𐧌BeLXgONB
    u16   m_isUpdateWallPaper  : 1;   //!< ǎ_E[hčXVۂɂPAXVĂȂꍇ0ɂB
    u16   m_padding            : 7;   //!< padding
    //------------------------------
    //
    u8    m_reserved[88];             //!< \
  }ConfigInfo;

  /**
  * @brief PGLo^
  */
  typedef struct
  {
    bool  m_isSigned;     //!< uDNuvo^ς݃tO
    u8    m_reserved[3];  //!< \
  }PglRegistInfo;

  /**
   * @brief ǎ
   */
  typedef struct
  {
    u16   m_registId;   //!< o^ĂǎID
    u16   m_reserved;   //!< \
  }WallPaperInfo;

  /**
   * @brief XgbNACe
   */
  typedef struct
  {
    u16   m_id;         //!< ID
    u16   m_num;        //!< 
  }StockItem;

  /**
   * @brief ACeXbg
   */
  typedef struct
  {
    StockItem m_itemSlot[STOCK_ITEM_MAX]; //!< ACeXbg
    u32       m_itemNum;                  //!< gpXbg
  }StockItemInfo;

  /**
   * @brief Q[VN{^CX^v
   */
  typedef struct
  {
    u8 m_year;        //!< N(0-99)
    u8 m_month;       //!< 
    u8 m_day;         //!< 
    u8 m_hour;        //!< 
    u8 m_minute;      //!< 
    u8 m_reserved[3]; //!< \
  }DateInfo;

  /**
   * @brief Q[VN
   */
  typedef struct
  {
    PglRegistInfo m_registInf;  //!< PGLo^
    StockItemInfo m_itemInf;    //!< ACeXbg
    WallPaperInfo m_wallInf;    //!< ǎ
    DateInfo      m_dateInf;    //!< Q[VN{^CX^v
    ConfigInfo    m_config;     //!< RtBO
  }GameSyncData;

public:
  //--------------------------------------------------------------------------------------------
  /**
   * @brief   RXgN^
   */
  //--------------------------------------------------------------------------------------------
  GameSync(void);

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   fXgN^
   */
  //--------------------------------------------------------------------------------------------
  ~GameSync(void);

  //=============================================================================
  //@brief SaveDataInterface
  //=============================================================================
public:
  /**
   *  @brief    ǂݍ񂾃f[^Zbg֐
    * @param    pData   擪̃|C^
   */
  virtual void SetData(void* data);
  /**
   *  @brief    f[^̐擪|C^𓾂֐
    * @return   擪̃|C^
   */
  virtual void* GetData(void);
  /**
   *  @brief    f[^TCY
   *  @retval   oCg
   */
  virtual size_t GetDataSize(void);
  /**
   * @brief Z[uf[^̃NA
   * @param heap@NAɎgpe|q[v
   */
  virtual void Clear( gfl::heap::HeapBase * heap );


  //=============================================================================
  //@brief ȉprivate
  //=============================================================================
private:
  GameSyncData m_data;  //f[^{
};


} //namespace savedata


#endif // __SV_GAME_SYNC_H__
