//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_zukan_BattleBackGround.cpp
 *	@brief
 *	@author	Toru=Nagihashi
 *	@date		2012.06.12
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "app_zukan_BattleBackGround.h"

#include "system/gfl_use.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(zukan)

//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 * @brief RXgN^
 *
 * @param heap  q[v
 * @param game_manager  Q[}l[W[
 * @param graphics_system OtBbNXVXe
 * @param g3dutil RDǗ
 * @param bg_component_data BGݒ
 */
BattleBackGround::BattleBackGround(app::util::Heap *heap, gamesystem::GameManager *game_manager, gfl::grp::GraphicsSystem* graphics_system, app::util::G3DUtil *g3dutil , const xy_system::bg::ComponentData *bg_component_data, u32 calc_group, u32 draw_group_back, u32 draw_group_sky, u32 draw_group_weather ) :
  m_bg_system( NULL ),
  m_g3dutil( g3dutil ),
  m_seq( SEQUENCE_IDLE ),
  m_bg_component_data( *bg_component_data ),
  m_draw_group_back( draw_group_back ),
  m_draw_group_sky( draw_group_sky ),
  m_draw_group_weather( draw_group_weather )
{
  m_bg_system = GFL_NEW(heap->GetSystemHeap())xy_system::bg::System;
  
  xy_system::bg::InitSystemParam param;

  param.heapAllocator = heap->GetSystemAllocator();
  param.deviceAllocator = heap->GetDeviceAllocator();

  param.grpSys = graphics_system;
  param.g3dSys = g3dutil->GetG3dSystem();
  param.scene  = g3dutil->GetScene();
  param.camera = g3dutil->GetUpperCamera();
  param.readMng= game_manager->GetFileReadManager();
  param.mdlCalcGroup = calc_group;
  param.mdlDrawGroup = m_draw_group_back;
  param.mdlObjDrawGroup = m_draw_group_back;
  param.useEnv = true;
  param.skyBox = game_manager->GetSkybox();
  param.posMan = game_manager->GetWeatherPositionManager();
  param.lightMan = game_manager->GetWeatherLightManager();
  param.weatherMng = game_manager->GetWeatherManager();
  param.skyCalcGroup = calc_group;
  param.skyDrawGroup = m_draw_group_sky;
  param.wheatherCalcGroup = calc_group;
  param.wheatherDrawGroup = m_draw_group_weather;
  param.isAutoWeather = true;
  param.isAutoTime = true;
  
  m_bg_system->Init(param);
}

/**
 * @brief fXgN^
 */
BattleBackGround::~BattleBackGround()
{
  if( m_seq == SEQUENCE_MAIN )
  {
    m_bg_system->RemoveScene();
  }
  m_bg_system->Delete();
  m_bg_system->Exit();
  GFL_SAFE_DELETE( m_bg_system );
}

//-----------------------------------------------------------------------
// VXe
//-----------------------------------------------------------------------
/**
 * @brief XV
 */
void BattleBackGround::Update( void )
{
  switch( m_seq )
  {
  case SEQUENCE_START_LOAD:
    {
      m_bg_component_data.objBaseId = 0;  //KO
      m_bg_component_data.skyboxFlag = true;  ///Kg
      m_bg_system->StartLoad(m_bg_component_data);
      
      m_seq = SEQUENCE_WAIT_LOAD;
    }
    break;
  case SEQUENCE_WAIT_LOAD:
    if( m_bg_system->IsFinishLoad() )
    {
      m_bg_system->Create();
      m_bg_system->AddScene();
      m_seq = SEQUENCE_MAIN;
    }
    break;
  }
  
  m_bg_system->Update();
  
  if( SEQUENCE_MAIN == m_seq )
  {
    {
      gfl::grp::g3d::StereoCamera* camera = m_g3dutil->GetUpperCamera();
      m_g3dutil->GetScene()->SubmitView(camera,true,true,m_draw_group_back);
      m_g3dutil->GetScene()->SubmitView(camera,true,true,m_draw_group_sky);
      m_g3dutil->GetScene()->SubmitView(camera,true,true,m_draw_group_weather);
    }
    
    {
      gfl::grp::g3d::StereoCamera* camera = m_g3dutil->GetLowerCamera();
      m_g3dutil->GetScene()->SubmitView(camera,true,true,m_draw_group_back);
      m_g3dutil->GetScene()->SubmitView(camera,true,true,m_draw_group_sky);
      m_g3dutil->GetScene()->SubmitView(camera,true,true,m_draw_group_weather);
    }
  }
  
}
/**
 * @brief `
 */
void BattleBackGround::Draw( void )
{
  if( m_seq == SEQUENCE_MAIN )
  {
    {
      gfl::grp::g3d::StereoCamera* camera = m_g3dutil->GetUpperCamera();
      m_bg_system->StereoDraw( camera );
    }
    {
      gfl::grp::g3d::StereoCamera* camera = m_g3dutil->GetLowerCamera();
      m_bg_system->StereoDraw( camera );
    }
  }
}
//-----------------------------------------------------------------------
// 
//-----------------------------------------------------------------------
/**
 * @brief ǂݍ݊Jn
 */
void BattleBackGround::StartLoad( void )
{
  if( m_seq == SEQUENCE_IDLE )
  {
    m_seq = SEQUENCE_START_LOAD;
  }
}
/**
 * @brief ǂݍݒǂ
 *
 * @return trueǂݍݏI falseǂݍݒ
 */
bool BattleBackGround::IsFinishLoad( void ) const
{
  return m_seq == SEQUENCE_MAIN;
}

GFL_NAMESPACE_END(zukan)
GFL_NAMESPACE_END(app)

