//===================================================================
/**
 * @file    EShopSaveData.h
 * @brief   OAv󂯌Z[uf[^
 * @author  k.ohno
 * @date    2012.09.28
 */
//===================================================================
#ifndef __ESHOP_SAVE_DATA_H__
#define __ESHOP_SAVE_DATA_H__

#include <gflib.h>
#include <gflnet.h>
#include "savedata/SaveDataInterface.h"

GFL_NAMESPACE_BEGIN(savedata)

//ESHOPf[^



struct ESHOP_POKEMON_SAVE_DATA
{
  u8 body[160];
  u8 header[8];
};


struct ESHOP_ITEM_SAVE_DATA
{
  u8 body[12];
};


/**
*  ESHOPZ[uf[^ǗNX
*/

class EShopSaveData : public SaveDataInterface
{
GFL_FORBID_COPY_AND_ASSIGN(EShopSaveData); //Rs[RXgN^{֎~

public:
	
	
private:



	//Z[uf[^{
	struct CORE_DATA
	{
		u32 recvFlag[512]; //MtO256byte
		ESHOP_POKEMON_SAVE_DATA pokemon[6];
    ESHOP_ITEM_SAVE_DATA item[6];
    u8 battlepoint[8];
    u8 mileagepoint[8];
	};


public:
	//=============================================================================================
	/**
	*  RXgN^
	*/
	//=============================================================================================
	EShopSaveData( void );
	//=============================================================================================
	/**
	*  fXgN^
	*/
	//=============================================================================================
	virtual ~EShopSaveData();

	//=============================================================================================
	/**
	*  f[^Rs[
	*
	* @param[in]   src   Rs[
	*/
	//=============================================================================================
	void CopyFrom( const EShopSaveData& src );


public:
	//======================================================================================================================
	// for SaveData
	//======================================================================================================================

	//=============================================================================================
	/**
	* [for SaveData]  ۑf[^oCiւ̃|C^Ԃ
	*
	* @retval        void*
	*/
	//=============================================================================================
	virtual void*  GetData( void );

	//=============================================================================================
	/**
	* [for SaveData]  ۑf[^oCĩTCYԂ
	*
	* @retval        void*
	*/
	//=============================================================================================
	virtual size_t    GetDataSize( void );
	//=============================================================================================
	/**
	 * [for SaveData]  Z[uf[^WJ
	 *
	 * @retval        void*
	 */
	//=============================================================================================
	virtual void SetData(void* pData);

	//=============================================================================================
	/**
	* [for SaveData]  Z[uf[^
	*
	* @param heap
	*/
	//=============================================================================================
	virtual void    Clear( gfl::heap::HeapBase * heap );

private:
	CORE_DATA           m_coreData;

};  // class EShopSaveData

GFL_NAMESPACE_END(savedata)




#endif //__ESHOP_SAVE_DATA_H__
