//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		H3dCameraNearClipShader.cpp
 *	@brief  JjANbvVF[_[
 *	@author	Masayuki Onoue
 *	@date		2012.09.28
 *
 *	@note H3dCameraNearClipShaderƂH3dɑΉ
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include "system/thread_priority.h"
#include "system/H3dCameraNearClipShader.h"

#include "arc/arc_def.h"
#include "arc/kujira_h3d_shaders.gaix"


namespace xy_system{

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------

  //-----------------------------------------------------------------------------
  /**
   *    \[XNX
   */
  //-----------------------------------------------------------------------------
   
  /* -------------------------------------------------------------------------*/
  /**
   * @brief  \[X  iInitializeUpdatetrueAĂAj
   *
   * @param p_heap            q[v
   * @param p_heap_allocator  q[vAP[^
   * @param p_devie_allocator foCXAP[^
   * @param type  \[X^Cv
   */
  /* -------------------------------------------------------------------------*/
  void H3dCameraNearClipShader::Resource::Initialize( gfl::heap::HeapBase* p_heap, gfl::heap::NwAllocator* p_heap_allocator,gfl::heap::NwAllocator* p_devie_allocator, ResType type )
  {
		m_pHeap		= p_heap;
    m_pHeapAllocator    = p_heap_allocator;
    m_pDeviceAllocator  = p_devie_allocator;
		GFL_PRINT("0 %x %x \n", m_pDeviceAllocator, m_pDeviceAllocator->GetHeapBase());
    m_Loaded  = false;
    
    // A[JCu
    m_pArcFile = GFL_NEW( p_heap ) gfl::fs::ArcFile( p_heap, ARCID_KUJIRA_H3DSHADERS, 0 );
    m_pArcFile->StartSetupForFastMode( p_heap->GetLowerHandle(), p_heap );
    m_pShaderResource = GFL_NEW(p_heap) gfl::grp::g3d::H3dResource();
    m_pShader         = GFL_NEW(p_heap) gfl::grp::g3d::H3dResShader();
    m_pShaderBuffer = NULL;
    m_ResType = type;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  \[XXV
   *	@retval true  
   *	@retval false 
   */
  //-----------------------------------------------------------------------------
  bool H3dCameraNearClipShader::Resource::InitializeUpdate( void )
  {
    static const u32 ResDataID[ RES_MAX ] = {
      GARC_kujira_h3d_shaders_kujiraCullingShader_BCHSDR,
      GARC_kujira_h3d_shaders_kujiraCullingShader01_BCHSDR,
    };
    
    // ǂݍ݊ԂȂsqtd
    if( m_Loaded ) {
      return true;
    }
    
    // [hڍs
    if( m_pArcFile->WaitSetupForFastMode() == false ){
      return false;
    }

    // f[^ǂݍ
    if( m_pShaderBuffer == NULL ){

      u32 dataID;
      if( m_ResType < RES_MAX ){
        dataID = ResDataID[m_ResType];
      }else{
        GFL_ASSERT(0);
        dataID = ResDataID[0];
      }
      u32 size = m_pArcFile->GetDataSize( dataID );
      bool result;
      
      m_pShaderBuffer = GflHeapAllocMemoryAlign( m_pDeviceAllocator->GetHeapBase(), size, 128 );

			GFL_PRINT("** free %x \n", m_pHeap->GetTotalFreeSize());
      // ǂݍ݊Jn
      result = m_pArcFile->StartAsyncRead( m_pHeap, dataID,
          m_pShaderBuffer, MAIN_THREAD_PRIORITY+1 );
      GFL_ASSERT( result );
    }else{

      // ǂݍ݊҂
      if( m_pArcFile->WaitAsyncRead() == false ){

        bool result;
        
        result = m_pShaderResource->AttachBufferAndSetup( m_pHeapAllocator,m_pDeviceAllocator, m_pShaderBuffer );
        GFL_ASSERT( result );
        
        // VF[_[쐬
        const char* p_shader_name = m_pShaderResource->GetShaderContentName(0);
        s32 content_index = m_pShaderResource->GetShaderContentIndex(p_shader_name);
        m_pShader->Create( m_pHeapAllocator, m_pDeviceAllocator, m_pShaderResource, content_index );
        
        m_Loaded = true;
        return true;
      }
    }


    return false;
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  \[X̏܂
   *	@retval true    
   *	@retval false   r
   */
  //-----------------------------------------------------------------------------
  bool H3dCameraNearClipShader::Resource::IsInitialized( void ) const
  {
    return m_Loaded;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  \[Xj
   */
  //-----------------------------------------------------------------------------
  void H3dCameraNearClipShader::Resource::Finalize( void )
  {
    if( !m_Loaded ){
      return ;
    }

    m_Loaded = false;
    
    GFL_SAFE_DELETE(m_pArcFile);
    GFL_SAFE_DELETE(m_pShader);
    GFL_SAFE_DELETE(m_pShaderResource);
    GflHeapSafeFreeMemory( m_pShaderBuffer );
  }

  //-----------------------------------------------------------------------------
  /**
   *      jANbvVF[_[
   */
  //-----------------------------------------------------------------------------
  //----------------------------------------------------------------------------
  /**
   *	@brief  RXgN^[
   */
  //-----------------------------------------------------------------------------
  H3dCameraNearClipShader::H3dCameraNearClipShader(void) :
    m_cpResource(NULL),
    m_pModel(NULL),
    m_IsShaderSetting(false)
  {
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  fXgN^
   */
  //-----------------------------------------------------------------------------
  H3dCameraNearClipShader::~H3dCameraNearClipShader()
  {
    this->Finalize();
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  jANbvVF[_[
   *
   *  @param    p_heap          q[v
   *	@param	  cp_resource     \[X
   *	@param    p_model         VF[_[𔽉f郂fB
   */
  //-----------------------------------------------------------------------------
  void H3dCameraNearClipShader::Initialize( gfl::heap::HeapBase* p_heap, const Resource* cp_resource, gfl::grp::g3d::H3dModel* p_model )
  {
    m_cpResource  = cp_resource;
    m_pModel      = p_model;

    m_IsShaderSetting = false;

    // ftHgݒ擾ĂB
    this->SetUpDefaultShaderParam( p_heap, p_model );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  jANbvVF[_[j
   */
  //-----------------------------------------------------------------------------
  void H3dCameraNearClipShader::Finalize( void )
  {
    if( this->IsInitialized() ){
      this->ClearDefaultShaderParam();
      m_pModel = NULL;  
      m_cpResource  = NULL;
      m_IsShaderSetting = false;
    }
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  Ă邩`FbN
   */
  //-----------------------------------------------------------------------------
  bool H3dCameraNearClipShader::IsInitialized(void) const
  {
    if( m_pModel ){
      return true;
    }
    return false;
  }
  

  //----------------------------------------------------------------------------
  /**
   *	@brief  VF[_[ݒ̍XV
   *  
   *	@param	cp_camera   (StereôƂBase)
   *	@param  force       forcetOiIɃVF[_[Kj
   *
   *	@retval true  jANbvVF[_[ݒ蒆
   *	@retval false jANbvVF[_[ݒ肵ĂȂ
   */
  //-----------------------------------------------------------------------------
  bool H3dCameraNearClipShader::UpdateShader( const gfl::grp::g3d::Camera* cp_camera, f32 shaderOnDepht, bool force )
  {
    bool ret = false;
    if( this->IsInitialized() ){
    
      if( force || this->IsHitNearClip(m_pModel, cp_camera, shaderOnDepht ) ){
        this->SetShaderParam( m_pModel );
        ret = true;
      }else{
        this->ResetShaderParam( m_pModel );
      }
    }
    return ret;
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  ftHgVF[_[p[^擾B
   *
   *  @param  p_heap    p[^ێpmۗp
   *	@param	p_model   f
   */
  //-----------------------------------------------------------------------------
  void H3dCameraNearClipShader::SetUpDefaultShaderParam( gfl::heap::HeapBase* p_heap, gfl::grp::g3d::H3dModel* p_model )
  {
    // }eA擾
    m_MaterialNum = p_model->GetMaterialCount();
    m_pDefaultMaterialParam = reinterpret_cast<DefaultMaterialParam*>(GflHeapAllocMemory( p_heap, sizeof(DefaultMaterialParam) * m_MaterialNum ));
    
    //TOMOYA_PRINT( "MaterialNum %d\n", m_MaterialNum );
    
    // ftHg̃VF[_[f[^WB
    for( u32 i=0; i<m_MaterialNum; ++i ){
      // ftHgp[^̎擾
      this->SetDefaultParam( p_model,i, &m_pDefaultMaterialParam[i] );
    }
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ftHgp[^j
   */
  //-----------------------------------------------------------------------------
  void H3dCameraNearClipShader::ClearDefaultShaderParam( void )
  {
    if( m_pDefaultMaterialParam != NULL ){
      GflHeapFreeMemory( m_pDefaultMaterialParam );
      m_pDefaultMaterialParam = NULL;
      m_MaterialNum = 0;
    }
  }

  /* -------------------------------------------------------------------------*/
  /**
   * @brief  }eÃftHgp[^ݒ
   *
   * @param p_model   擾郂f
   * @param mat_idx   }eACfbNX
   * @param p_param   p[^i[
   */
  /* -------------------------------------------------------------------------*/
  void H3dCameraNearClipShader::SetDefaultParam( gfl::grp::g3d::H3dModel* p_model,u32 mat_idx, DefaultMaterialParam* p_param )
  {
    // RoCiݒ
    {
      p_param->m_DefaultAlphaSource1  = 
        p_model->GetMaterialTextureCombinerSourceAlpha( mat_idx, WRITE_COMBINER_IDX , 1);
      p_param->m_DefaultAlphaOperand1 = 
        p_model->GetMaterialTextureCombinerOperandAlpha( mat_idx, WRITE_COMBINER_IDX ,1 );
      p_param->m_DefaultAlphaCombine  = 
        p_model->GetMaterialTextureCombinerCombineAlpha( mat_idx , WRITE_COMBINER_IDX );
      p_param->m_DefaultAlphaScale    = 
        p_model->GetMaterialTextureCombinerScaleAlpha( mat_idx , WRITE_COMBINER_IDX );
    }

    // u_[ݒ
    {
      p_param->m_DefaultBlendMode           = 
        p_model->GetMaterialBlendMode( mat_idx );
      p_param->m_DefaultLogicOperation      = 
        p_model->GetMaterialBlendLogicOperation( mat_idx );
      p_param->m_DefaultBlendSrcRGB         = 
        p_model->GetMaterialBlendFunctionSourceRgb(mat_idx );
      p_param->m_DefaultBlendDstRGB         = 
        p_model->GetMaterialBlendFunctionDestinationRgb( mat_idx );
      p_param->m_DefaultBlendSrcAlpha       = 
        p_model->GetMaterialBlendFunctionSourceAlpha( mat_idx );
      p_param->m_DefaultBlendDstAlpha       = 
        p_model->GetMaterialBlendFunctionDestinationAlpha( mat_idx );
      p_param->m_DefaultBlendEquationRGB    = 
        p_model->GetMaterialBlendEquationRgb( mat_idx );
      p_param->m_DefaultBlendEquationAlpha  = 
        p_model->GetMaterialBlendEquationAlpha( mat_idx );
    }

    // XeVݒ
    {
      p_param->m_DefaultStencilTestEnable   = 
        p_model->IsMaterialStencilTestEnable( mat_idx );
      p_param->m_DefaultStencilFailOpe      = 
        p_model->GetMaterialStencilTestFailOperation( mat_idx );
      p_param->m_DefaultStencilDepthFailOpe = 
        p_model->GetMaterialStencilTestZFailOperation( mat_idx );
      p_param->m_DefaultStencilPassOpe      = 
        p_model->GetMaterialStencilTestPassOperation( mat_idx );
    }

    // JO[h
    {
      p_param->m_DefaultCullingMode = 
        p_model->GetMaterialRasterizationCullingMode( mat_idx );
    }

    // C[
    {
      p_param->m_DefaultLayer = p_model->GetMaterialTranslucencyKind( mat_idx );
    }

    // fvXeXg
    {
      p_param->m_DefaultDepthFlag = p_model->IsMaterialDepthTestEnable( mat_idx );
    }
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  VF[_[Kv邩`FbN
   *
   *	@param	cp_model    `FbN郂f
   *	@param	cp_camera   J
   *
   *	@retval true  KvB
   *	@retval false KvȂB
   */
  //-----------------------------------------------------------------------------
  bool H3dCameraNearClipShader::IsHitNearClip( const gfl::grp::g3d::H3dModel* cp_model, const gfl::grp::g3d::Camera* cp_camera, f32 shaderOnDepth ) const
  {
    // XN[Wnł̂``aa擾Ay̒lDEFAULT_SHADER_ON_SCREEN_Z_NUMł΁A
    // VF[_[KB
    gfl::math::AABB screen_aabb;

    nn::math::MTX34 viewMat;
    cp_camera->GetViewMatrix( &viewMat );

    gfl::grp::g3d::Scene::GetScreanCoordinatesModelAABB( &screen_aabb, *cp_model, *cp_camera );
    
    if( screen_aabb.GetMax().z > -shaderOnDepth ){
      // jAVF[_[B
      return true;
    }
    return false;
  }

  // 
  //----------------------------------------------------------------------------
  /**
   *	@brief  ftHgێAVF[_[ݒsB
   *
   *	@param	p_model ݒ肷郂f
   */
  //-----------------------------------------------------------------------------
  void H3dCameraNearClipShader::SetShaderParam( gfl::grp::g3d::H3dModel* p_model )
  {
    if(!m_IsShaderSetting){
    
      // VF[_[p[^ݒB
      for( u32 i=0; i<m_MaterialNum; ++i ){

        this->SetMaterialShaderParam( p_model, i );
      }
      m_IsShaderSetting = true;
    }
  }

  /* -------------------------------------------------------------------------*/
  /**
   * @brief  }eAɃjANbvVF[_[ݒ
   *
   * @param p_model ݒ肷郂f
   * @param mat_idx }eACfbNX
   */
  /* -------------------------------------------------------------------------*/ 
  void H3dCameraNearClipShader::SetMaterialShaderParam( gfl::grp::g3d::H3dModel* p_model ,s32 mat_idx )
  {
    // VF[_[ւ
    const gfl::grp::g3d::H3dResShader* p_res = m_cpResource->GetResource();
    p_model->SetMaterialShader( mat_idx,*p_res );

    // RoCiݒ
    {
      p_model->SetMaterialTextureCombinerSourceAlpha( 
          mat_idx, WRITE_COMBINER_IDX, 1, 
          gfl::grp::g3d::H3dTextureCombinerExConst::SOURCE_PRIMARY_COLOR );
      p_model->SetMaterialTextureCombinerOperandAlpha( 
          mat_idx, WRITE_COMBINER_IDX, 1, 
          gfl::grp::g3d::H3dTextureCombinerExConst::OPERANDALPHA_SRC_ALPHA );
      p_model->SetMaterialTextureCombinerCombineAlpha( 
          mat_idx, WRITE_COMBINER_IDX, 
          gfl::grp::g3d::H3dTextureCombinerExConst::COMBINE_MODULATE );
      p_model->SetMaterialTextureCombinerScaleAlpha( 
          mat_idx, WRITE_COMBINER_IDX,
          gfl::grp::g3d::H3dTextureCombinerExConst::SCALE_ONE );
    }

    // u_[ݒ
    {
      // uh[h
      p_model->SetMaterialBlendMode( 
          mat_idx ,gfl::grp::g3d::H3dBlendExConst::MODE_SEPARATE_BLEND);

      // J[uh
      p_model->SetMaterialBlendEquationRgb( 
          mat_idx,gfl::grp::g3d::H3dBlendExConst::EQUATION_FUNC_ADD );
      p_model->SetMaterialBlendFunctionSourceRgb( 
          mat_idx,gfl::grp::g3d::H3dBlendExConst::FACTOR_SRC_ALPHA );
      // @todo Ă邩
      p_model->SetMaterialBlendFunctionDestinationRgb( 
          mat_idx,gfl::grp::g3d::H3dBlendExConst::FACTOR_ONE_MINUS_SRC_ALPHA );
      
      // At@uh
      p_model->SetMaterialBlendEquationAlpha( 
          mat_idx,gfl::grp::g3d::H3dBlendExConst::EQUATION_FUNC_ADD );
      p_model->SetMaterialBlendFunctionSourceAlpha( 
          mat_idx,gfl::grp::g3d::H3dBlendExConst::FACTOR_ONE );
      p_model->SetMaterialBlendFunctionDestinationAlpha( 
          mat_idx,gfl::grp::g3d::H3dBlendExConst::FACTOR_ZERO );
    }

    // XeVݒ
    {
      // GbW}bv̏񂪂邩`FbN
      const char* p_target_name = gfl::grp::g3d::G3DEdgeMapSystem::GetIDEdgeEnableTagName();
      s32 data_idx = p_model->GetMaterialUserDataIndex( mat_idx, p_target_name );
      if( data_idx >= 0 )
      {
        gfl::grp::g3d::H3dUserData user_data;
        p_model->GetMaterialUserData( mat_idx, data_idx, &user_data );
        if( user_data.GetDataType() != gfl::grp::g3d::H3dUserData::DATA_TYPE_INVALID )
        { 
          p_model->SetMaterialStencilTestEnable( mat_idx ,false );
          p_model->SetMaterialStencilTestFailOperation( 
              mat_idx ,gfl::grp::g3d::H3dStencilOperationExConst::STENCILOP_KEEP );
          p_model->SetMaterialStencilTestZFailOperation( 
              mat_idx ,gfl::grp::g3d::H3dStencilOperationExConst::STENCILOP_KEEP );
          p_model->SetMaterialStencilTestPassOperation( 
              mat_idx ,gfl::grp::g3d::H3dStencilOperationExConst::STENCILOP_KEEP );
        }
      }
    }

    // JO[h
    {
      p_model->SetMaterialRasterizationCullingMode( 
          mat_idx ,gfl::grp::g3d::H3dRasterizationExConst::CULLINGMODE_NONE);
    }

    // C[
    {
      p_model->SetMaterialTranslucencyKind( 
          mat_idx ,gfl::grp::g3d::H3dModel::MATERIAL_TRANSLUCENCY_KIND_LAYER1);
    }

    // fvXeXg
    {
      // res_depth_operation.SetFlags( nw::gfx::ResDepthOperation::FLAG_TEST_ENABLED | nw::gfx::ResDepthOperation::FLAG_MASK_ENABLED );
      p_model->SetMaterialDepthTestEnable( mat_idx ,true );
      p_model->SetMaterialDepthTestMaskEnable( mat_idx ,true );
    }

    // At@eXg
    {
      p_model->SetMaterialAlphaTestEnable( mat_idx ,false );
    }
  }

  // 
  //----------------------------------------------------------------------------
  /**
   *	@brief  ftHg̐ݒɖ߂B
   *
   *	@param	p_model   ftHgɖ߂f
   */
  //-----------------------------------------------------------------------------
  void H3dCameraNearClipShader::ResetShaderParam( gfl::grp::g3d::H3dModel* p_model )
  {
    if(m_IsShaderSetting){
      // VF[_[p[^ݒB
      for( u32 i=0; i<m_MaterialNum; ++i ){
        // ftHgp[^ɖ߂B
        this->ResetMaterialShaderParam( p_model ,i, m_pDefaultMaterialParam[i] );
      }
      m_IsShaderSetting = false;
    }
  }

  /* -------------------------------------------------------------------------*/
  /**
   * @brief }eÃVF[_[ݒZbg
   *
   * @param p_model ݒ肷郂f
   * @param mat_idx }eACfbNX
   * @param param   ftHg̃p[^
   */
  /* -------------------------------------------------------------------------*/
  void H3dCameraNearClipShader::ResetMaterialShaderParam( gfl::grp::g3d::H3dModel* p_model,u32 mat_idx , const DefaultMaterialParam& param )
  {
    // VF[_[̃Zbg
    p_model->ResetMaterialShader( mat_idx );

    // RoCiݒ
    {
      p_model->SetMaterialTextureCombinerSourceAlpha( 
          mat_idx, WRITE_COMBINER_IDX, 1, 
          param.m_DefaultAlphaSource1 );
      p_model->SetMaterialTextureCombinerOperandAlpha( 
          mat_idx, WRITE_COMBINER_IDX, 1, 
          param.m_DefaultAlphaOperand1 );
      p_model->SetMaterialTextureCombinerCombineAlpha( 
          mat_idx, WRITE_COMBINER_IDX, 
          param.m_DefaultAlphaCombine );
      p_model->SetMaterialTextureCombinerScaleAlpha( 
          mat_idx, WRITE_COMBINER_IDX,
          param.m_DefaultAlphaScale );
    }

    // u_[ݒ
    {
      p_model->SetMaterialBlendMode( 
          mat_idx ,param.m_DefaultBlendMode );
      p_model->SetMaterialBlendLogicOperation( 
          mat_idx,param.m_DefaultLogicOperation );
      p_model->SetMaterialBlendFunctionSourceRgb( 
          mat_idx,param.m_DefaultBlendSrcRGB );
      p_model->SetMaterialBlendFunctionDestinationRgb( 
          mat_idx,param.m_DefaultBlendDstRGB );
      p_model->SetMaterialBlendFunctionSourceAlpha( 
          mat_idx,param.m_DefaultBlendSrcAlpha );
      p_model->SetMaterialBlendFunctionDestinationAlpha( 
          mat_idx,param.m_DefaultBlendDstAlpha );
      p_model->SetMaterialBlendEquationRgb( 
          mat_idx,param.m_DefaultBlendEquationRGB );
      p_model->SetMaterialBlendEquationAlpha( 
          mat_idx,param.m_DefaultBlendEquationAlpha );

    }

    // JO[h
    {
      p_model->SetMaterialRasterizationCullingMode( 
          mat_idx ,param.m_DefaultCullingMode );
    }

    // XeVݒ
    {
      p_model->SetMaterialStencilTestEnable( 
          mat_idx , param.m_DefaultStencilTestEnable );
      p_model->SetMaterialStencilTestFailOperation( 
          mat_idx ,param.m_DefaultStencilFailOpe);
      p_model->SetMaterialStencilTestZFailOperation( 
          mat_idx ,param.m_DefaultStencilDepthFailOpe );
      p_model->SetMaterialStencilTestPassOperation( 
          mat_idx ,param.m_DefaultStencilPassOpe );
    }

    // C[
    {
      p_model->SetMaterialTranslucencyKind( 
          mat_idx ,param.m_DefaultLayer );
    }

    // fvXeXg
    {
      p_model->SetMaterialDepthTestEnable( 
          mat_idx ,param.m_DefaultDepthFlag );
    }

  }
  

} // namespace xy_system
