//============================================================================================
/**
 * @file		box_search_touchbar.h
 * @brief		{bNX ^b`o[
 * @author	Hiroyuki Nakamura
 * @date		12.08.21
 *
 * namespace	app::box_search::
 */
//============================================================================================
#if !defined( __BOX_SEARCH_TOUCHBAR_H__ )
#define __BOX_SEARCH_TOUCHBAR_H__

#include "app/ui/UITouchBarView.h"
#include "app/ui/UITouchBarListener.h"

namespace app {
namespace box_search {

class TouchBar : public app::ui::UITouchBarView, public app::ui::UITouchBarListener {
public:
	enum {
		PRM_NONE = 0,
		PRM_HOLD,
		PRM_SELECT_RETURN,
	};

public:
	TouchBar(
		app::util::Heap * heap,
		gfl::grp::GraphicsSystem * grasys,
		gfl::grp::g2d::LytSys * lytsys,
		gfl::grp::g2d::LytWk * lytwk );

	~TouchBar();

	u32 GetParam(void);
	void SelectKeyButton( u32 prm );


	virtual void Update(void);

	virtual bool OnSelectedButton( u32 buttonID );
//	virtual bool OnLongPressedButton( u32 buttonID );


private:
	u32	retParam;

};

}	// box_search
}	// app

#endif	// __BOX_SEARCH_TOUCHBAR_H__
