//============================================================================================
/**
 * @file		box_search_touchbar.cpp
 * @brief		{bNX ^b`o[
 * @author	Hiroyuki Nakamura
 * @date		12.08.21
 *
 * namespace	app::box_search::
 */
//============================================================================================
#include "box_search_res_pane.h"
#include "box_search_touchbar.h"

namespace app {
namespace box_search {

static const app::ui::UITouchBarView::SETUP TouchBarSetup[] =
{
	{ app::ui::UITouchBarView::BUTTON_ID_RETURN, PANENAME_BOX_SEARCH_LOWER_PANE_RETURN_ICON_POS },		// ߂{^
};


TouchBar::TouchBar(
		app::util::Heap * heap,
		gfl::grp::GraphicsSystem * grasys,
		gfl::grp::g2d::LytSys * lytsys,
		gfl::grp::g2d::LytWk * lytwk ) :
	app::ui::UITouchBarView( heap, grasys, lytsys, lytwk, TouchBarSetup, GFL_NELEMS(TouchBarSetup) ),
	retParam( PRM_NONE )
{
	app::ui::UITouchBarView::SetListener( this );
}

TouchBar::~TouchBar()
{
}

u32 TouchBar::GetParam(void)
{
	return retParam;
}

void TouchBar::Update(void)
{
	retParam = PRM_NONE;

	app::ui::UITouchBarView::Update();

	if( app::ui::UITouchBarView::IsButtonAnimation() == true ){
		if( retParam == PRM_NONE ){
			retParam = PRM_HOLD;
		}
	}
}

void TouchBar::SelectKeyButton( u32 prm )
{
	u32	buttonID;

	switch( prm ){
	case PRM_SELECT_RETURN:	// ߂{^
		buttonID = app::ui::UITouchBarView::BUTTON_ID_RETURN;
		break;
	default:
		GFL_ASSERT( 0 );
		return;
	}

	app::ui::UITouchBarView::StartSelectedAct( buttonID );
}



bool TouchBar::OnSelectedButton( u32 buttonID )
{
	switch( buttonID ){
	case app::ui::UITouchBarView::BUTTON_ID_RETURN:		// ߂{^
		retParam = PRM_SELECT_RETURN;
		break;
	default:
		break;
	}
	return false;
}


}	// box_search
}	// app
