
//=============================================================================
/**
 * @file   CameraGameTarget.cpp
 * @brief  Q[J^[QbgǗNX
 * @author rc N
 * @date   2012.09.28
 */
//=============================================================================

#include "CameraGameTarget.h"
#include "../player/FieldPlayerGrid.h"

namespace field
{
  //-----------------------------------------------------------------------------
  // RXgN^
  //-----------------------------------------------------------------------------
  CCameraGameTarget::CCameraGameTarget() :
  m_pTarget(NULL) ,
  m_inPosi(gfl::math::VEC3_ZERO) ,
  m_inDir(gfl::math::VEC3_UNIT_Z)
  {
    return ;
  }

  //-----------------------------------------------------------------------------
  // t[
  //-----------------------------------------------------------------------------
  void CCameraGameTarget::Update(const PlayerGrid* pTarget)
  {
    m_pTarget = pTarget;
    pTarget->GetPos(&m_inPosi);
    pTarget->GetModel()->GetWorldDirDispWay(&m_inDir);
  }

  //-----------------------------------------------------------------------------
  // fobO`
  //-----------------------------------------------------------------------------
  void CCameraGameTarget::DrawDebug()
  {
#if 0
    CDebugPrim::DrawArrow(m_inPosi, m_inDir, CONVERT_TO_METER(1.5f), VEC4_COLOR_PURPLE);
#endif
  }

} // namespace field

/*  EOF  */





