//==============================================================================
/**
 * @file	  PokeDiarySaveData.cpp
 * @brief   |P_CA[pZ[uf[^
 * @date    2012.09.28
 * @author  tamada
 */
// =============================================================================

#include "savedata/PokeDiarySaveData.h"
#include "system/dress_up/DressUpSaveFashion.h"

GFL_NAMESPACE_BEGIN(savedata)




//=============================================================================
//=============================================================================
//--------------------------------------------------------------------------
// RXgN^
//--------------------------------------------------------------------------
PokeDiarySaveData::PokeDiarySaveData( void )
{
NN_COMPILER_ASSERT(
    sizeof(savedata::PokeDiarySaveData::DIARY_FASHION_DATA)
    == sizeof(xy_system::dress_up::SaveFashionBuffer) );

	this->Clear( NULL );
}

//--------------------------------------------------------------------------
// fXgN^
//--------------------------------------------------------------------------
PokeDiarySaveData::~PokeDiarySaveData( void )
{
}

//--------------------------------------------------------------------------
/**
 * @brief		ǂݍ񂾃f[^Zbg֐
 * @param		pData		擪̃|C^
 */
//--------------------------------------------------------------------------
void PokeDiarySaveData::SetData(void* data)
{
	gfl::std::MemCopy(data, &m_data, sizeof(m_data) );
}
//--------------------------------------------------------------------------
/**
 * @brief    f[^̐擪|C^𓾂֐
 * @return   擪̃|C^
 */
//--------------------------------------------------------------------------
void* PokeDiarySaveData::GetData(void)
{
	return reinterpret_cast<void*>(&m_data);
}
//--------------------------------------------------------------------------
/**
 * @brief    f[^TCY
 * @retval   oCg
 */
//--------------------------------------------------------------------------
size_t PokeDiarySaveData::GetDataSize(void)
{
  return sizeof( CoreData );
}

//--------------------------------------------------------------------------
/**
 * @brief Z[uf[^̃NA
 * @param heap@NAɎgpe|q[v
 */
//--------------------------------------------------------------------------
void PokeDiarySaveData::Clear( gfl::heap::HeapBase * heap )
{
  GFL_PRINT("sizeof(PokeDiarySaveData) == %04x(%d)\n",GetDataSize(),GetDataSize() );
  gfl::std::MemClear( &m_data, GetDataSize() );
	GFL_UNUSED(heap);
}

GFL_NAMESPACE_END(savedata)
